/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.util.prefs;

import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.prefs.PreferencesUpgradeStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreferencesUpgrade {
    private static final Logger LOG = CommI18NFactory.getLogger(PreferencesUpgrade.class);
    private List<PreferencesUpgradeStep> m_upgradeSteps;

    public PreferencesUpgrade(List<PreferencesUpgradeStep> upgrade_steps) {
        this.m_upgradeSteps = upgrade_steps;
    }

    public void upgrade(Preferences preferences, int upgrade_to_version) {
        String version_pref_name = this.getConfigurationSchemaVersionPreference();
        int current_version = this.getConfigurationSchemaVersion(preferences);
        if (current_version < upgrade_to_version) {
            for (PreferencesUpgradeStep step : this.m_upgradeSteps) {
                int step_version = step.getSupportedConfigurationSchemaVersion();
                if (current_version < step_version) {
                    LOG.debug("PreferencesUpgrade.step-upgrading", new Object[]{version_pref_name, current_version, step_version});
                    step.upgrade(preferences);
                    this.setConfigurationSchemaVersion(preferences, step_version);
                    try {
                        preferences.flush();
                    }
                    catch (BackingStoreException e) {
                        throw new RuntimeException(e);
                    }
                    current_version = step_version;
                    LOG.debug("PreferencesUpgrade.step-upgraded", new Object[]{version_pref_name, current_version});
                }
                if (current_version < upgrade_to_version) continue;
                LOG.info("PreferencesUpgrade.upgrade-done", new Object[]{version_pref_name, current_version});
                break;
            }
            if (current_version < upgrade_to_version) {
                LOG.error("PreferencesUpgrade.still-not-uptodate", new Object[]{version_pref_name, upgrade_to_version, current_version});
            }
        } else {
            LOG.debug("PreferencesUpgrade.already-uptodate", new Object[]{version_pref_name, current_version});
        }
    }

    public int getConfigurationSchemaVersion(Preferences preferences) {
        return preferences.getInt(this.getConfigurationSchemaVersionPreference(), 0);
    }

    public void setConfigurationSchemaVersion(Preferences preferences, int version) {
        preferences.putInt(this.getConfigurationSchemaVersionPreference(), version);
    }

    public abstract String getConfigurationSchemaVersionPreference();
}

