/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveConfigurationLoader {
    private static LiveConfigurationLoader ourInstance = new LiveConfigurationLoader();
    private final Log log = LogFactory.getLog(LiveConfigurationLoader.class);
    private ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
    private SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();

    public static LiveConfigurationLoader getInstance() {
        return ourInstance;
    }

    public Map<Integer, Configuration> loadLiveResourceConfigurations(final Set<Resource> resources, long timeout) {
        try {
            FutureTask<Map<Integer, Configuration>> task = new FutureTask<Map<Integer, Configuration>>(new Callable<Map<Integer, Configuration>>(){

                @Override
                public Map<Integer, Configuration> call() throws Exception {
                    return LiveConfigurationLoader.this.loadLiveResourceConfigurations(resources);
                }
            });
            new Thread(task).start();
            return task.get(timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out after " + timeout + " seconds while retrieving live Resource configurations.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve live Resource configurations.", e);
        }
    }

    private Map<Integer, Configuration> loadLiveResourceConfigurations(Set<Resource> resources) throws Exception {
        this.log.info((Object)("Loading live configs for " + resources.size() + " Resources..."));
        long startTime = System.currentTimeMillis();
        HashMap<Integer, Configuration> liveConfigs = new HashMap<Integer, Configuration>();
        for (Resource resource : resources) {
            Configuration liveConfig = this.configurationManager.getLiveResourceConfiguration(this.subjectManager.getOverlord(), resource.getId(), false);
            if (liveConfig == null) {
                throw new Exception("Failed to obtain live Resource configuration for " + resource + ".");
            }
            liveConfigs.put(resource.getId(), liveConfig);
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        this.log.info((Object)("Loaded live configs for " + resources.size() + " Resources in " + elapsedTime + " ms."));
        return liveConfigs;
    }

    private LiveConfigurationLoader() {
    }
}

