/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.enterprise.server.core.CoreServerMBean;

public class CoreServer
extends ServiceMBeanSupport
implements CoreServerMBean {
    private final Log log = LogFactory.getLog(CoreServer.class);
    private static final String VERSION_FILE = "rhq-server-version.properties";
    private static final String PROP_PRODUCT_VERSION = "Product-Version";
    private static final String PROP_BUILD_NUMBER = "Build-Number";
    private static final String PROP_BUILD_DATE = "Build-Date";
    private Properties buildProps;
    private Date bootTime;

    protected void createService() throws Exception {
        this.buildProps = this.loadBuildProperties();
        this.bootTime = new Date();
        String version = this.getVersion();
        String buildNumber = this.getBuildNumber();
        String buildDate = this.buildProps.getProperty(PROP_BUILD_DATE, "?");
        this.log.info((Object)("Version=[" + version + "], Build Number=[" + buildNumber + "], Build Date=[" + buildDate + "]"));
    }

    public String getName() {
        return "RHQ Server";
    }

    public String getVersion() {
        return this.buildProps.getProperty(PROP_PRODUCT_VERSION, "?");
    }

    public String getBuildNumber() {
        return this.buildProps.getProperty(PROP_BUILD_NUMBER, "?");
    }

    public Date getBootTime() {
        return this.bootTime;
    }

    public File getInstallDir() {
        MBeanServer mbs = this.getMBeanServer();
        ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
        ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
        File homeDir = mbean.getHomeDir();
        return homeDir.getParentFile();
    }

    public File getJBossServerHomeDir() {
        MBeanServer mbs = this.getMBeanServer();
        ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
        ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
        File serverHomeDir = mbean.getServerHomeDir();
        return serverHomeDir;
    }

    public File getJBossServerDataDir() {
        MBeanServer mbs = this.getMBeanServer();
        ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
        ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
        File serverDataDir = mbean.getServerDataDir();
        return serverDataDir;
    }

    public File getJBossServerTempDir() {
        MBeanServer mbs = this.getMBeanServer();
        ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
        ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
        File serverTempDir = mbean.getServerTempDir();
        return serverTempDir;
    }

    private MBeanServer getMBeanServer() {
        return MBeanServerLocator.locateJBoss();
    }

    private Properties loadBuildProperties() {
        Properties buildProps = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            InputStream stream = classLoader.getResourceAsStream(VERSION_FILE);
            buildProps.load(stream);
            stream.close();
        }
        catch (Exception e) {
            this.log.fatal((Object)("Failed to load [rhq-server-version.properties] via class loader [" + classLoader + "]"));
        }
        return buildProps;
    }
}

