/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.comm;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownAgents
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, InvokerLocator> m_agents = new HashMap<String, InvokerLocator>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAgent(InvokerLocator endpoint) {
        boolean is_agent = this.isAgent(endpoint);
        if (is_agent) {
            Map<String, InvokerLocator> map = this.m_agents;
            synchronized (map) {
                this.m_agents.put(this.getEndpointKey(endpoint), endpoint);
            }
        }
        return is_agent;
    }

    public boolean addAgent(String endpoint) {
        try {
            return this.addAgent(new InvokerLocator(endpoint));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAgent(InvokerLocator endpoint) {
        InvokerLocator removed_agent;
        Map<String, InvokerLocator> map = this.m_agents;
        synchronized (map) {
            removed_agent = this.m_agents.remove(this.getEndpointKey(endpoint));
        }
        return removed_agent != null;
    }

    public boolean removeAgent(String endpoint) {
        try {
            return this.removeAgent(new InvokerLocator(endpoint));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvokerLocator getAgent(String host, int port) {
        Map<String, InvokerLocator> map = this.m_agents;
        synchronized (map) {
            return this.m_agents.get(this.getEndpointKey(host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InvokerLocator> getAllAgents() {
        ArrayList<InvokerLocator> ret_list;
        Map<String, InvokerLocator> map = this.m_agents;
        synchronized (map) {
            ret_list = new ArrayList<InvokerLocator>(this.m_agents.values());
        }
        return ret_list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAgents() {
        Map<String, InvokerLocator> map = this.m_agents;
        synchronized (map) {
            this.m_agents.clear();
        }
    }

    private boolean isAgent(InvokerLocator locator) {
        Map parameters = locator.getParameters();
        if (parameters == null || parameters.size() == 0) {
            return false;
        }
        String rhqtype = (String)parameters.get("rhq.communications.connector.rhqtype");
        return "agent".equals(rhqtype);
    }

    private String getEndpointKey(InvokerLocator endpoint) {
        return this.getEndpointKey(endpoint.getHost(), endpoint.getPort());
    }

    private String getEndpointKey(String host, int port) {
        return host + ":" + port;
    }
}

