/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.license;

import java.io.IOException;
import org.rhq.core.util.xmlparser.XmlAttr;
import org.rhq.core.util.xmlparser.XmlAttrException;
import org.rhq.core.util.xmlparser.XmlAttrHandler;
import org.rhq.core.util.xmlparser.XmlTagHandler;
import org.rhq.core.util.xmlparser.XmlTagInfo;
import org.rhq.enterprise.server.license.ExpirationTag;
import org.rhq.enterprise.server.license.LRES;
import org.rhq.enterprise.server.license.License;
import org.rhq.enterprise.server.license.LicenseManager;
import org.rhq.enterprise.server.license.LicenseeTag;
import org.rhq.enterprise.server.license.PlatformLimitTag;
import org.rhq.enterprise.server.license.PluginTag;
import org.rhq.enterprise.server.license.ServerIpTag;
import org.rhq.enterprise.server.license.SupportLevelTag;

final class LicenseTag
implements XmlTagHandler,
XmlAttrHandler {
    private License _license;
    private static final XmlAttr[] ATTRS = new XmlAttr[]{new XmlAttr(LRES.get("\"EF"), 0), new XmlAttr(LRES.get("`:I.\\{["), 1)};

    protected LicenseTag(License lic) {
        this._license = lic;
    }

    public String getName() {
        return LRES.get("VrLGr,Q");
    }

    protected License getLicense() {
        return this._license;
    }

    public XmlTagInfo[] getSubTags() {
        return new XmlTagInfo[]{new XmlTagInfo((XmlTagHandler)new LicenseeTag(this), 0), new XmlTagInfo((XmlTagHandler)new ExpirationTag(this), 0), new XmlTagInfo((XmlTagHandler)new ServerIpTag(this), 2), new XmlTagInfo((XmlTagHandler)new PlatformLimitTag(this), 0), new XmlTagInfo((XmlTagHandler)new PluginTag(this), 2), new XmlTagInfo((XmlTagHandler)new SupportLevelTag(this), 0)};
    }

    public XmlAttr[] getAttributes() {
        return ATTRS;
    }

    public void handleAttribute(int attrNumber, String value) throws XmlAttrException {
        if (attrNumber == 0) {
            this.setMasterKey(value);
        } else if (attrNumber == 1) {
            this.setVersion(value);
        } else {
            LicenseManager.doHalt("+( hW/8jQy*1/\"4mf.])8t9");
            throw new IllegalArgumentException();
        }
    }

    protected void setMasterKey(String s) {
        this._license.setMasterKey(s);
    }

    protected void setVersion(String v) {
        this._license.setVersion(v);
    }

    protected String generateKey() {
        String our_salt = LRES.get(LRES.getOurSalt());
        try {
            return LicenseTag.hash(String.valueOf(our_salt + "@" + System.currentTimeMillis()));
        }
        catch (Exception e) {
            LicenseManager.doHalt("VWVj{fb=yd{xpbIW*Kac", e);
            throw new IllegalStateException();
        }
    }

    protected String getMasterKey() {
        return this._license.getMasterKey();
    }

    protected String getVersion() {
        return this._license.getVersion();
    }

    protected static String hash(String s) throws IOException {
        return License.simpleHash(s);
    }
}

