/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.license;

import org.rhq.core.util.xmlparser.XmlAttrHandler;
import org.rhq.core.util.xmlparser.XmlTagException;
import org.rhq.core.util.xmlparser.XmlTagExitHandler;
import org.rhq.core.util.xmlparser.XmlTagHandler;
import org.rhq.enterprise.server.license.LRES;
import org.rhq.enterprise.server.license.License;
import org.rhq.enterprise.server.license.LicenseManager;
import org.rhq.enterprise.server.license.LicenseTag;

abstract class LicenseTermTag
implements XmlTagHandler,
XmlAttrHandler,
XmlTagExitHandler {
    private String our_salt = null;
    private License _license;
    private String _key;

    protected LicenseTermTag(LicenseTag lt) {
        this._license = lt.getLicense();
        this.our_salt = LRES.get(LRES.getOurSalt());
    }

    protected License getLicense() {
        return this._license;
    }

    protected void setKey(String key) {
        this._key = key;
    }

    protected void preValidate() {
    }

    protected abstract String getValidationComparisonValue();

    protected abstract void termValidated();

    public void exit() throws XmlTagException {
        String key = this.generateKey();
        if (!key.equals(this._key)) {
            throw new IllegalStateException();
        }
        this.termValidated();
    }

    protected String generateKey() {
        String value = this.getValidationComparisonValue();
        if (value == null || value.length() == 0) {
            LicenseManager.doHalt("rkwuQ<8=4_@8 hu(]qmf");
            throw new IllegalStateException();
        }
        try {
            return LicenseTag.hash(value + this.our_salt + value.charAt(0) + this.getName() + "$" + this._license.getMasterKey());
        }
        catch (Exception e) {
            LicenseManager.doHalt("VWVjhu=$Xd{xpbIW*Kac", e);
            throw new IllegalStateException();
        }
    }
}

