/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective.activator.context;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.ResourceTypeFacet;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.perspective.activator.context.AbstractResourceOrGroupActivationContext;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceActivationContext
extends AbstractResourceOrGroupActivationContext {
    private Resource resource;
    private Set<Resource> resourceAsSet;
    transient EnumSet<ResourceTypeFacet> facets;
    transient EnumSet<Permission> resourcePermissions;
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
    private AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();

    public ResourceActivationContext(Subject subject, Resource resource) {
        super(subject);
        this.resource = resource;
        this.resourceAsSet = new HashSet<Resource>(1);
        this.resourceAsSet.add(resource);
    }

    @Override
    public ResourceType getResourceType() {
        return this.resource.getResourceType();
    }

    @Override
    public EnumSet<ResourceTypeFacet> getFacets() {
        if (this.facets == null) {
            ResourceFacets resourceFacets = this.resourceTypeManager.getResourceFacets(this.resource.getResourceType().getId());
            this.facets = resourceFacets.getFacets();
        }
        return this.facets;
    }

    @Override
    public boolean hasResourcePermission(Permission permission) {
        return this.hasGlobalPermission(Permission.MANAGE_INVENTORY) || this.getResourcePermissions().contains(permission);
    }

    @Override
    protected EnumSet<Permission> getResourcePermissions() {
        if (this.resourcePermissions == null) {
            Set<Permission> perms = this.authorizationManager.getImplicitResourcePermissions(this.getSubject(), this.resource.getId());
            this.resourcePermissions = EnumSet.copyOf(perms);
        }
        return this.resourcePermissions;
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public Set<Resource> getResources() {
        return this.resourceAsSet;
    }
}

