/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.tagging;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDestination;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.TagCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.tagging.Tag;
import org.rhq.core.domain.tagging.compsite.TagReportComposite;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.tagging.TagManagerLocal;
import org.rhq.enterprise.server.tagging.TagManagerRemote;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class TagManagerBean
implements TagManagerLocal,
TagManagerRemote {
    private final Log log = LogFactory.getLog(TagManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @Override
    public PageList<Tag> findTagsByCriteria(Subject subject, TagCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public Set<Tag> addTags(Subject subject, Set<Tag> tags) {
        HashSet<Tag> results = new HashSet<Tag>();
        for (Tag tag : tags) {
            TagCriteria criteria = new TagCriteria();
            criteria.addFilterNamespace(tag.getNamespace());
            criteria.addFilterSemantic(tag.getSemantic());
            criteria.addFilterName(tag.getName());
            criteria.setStrict(true);
            PageList<Tag> found = this.findTagsByCriteria(subject, criteria);
            if (!found.isEmpty()) {
                assert (found.size() == 1);
                results.add((Tag)found.get(0));
                continue;
            }
            this.entityManager.persist((Object)tag);
            results.add(tag);
        }
        return results;
    }

    @Override
    public void removeTags(Subject subject, Set<Tag> tags) {
        for (Tag tag : tags) {
            this.entityManager.remove(this.entityManager.find(Tag.class, (Object)tag.getId()));
        }
    }

    @Override
    public void updateResourceTags(Subject subject, int resourceId, Set<Tag> tags) {
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.MODIFY_RESOURCE, resourceId)) {
            throw new PermissionException("You do not have permission to modify resource");
        }
        Set<Tag> definedTags = this.addTags(subject, tags);
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        HashSet previousTags = new HashSet(resource.getTags());
        previousTags.removeAll(definedTags);
        for (Tag tag : previousTags) {
            tag.removeResource(resource);
        }
        for (Tag tag : definedTags) {
            tag.addResource(resource);
        }
    }

    @Override
    public void updateResourceGroupTags(Subject subject, int resourceGroupId, Set<Tag> tags) {
        if (!this.authorizationManager.hasGroupPermission(subject, Permission.MODIFY_RESOURCE, resourceGroupId)) {
            throw new PermissionException("You do not have permission to modify group");
        }
        Set<Tag> definedTags = this.addTags(subject, tags);
        ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)resourceGroupId);
        HashSet previousTags = new HashSet(group.getTags());
        previousTags.removeAll(definedTags);
        for (Tag tag : previousTags) {
            tag.removeResourceGroup(group);
        }
        for (Tag tag : definedTags) {
            tag.addResourceGroup(group);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void updateBundleTags(Subject subject, int bundleId, Set<Tag> tags) {
        Set<Tag> definedTags = this.addTags(subject, tags);
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
        HashSet previousTags = new HashSet(bundle.getTags());
        previousTags.removeAll(definedTags);
        for (Tag tag : previousTags) {
            tag.removeBundle(bundle);
        }
        for (Tag tag : definedTags) {
            tag.addBundle(bundle);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void updateBundleVersionTags(Subject subject, int bundleVersionId, Set<Tag> tags) {
        Set<Tag> definedTags = this.addTags(subject, tags);
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        HashSet previousTags = new HashSet(bundleVersion.getTags());
        previousTags.removeAll(definedTags);
        for (Tag tag : previousTags) {
            tag.removeBundleVersion(bundleVersion);
        }
        for (Tag tag : definedTags) {
            tag.addBundleVersion(bundleVersion);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void updateBundleDeploymentTags(Subject subject, int bundleDeploymentId, Set<Tag> tags) {
        Set<Tag> definedTags = this.addTags(subject, tags);
        BundleDeployment bundleDeployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        HashSet previousTags = new HashSet(bundleDeployment.getTags());
        previousTags.removeAll(definedTags);
        for (Tag tag : previousTags) {
            tag.removeBundleDeployment(bundleDeployment);
        }
        for (Tag tag : definedTags) {
            tag.addBundleDeployment(bundleDeployment);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void updateBundleDestinationTags(Subject subject, int bundleDestinationId, Set<Tag> tags) {
        Set<Tag> definedTags = this.addTags(subject, tags);
        BundleDestination bundleDestination = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)bundleDestinationId);
        HashSet previousTags = new HashSet(bundleDestination.getTags());
        previousTags.removeAll(definedTags);
        for (Tag tag : previousTags) {
            tag.removeBundleDestination(bundleDestination);
        }
        for (Tag tag : definedTags) {
            tag.addBundleDestination(bundleDestination);
        }
    }

    @Override
    public PageList<TagReportComposite> findTagReportCompositesByCriteria(Subject subject, TagCriteria tagCriteria) {
        Query query = this.entityManager.createNamedQuery("Tag.compositeReport");
        PageList result = new PageList();
        result.addAll((Collection)query.getResultList());
        return result;
    }
}

