/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.updater.DeploymentProperties;

public class DeploymentData {
    private final DeploymentProperties deploymentProps;
    private final Set<File> zipFiles;
    private final Map<File, File> rawFiles;
    private final File destinationDir;
    private final Map<File, Pattern> zipEntriesToRealizeRegex;
    private final Set<File> rawFilesToRealize;
    private final TemplateEngine templateEngine;
    private final Pattern ignoreRegex;

    public DeploymentData(DeploymentProperties deploymentProps, Set<File> zipFiles, Map<File, File> rawFiles, File destinationDir, Map<File, Pattern> zipEntriesToRealizeRegex, Set<File> rawFilesToRealize, TemplateEngine templateEngine, Pattern ignoreRegex) {
        if (deploymentProps == null) {
            throw new IllegalArgumentException("deploymentProps == null");
        }
        if (destinationDir == null) {
            throw new IllegalArgumentException("destDir == null");
        }
        if (zipFiles == null) {
            zipFiles = new HashSet<File>();
        }
        if (rawFiles == null) {
            rawFiles = new HashMap<File, File>();
        }
        if (zipFiles.size() == 0 && rawFiles.size() == 0) {
            throw new IllegalArgumentException("zipFiles/rawFiles are empty - nothing to do");
        }
        this.deploymentProps = deploymentProps;
        this.zipFiles = zipFiles;
        this.rawFiles = rawFiles;
        this.destinationDir = destinationDir;
        this.ignoreRegex = ignoreRegex;
        if (templateEngine == null || zipEntriesToRealizeRegex == null && rawFilesToRealize == null) {
            this.zipEntriesToRealizeRegex = null;
            this.rawFilesToRealize = null;
            this.templateEngine = null;
        } else {
            this.zipEntriesToRealizeRegex = zipEntriesToRealizeRegex;
            this.rawFilesToRealize = rawFilesToRealize;
            this.templateEngine = templateEngine;
        }
    }

    public DeploymentProperties getDeploymentProps() {
        return this.deploymentProps;
    }

    public Set<File> getZipFiles() {
        return this.zipFiles;
    }

    public Map<File, File> getRawFiles() {
        return this.rawFiles;
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public Map<File, Pattern> getZipEntriesToRealizeRegex() {
        return this.zipEntriesToRealizeRegex;
    }

    public Set<File> getRawFilesToRealize() {
        return this.rawFilesToRealize;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public Pattern getIgnoreRegex() {
        return this.ignoreRegex;
    }
}

