/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.server.ExternalizableStrategy;
import org.rhq.enterprise.client.RemoteClient;

public class RemoteClientProxy
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(RemoteClientProxy.class);
    private RemoteClient client;
    private RemoteClient.Manager manager;

    public RemoteClientProxy(RemoteClient client, RemoteClient.Manager manager) {
        this.client = client;
        this.manager = manager;
    }

    public Class getRemoteInterface() {
        return this.manager.remote();
    }

    public static <T> T getProcessor(RemoteClient remoteClient, RemoteClient.Manager manager) {
        try {
            RemoteClientProxy gpc = new RemoteClientProxy(remoteClient, manager);
            Class intf = RemoteClientProxy.simplifyInterface(gpc.manager.remote());
            return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{intf}, (InvocationHandler)gpc);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get remote connection proxy", e);
        }
    }

    private static Class simplifyInterface(Class intf) {
        try {
            CtMethod[] methods;
            ClassPool cp = ClassPool.getDefault();
            String simpleName = intf.getName() + "Simple";
            try {
                CtClass cached = cp.get(simpleName);
                return Class.forName(simpleName, false, cp.getClassLoader());
            }
            catch (NotFoundException e) {
            }
            catch (ClassNotFoundException e) {
                LOG.debug((Object)("Class [" + simpleName + "] not found - cause: " + e));
            }
            CtClass cc = cp.get(intf.getName());
            CtClass cz = cp.getAndRename(intf.getName(), simpleName);
            cz.defrost();
            cz.setSuperclass(cc);
            for (CtMethod originalMethod : methods = cc.getMethods()) {
                CtClass[] params = originalMethod.getParameterTypes();
                if (params.length <= 0 || !params[0].getName().equals(Subject.class.getName())) continue;
                CtClass[] simpleParams = new CtClass[params.length - 1];
                System.arraycopy(params, 1, simpleParams, 0, params.length - 1);
                cz.defrost();
                CtMethod newMethod = CtNewMethod.abstractMethod((CtClass)originalMethod.getReturnType(), (String)originalMethod.getName(), (CtClass[])simpleParams, null, (CtClass)cz);
                ParameterAnnotationsAttribute originalAnnotationsAttribute = (ParameterAnnotationsAttribute)originalMethod.getMethodInfo().getAttribute("RuntimeVisibleParameterAnnotations");
                if (originalAnnotationsAttribute != null) {
                    Annotation[][] originalAnnotations = originalAnnotationsAttribute.getAnnotations();
                    Annotation[][] newAnnotations = new Annotation[originalAnnotations.length - 1][];
                    for (int i = 1; i < originalAnnotations.length; ++i) {
                        newAnnotations[i - 1] = new Annotation[originalAnnotations[i].length];
                        System.arraycopy(originalAnnotations[i], 0, newAnnotations[i - 1], 0, originalAnnotations[i].length);
                    }
                    ParameterAnnotationsAttribute newAnnotationsAttribute = new ParameterAnnotationsAttribute(newMethod.getMethodInfo().getConstPool(), "RuntimeVisibleParameterAnnotations");
                    newAnnotationsAttribute.setAnnotations((Annotation[][])newAnnotations);
                    newMethod.getMethodInfo().addAttribute((AttributeInfo)newAnnotationsAttribute);
                }
                cz.addMethod(newMethod);
            }
            return cz.toClass();
        }
        catch (NotFoundException e) {
            LOG.debug((Object)("Failed to simplify " + intf + " - cause: " + (Object)((Object)e)));
        }
        catch (CannotCompileException e) {
            LOG.error((Object)("Failed to simplify " + intf + "."), (Throwable)e);
        }
        return intf;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            ExternalizableStrategy.setStrategy((ExternalizableStrategy.Subsystem)ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION);
            String methodName = this.manager.beanName() + ":" + method.getName();
            Class[] params = method.getParameterTypes();
            try {
                Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();
                Class<?> originalClass = interfaces != null && interfaces.length > 0 ? interfaces[0] : method.getDeclaringClass();
                originalClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                int numArgs = null == args ? 0 : args.length;
                Object[] newArgs = new Object[numArgs + 1];
                if (numArgs > 0) {
                    System.arraycopy(args, 0, newArgs, 1, numArgs);
                }
                newArgs[0] = this.client.getSubject();
                args = newArgs;
                int numParams = null == params ? 0 : params.length;
                Class[] newParams = new Class[numParams + 1];
                if (numParams > 0) {
                    System.arraycopy(params, 0, newParams, 1, numParams);
                }
                newParams[0] = Subject.class;
                params = newParams;
            }
            String[] paramSig = this.createParamSignature(params);
            NameBasedInvocation request = new NameBasedInvocation(methodName, args, paramSig);
            Object response = this.client.getRemotingClient().invoke((Object)request);
            if (response instanceof Throwable) {
                throw (Throwable)response;
            }
            return response;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    private String[] createParamSignature(Class[] types) {
        String[] paramSig = new String[types.length];
        for (int x = 0; x < types.length; ++x) {
            paramSig[x] = types[x].getName();
        }
        return paramSig;
    }
}

