/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.google.inject.internal.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.testng.IClass;
import org.testng.IMethodSelector;
import org.testng.IObjectFactory;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.internal.Parameters;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassHelper {
    private static final String JUNIT_TESTRUNNER = "org.testng.junit.JUnitTestRunner";
    private static final List<ClassLoader> m_classLoaders = new Vector<ClassLoader>();
    private static int m_lastGoodRootIndex = -1;

    public static void addClassLoader(ClassLoader loader) {
        m_classLoaders.add(loader);
    }

    private ClassHelper() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            return instance;
        }
        catch (IllegalAccessException iae) {
            throw new TestNGException("Class " + clazz.getName() + " does not have a no-args constructor", iae);
        }
        catch (InstantiationException ie) {
            throw new TestNGException("Cannot instantiate class " + clazz.getName(), ie);
        }
        catch (ExceptionInInitializerError eiierr) {
            throw new TestNGException("An exception occurred in static initialization of class " + clazz.getName(), eiierr);
        }
        catch (SecurityException se) {
            throw new TestNGException(se);
        }
    }

    public static Class<?> forName(String className) {
        Vector<ClassLoader> allClassLoaders = new Vector<ClassLoader>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            allClassLoaders.add(contextClassLoader);
        }
        if (m_classLoaders != null) {
            allClassLoaders.addAll(m_classLoaders);
        }
        int count = 0;
        for (ClassLoader classLoader : allClassLoaders) {
            ++count;
            if (null == classLoader) continue;
            try {
                return classLoader.loadClass(className);
            }
            catch (Exception ex) {
                if (null != m_classLoaders && m_classLoaders.size() != 0) continue;
                ClassHelper.logInstantiationError(className, ex);
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            ClassHelper.logInstantiationError(className, cnfe);
            return null;
        }
    }

    private static void logInstantiationError(String className, Exception ex) {
        Utils.log("ClassHelper", 2, "Could not instantiate " + className + ": " + ex.getMessage());
    }

    public static Method findFactoryMethod(Class<?> cls, IAnnotationFinder finder) {
        Method result = null;
        for (Method method : cls.getMethods()) {
            IAnnotation f = finder.findAnnotation(method, IFactoryAnnotation.class);
            if (null == f) continue;
            if (null != result) {
                throw new TestNGException(cls.getName() + ":  only one @Factory method allowed");
            }
            result = method;
        }
        return result;
    }

    public static Set<Method> getAvailableMethods(Class<?> clazz) {
        HashSet methods = Sets.newHashSet();
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        for (Class<?> parent = clazz.getSuperclass(); Object.class != parent; parent = parent.getSuperclass()) {
            methods.addAll(ClassHelper.extractMethods(clazz, parent, methods));
        }
        return methods;
    }

    public static IJUnitTestRunner createTestRunner(TestRunner runner) {
        try {
            IJUnitTestRunner tr = (IJUnitTestRunner)ClassHelper.forName(JUNIT_TESTRUNNER).newInstance();
            tr.setTestResultNotifier(runner);
            return tr;
        }
        catch (Exception ex) {
            throw new TestNGException("Cannot create JUnit runner org.testng.junit.JUnitTestRunner", ex);
        }
    }

    private static Set<Method> extractMethods(Class<?> childClass, Class<?> clazz, Set<Method> collected) {
        HashSet methods = Sets.newHashSet();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Package childPackage = childClass.getPackage();
        Package classPackage = clazz.getPackage();
        boolean isSamePackage = false;
        if (null == childPackage && null == classPackage) {
            isSamePackage = true;
        }
        if (null != childPackage && null != classPackage) {
            isSamePackage = childPackage.getName().equals(classPackage.getName());
        }
        for (Method method : declaredMethods) {
            int methodModifiers = method.getModifiers();
            if (!Modifier.isPublic(methodModifiers) && !Modifier.isProtected(methodModifiers) && (!isSamePackage || Modifier.isPrivate(methodModifiers)) || ClassHelper.isOverridden(method, collected) || Modifier.isAbstract(methodModifiers)) continue;
            methods.add(method);
        }
        return methods;
    }

    private static boolean isOverridden(Method method, Set<Method> collectedMethods) {
        Class<?> methodClass = method.getDeclaringClass();
        Class<?>[] methodParams = method.getParameterTypes();
        for (Method m : collectedMethods) {
            Class<?>[] paramTypes = m.getParameterTypes();
            if (!method.getName().equals(m.getName()) || !methodClass.isAssignableFrom(m.getDeclaringClass()) || methodParams.length != paramTypes.length) continue;
            boolean sameParameters = true;
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i].equals(paramTypes[i])) continue;
                sameParameters = false;
                break;
            }
            if (!sameParameters) continue;
            return true;
        }
        return false;
    }

    public static IMethodSelector createSelector(XmlMethodSelector selector) {
        try {
            Class<?> cls = Class.forName(selector.getClassName());
            return (IMethodSelector)cls.newInstance();
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't find method selector : " + selector.getClassName(), ex);
        }
    }

    public static Object createInstance(Class<?> declaringClass, Map<Class, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder, IObjectFactory objectFactory) {
        Object result;
        try {
            Constructor<?> constructor = ClassHelper.findAnnotatedConstructor(finder, declaringClass);
            if (null != constructor) {
                IParametersAnnotation annotation = (IParametersAnnotation)finder.findAnnotation(constructor, IParametersAnnotation.class);
                String[] parameterNames = annotation.getValue();
                Object[] parameters = Parameters.createInstantiationParameters(constructor, "@Parameters", finder, parameterNames, xmlTest.getParameters(), xmlTest.getSuite());
                result = objectFactory.newInstance(constructor, parameters);
            } else {
                boolean isStatic;
                Class[] parameterTypes = new Class[]{};
                Object[] parameters = new Object[]{};
                Class<?> ec = ClassHelper.getEnclosingClass(declaringClass);
                boolean bl = isStatic = 0 != (declaringClass.getModifiers() & 8);
                if (null != ec && !isStatic) {
                    Object[] enclosingInstances;
                    parameterTypes = new Class[]{ec};
                    IClass enclosingIClass = classes.get(ec);
                    if (null != enclosingIClass) {
                        enclosingInstances = enclosingIClass.getInstances(false);
                        if (null == enclosingInstances || enclosingInstances.length == 0) {
                            Object o = objectFactory.newInstance(ec.getConstructor(parameterTypes), new Object[0]);
                            enclosingIClass.addInstance(o);
                            enclosingInstances = new Object[]{o};
                        }
                    } else {
                        enclosingInstances = new Object[]{ec.newInstance()};
                    }
                    Object enclosingClassInstance = enclosingInstances[0];
                    parameters = new Object[]{enclosingClassInstance};
                }
                Constructor<?> ct = declaringClass.getDeclaredConstructor(parameterTypes);
                result = objectFactory.newInstance(ct, parameters);
            }
        }
        catch (TestNGException ex) {
            throw ex;
        }
        catch (NoSuchMethodException ex) {
            result = ClassHelper.tryOtherConstructor(declaringClass);
        }
        catch (Throwable cause) {
            throw new TestNGException("An error occurred while instantiating class " + declaringClass.getName() + ": " + cause.getMessage(), cause);
        }
        if (null == result) {
            throw new TestNGException("An error occurred while instantiating class " + declaringClass.getName() + ". Check to make sure it can be accessed/instantiated.");
        }
        return result;
    }

    private static Class<?> getEnclosingClass(Class<?> declaringClass) {
        Class<?> result = null;
        String className = declaringClass.getName();
        int index = className.indexOf("$");
        if (index != -1) {
            String ecn = className.substring(0, index);
            try {
                result = Class.forName(ecn);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static Constructor<?> findAnnotatedConstructor(IAnnotationFinder finder, Class<?> declaringClass) {
        Constructor<?>[] constructors = declaringClass.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] parameterTypes;
            Constructor<?> result = constructors[i];
            IParametersAnnotation annotation = (IParametersAnnotation)finder.findAnnotation(result, IParametersAnnotation.class);
            if (null == annotation) continue;
            String[] parameters = annotation.getValue();
            if (parameters.length != (parameterTypes = result.getParameterTypes()).length) {
                throw new TestNGException("Parameter count mismatch:  " + result + "\naccepts " + parameterTypes.length + " parameters but the @Test annotation declares " + parameters.length);
            }
            return result;
        }
        return null;
    }

    public static <T> T tryOtherConstructor(Class<T> declaringClass) {
        T result;
        try {
            if (declaringClass.getModifiers() == 0) {
                return null;
            }
            Constructor<T> ctor = declaringClass.getConstructor(String.class);
            result = ctor.newInstance("Default test name");
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            String error = "Could not create an instance of class " + declaringClass + (message != null ? ": " + message : "") + ".\nPlease make sure it has a constructor that accepts either a String or no parameter.";
            throw new TestNGException(error);
        }
        return result;
    }

    public static Class<?> fileToClass(String file) {
        int i;
        String className;
        Class<?> result = null;
        if (!file.endsWith(".class") && !file.endsWith(".java")) {
            result = ClassHelper.forName(file);
            if (null == result) {
                throw new TestNGException("Cannot load class from file: " + file);
            }
            return result;
        }
        int classIndex = file.lastIndexOf(".class");
        if (-1 == classIndex) {
            classIndex = file.lastIndexOf(".java");
        }
        String shortFileName = file.substring(0, classIndex);
        String[] segments = shortFileName.split("[/\\\\]", -1);
        if (-1 != m_lastGoodRootIndex) {
            className = segments[m_lastGoodRootIndex];
            for (i = m_lastGoodRootIndex + 1; i < segments.length; ++i) {
                className = className + "." + segments[i];
            }
            result = ClassHelper.forName(className);
            if (null != result) {
                return result;
            }
        }
        className = null;
        for (i = segments.length - 1; i >= 0; --i) {
            result = ClassHelper.forName(className = null == className ? segments[i] : segments[i] + "." + className);
            if (null == result) continue;
            m_lastGoodRootIndex = i;
            break;
        }
        if (null == result) {
            throw new TestNGException("Cannot load class from file: " + file);
        }
        return result;
    }
}

