/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.Map;
import org.testng.IClass;
import org.testng.IObjectFactory;
import org.testng.ITest;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassImpl
implements IClass {
    private transient Class m_class = null;
    private transient Object m_defaultInstance = null;
    private XmlTest m_xmlTest = null;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient List<Object> m_instances = Lists.newArrayList();
    private transient Map<Class, IClass> m_classes = null;
    private int m_instanceCount;
    private long[] m_instanceHashCodes;
    private Object m_instance;
    private IObjectFactory m_objectFactory;
    private String m_testName = null;
    private XmlClass m_xmlClass;

    public ClassImpl(Class cls, XmlClass xmlClass, Object instance, Map<Class, IClass> classes, XmlTest xmlTest, IAnnotationFinder annotationFinder, IObjectFactory objectFactory) {
        this.m_class = cls;
        this.m_classes = classes;
        this.m_xmlClass = xmlClass;
        this.m_xmlTest = xmlTest;
        this.m_annotationFinder = annotationFinder;
        this.m_instance = instance;
        this.m_objectFactory = objectFactory;
        if (instance instanceof ITest) {
            this.m_testName = ((ITest)instance).getTestName();
        }
    }

    private static void ppp(String s) {
        System.out.println("[ClassImpl] " + s);
    }

    @Override
    public String getTestName() {
        return this.m_testName;
    }

    @Override
    public String getName() {
        return this.m_class.getName();
    }

    @Override
    public Class getRealClass() {
        return this.m_class;
    }

    @Override
    public int getInstanceCount() {
        return this.m_instanceCount;
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_instanceHashCodes;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    private Object getDefaultInstance() {
        if (this.m_defaultInstance == null) {
            this.m_defaultInstance = this.m_instance != null ? this.m_instance : ClassHelper.createInstance(this.m_class, this.m_classes, this.m_xmlTest, this.m_annotationFinder, this.m_objectFactory);
        }
        return this.m_defaultInstance;
    }

    @Override
    public Object[] getInstances(boolean create) {
        Object[] result = new Object[]{};
        if (this.m_xmlTest.isJUnit()) {
            if (create) {
                result = new Object[]{ClassHelper.createInstance(this.m_class, this.m_classes, this.m_xmlTest, this.m_annotationFinder, this.m_objectFactory)};
            }
        } else {
            result = new Object[]{this.getDefaultInstance()};
        }
        if (this.m_instances.size() > 0) {
            result = this.m_instances.toArray(new Object[this.m_instances.size()]);
        }
        this.m_instanceCount = this.m_instances.size();
        this.m_instanceHashCodes = new long[this.m_instanceCount];
        for (int i = 0; i < this.m_instanceCount; ++i) {
            this.m_instanceHashCodes[i] = this.m_instances.get(i).hashCode();
        }
        return result;
    }

    public String toString() {
        return "[ClassImpl " + this.m_class.getName() + "]";
    }

    @Override
    public void addInstance(Object instance) {
        this.m_instances.add(instance);
    }
}

