/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.alert.notification.AlertNotificationLog;
import org.rhq.core.domain.alert.notification.ResultState;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.server.MeasurementConverter;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.alert.AlertConditionLogManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerRemote;
import org.rhq.enterprise.server.alert.i18n.AlertI18NFactory;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.core.EmailManagerLocal;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.measurement.util.MeasurementFormatter;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderPluginManager;
import org.rhq.enterprise.server.plugin.pc.alert.AlertServerPluginContainer;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class AlertManagerBean
implements AlertManagerLocal,
AlertManagerRemote {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    private final Log log = LogFactory.getLog(AlertManagerBean.class);
    @EJB
    @IgnoreDependency
    private AlertConditionLogManagerLocal alertConditionLogManager;
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    @IgnoreDependency
    private ResourceManagerLocal resourceManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    @IgnoreDependency
    private OperationManagerLocal operationManager;
    @EJB
    private EmailManagerLocal emailManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    private static String NEW_LINE = System.getProperty("line.separator");

    @Override
    public Alert createAlert(Alert alert) {
        this.entityManager.persist((Object)alert);
        return alert;
    }

    @Override
    public int deleteAlerts(Subject user, int[] alertIds) {
        if (alertIds == null || alertIds.length == 0) {
            return 0;
        }
        List alertIdList = ArrayUtils.wrapInList((int[])alertIds);
        this.checkAlertsPermission(user, alertIdList);
        Query deleteConditionLogsQuery = this.entityManager.createNamedQuery("AlertConditionLog.deleteByAlertIds");
        Query deleteNotifLogsQuery = this.entityManager.createNamedQuery("AlertNotificationLog.deleteByAlertIds");
        Query deleteAlertsQuery = this.entityManager.createNamedQuery("Alert.deleteByIds");
        int updated = 0;
        BatchIterator batchIter = new BatchIterator(alertIdList);
        while (batchIter.hasMoreBatches()) {
            List nextBatch = batchIter.getNextBatch();
            deleteConditionLogsQuery.setParameter("alertIds", nextBatch);
            deleteConditionLogsQuery.executeUpdate();
            deleteNotifLogsQuery.setParameter("alertIds", nextBatch);
            deleteNotifLogsQuery.executeUpdate();
            deleteAlertsQuery.setParameter("alertIds", nextBatch);
            updated += deleteAlertsQuery.executeUpdate();
        }
        return updated;
    }

    @Override
    public int acknowledgeAlerts(Subject subject, int[] alertIds) {
        if (alertIds == null || alertIds.length == 0) {
            return 0;
        }
        List alertIdList = ArrayUtils.wrapInList((int[])alertIds);
        this.checkAlertsPermission(subject, alertIdList);
        Query ackAlertsQuery = this.entityManager.createNamedQuery("Alert.acknowledgeByIds");
        ackAlertsQuery.setParameter("subjectName", (Object)subject.getName());
        ackAlertsQuery.setParameter("ackTime", (Object)System.currentTimeMillis());
        int modified = 0;
        BatchIterator batchIter = new BatchIterator(alertIdList);
        while (batchIter.hasMoreBatches()) {
            List nextBatch = batchIter.getNextBatch();
            ackAlertsQuery.setParameter("alertIds", nextBatch);
            modified += ackAlertsQuery.executeUpdate();
        }
        return modified;
    }

    @Override
    public int deleteAlertsByContext(Subject subject, EntityContext context) {
        Query deleteConditionLogsQuery = null;
        Query deleteNotificationLogsQuery = null;
        Query deleteAlertsQuery = null;
        if (context.type == EntityContext.Type.Resource) {
            if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_ALERTS, context.resourceId)) {
                throw new PermissionException("Can not delete alerts - " + subject + " lacks " + Permission.MANAGE_ALERTS + " for resource[id=" + context.resourceId + "]");
            }
            deleteConditionLogsQuery = this.entityManager.createNamedQuery("AlertConditionLog.deleteByResources");
            deleteConditionLogsQuery.setParameter("resourceIds", Arrays.asList(context.resourceId));
            deleteNotificationLogsQuery = this.entityManager.createNamedQuery("AlertNotificationLog.deleteByResources");
            deleteNotificationLogsQuery.setParameter("resourceIds", Arrays.asList(context.resourceId));
            deleteAlertsQuery = this.entityManager.createNamedQuery("Alert.deleteByResources");
            deleteAlertsQuery.setParameter("resourceIds", Arrays.asList(context.resourceId));
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            if (!this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_ALERTS, context.groupId)) {
                throw new PermissionException("Can not delete alerts - " + subject + " lacks " + Permission.MANAGE_ALERTS + " for group[id=" + context.groupId + "]");
            }
            deleteConditionLogsQuery = this.entityManager.createNamedQuery("AlertConditionLog.deleteByResourceGroups");
            deleteConditionLogsQuery.setParameter("groupIds", Arrays.asList(context.groupId));
            deleteNotificationLogsQuery = this.entityManager.createNamedQuery("AlertNotificationLog.deleteByResourceGroups");
            deleteNotificationLogsQuery.setParameter("groupIds", Arrays.asList(context.groupId));
            deleteAlertsQuery = this.entityManager.createNamedQuery("Alert.deleteByResourceGroups");
            deleteAlertsQuery.setParameter("groupIds", Arrays.asList(context.groupId));
        } else if (context.type == EntityContext.Type.SubsystemView) {
            if (!this.authorizationManager.isInventoryManager(subject)) {
                throw new PermissionException("Can not delete alerts - " + subject + " lacks " + Permission.MANAGE_INVENTORY + " for global alerts history");
            }
            deleteConditionLogsQuery = this.entityManager.createNamedQuery("AlertConditionLog.deleteByAll");
            deleteNotificationLogsQuery = this.entityManager.createNamedQuery("AlertNotificationLog.deleteByAll");
            deleteAlertsQuery = this.entityManager.createNamedQuery("Alert.deleteByAll");
        } else {
            throw new IllegalArgumentException("No support for deleting alerts for " + context);
        }
        deleteConditionLogsQuery.executeUpdate();
        deleteNotificationLogsQuery.executeUpdate();
        int affectedRows = deleteAlertsQuery.executeUpdate();
        return affectedRows;
    }

    @Override
    public int acknowledgeAlertsByContext(Subject subject, EntityContext context) {
        Query query = null;
        if (context.type == EntityContext.Type.Resource) {
            if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_ALERTS, context.resourceId)) {
                throw new PermissionException("Can not acknowledge alerts - " + subject + " lacks " + Permission.MANAGE_ALERTS + " for resource[id=" + context.resourceId + "]");
            }
            query = this.entityManager.createNamedQuery("Alert.acknowledgeByResources");
            query.setParameter("resourceIds", Arrays.asList(context.resourceId));
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            if (!this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_ALERTS, context.groupId)) {
                throw new PermissionException("Can not acknowledge alerts - " + subject + " lacks " + Permission.MANAGE_ALERTS + " for group[id=" + context.groupId + "]");
            }
            query = this.entityManager.createNamedQuery("Alert.acknowledgeByResourceGroups");
            query.setParameter("groupIds", Arrays.asList(context.groupId));
        } else if (context.type == EntityContext.Type.SubsystemView) {
            if (!this.authorizationManager.isInventoryManager(subject)) {
                throw new PermissionException("Can not acknowledge alerts - " + subject + " lacks " + Permission.MANAGE_INVENTORY + " for global alerts history");
            }
            query = this.entityManager.createNamedQuery("Alert.acknowledgeByAll");
        } else {
            throw new IllegalArgumentException("No support for acknowledging alerts for " + context);
        }
        query.setParameter("subjectName", (Object)subject.getName());
        query.setParameter("ackTime", (Object)System.currentTimeMillis());
        int affectedRows = query.executeUpdate();
        return affectedRows;
    }

    private void checkAlertsPermission(Subject subject, List<Integer> alertIds) {
        if (this.authorizationManager.isInventoryManager(subject)) {
            return;
        }
        long canModifyCount = this.checkAuthz(subject, alertIds);
        long canNotModifyCount = (long)alertIds.size() - canModifyCount;
        if (canNotModifyCount != 0L) {
            List<Integer> validAlertIds = this.removeNonExistent(alertIds);
            if (validAlertIds.size() == alertIds.size()) {
                throw new PermissionException(subject + " does not have permission to delete " + canNotModifyCount + " of the " + alertIds.size() + " passsed alertIds");
            }
            canModifyCount = this.checkAuthz(subject, alertIds);
            canNotModifyCount = (long)alertIds.size() - canModifyCount;
            if (canNotModifyCount != 0L) {
                throw new PermissionException(subject + " does not have permission to delete " + canNotModifyCount + " of the " + alertIds.size() + " passsed alertIds");
            }
        }
    }

    private long checkAuthz(Subject subject, List<Integer> alertIds) {
        Query authzQuery = this.entityManager.createNamedQuery("Alert.checkPermissionByIds");
        authzQuery.setParameter("subjectId", (Object)subject.getId());
        authzQuery.setParameter("permission", (Object)Permission.MANAGE_ALERTS);
        long canModifyCount = 0L;
        BatchIterator<Integer> batchIter = new BatchIterator<Integer>(alertIds);
        while (batchIter.hasMoreBatches()) {
            List<Integer> nextBatch = batchIter.getNextBatch();
            authzQuery.setParameter("alertIds", nextBatch);
            canModifyCount += ((Long)authzQuery.getSingleResult()).longValue();
        }
        return canModifyCount;
    }

    private List<Integer> removeNonExistent(List<Integer> alertIds) {
        Query authzQuery = this.entityManager.createNamedQuery("Alert.returnExistingIds");
        ArrayList<Integer> existingAlertIds = new ArrayList<Integer>();
        BatchIterator<Integer> batchIter = new BatchIterator<Integer>(alertIds);
        while (batchIter.hasMoreBatches()) {
            List<Integer> nextBatch = batchIter.getNextBatch();
            authzQuery.setParameter("alertIds", nextBatch);
            existingAlertIds.addAll(authzQuery.getResultList());
        }
        return existingAlertIds;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=21600)
    public int deleteAlerts(long beginTime, long endTime) {
        long totalTime = 0L;
        long start = System.currentTimeMillis();
        Query query = this.entityManager.createNamedQuery("AlertConditionLog.deleteByAlertCTime");
        query.setParameter("begin", (Object)beginTime);
        query.setParameter("end", (Object)endTime);
        int conditionsDeleted = query.executeUpdate();
        long end = System.currentTimeMillis();
        this.log.debug((Object)("Deleted [" + conditionsDeleted + "] alert condition logs in [" + (end - start) + "]ms"));
        totalTime += end - start;
        start = System.currentTimeMillis();
        query = this.entityManager.createNamedQuery("AlertNotificationLog.deleteByAlertCtime");
        query.setParameter("begin", (Object)beginTime);
        query.setParameter("end", (Object)endTime);
        int deletedNotifications = query.executeUpdate();
        end = System.currentTimeMillis();
        this.log.debug((Object)("Deleted [" + deletedNotifications + "] alert notifications in [" + (end - start) + "]ms"));
        totalTime += end - start;
        start = System.currentTimeMillis();
        query = this.entityManager.createNamedQuery("Alert.deleteByCTime");
        query.setParameter("begin", (Object)beginTime);
        query.setParameter("end", (Object)endTime);
        int deletedAlerts = query.executeUpdate();
        end = System.currentTimeMillis();
        this.log.debug((Object)("Deleted [" + deletedAlerts + "] alerts in [" + (end - start) + "]ms"));
        MeasurementMonitor.getMBean().incrementPurgeTime(totalTime += end - start);
        MeasurementMonitor.getMBean().setPurgedAlerts(deletedAlerts);
        MeasurementMonitor.getMBean().setPurgedAlertConditions(conditionsDeleted);
        MeasurementMonitor.getMBean().setPurgedAlertNotifications(deletedNotifications);
        this.log.debug((Object)("Deleted [" + (deletedAlerts + conditionsDeleted + deletedNotifications) + "] " + "alert audit records in [" + totalTime + "]ms"));
        return deletedAlerts;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=21600)
    public int purgeAlerts() {
        int n;
        long totalTime = 0L;
        Connection conn = null;
        PreparedStatement truncateConditionLogsStatement = null;
        PreparedStatement truncateNotificationLogsStatement = null;
        PreparedStatement truncateAlertsStatement = null;
        try {
            conn = this.rhqDs.getConnection();
            truncateConditionLogsStatement = conn.prepareStatement("TRUNCATE TABLE RHQ_ALERT_CONDITION_LOG");
            truncateNotificationLogsStatement = conn.prepareStatement("TRUNCATE TABLE RHQ_ALERT_NOTIF_LOG");
            truncateAlertsStatement = conn.prepareStatement("TRUNCATE TABLE RHQ_ALERT");
            long start = System.currentTimeMillis();
            int purgedConditions = truncateConditionLogsStatement.executeUpdate();
            long end = System.currentTimeMillis();
            this.log.debug((Object)("Purged [" + purgedConditions + "] alert condition logs in [" + (end - start) + "]ms"));
            totalTime += end - start;
            start = System.currentTimeMillis();
            int purgedNotifications = truncateNotificationLogsStatement.executeUpdate();
            end = System.currentTimeMillis();
            this.log.debug((Object)("Purged [" + purgedNotifications + "] alert notifications in [" + (end - start) + "]ms"));
            totalTime += end - start;
            start = System.currentTimeMillis();
            int purgedAlerts = truncateAlertsStatement.executeUpdate();
            end = System.currentTimeMillis();
            this.log.debug((Object)("Purged [" + purgedAlerts + "] alerts in [" + (end - start) + "]ms"));
            MeasurementMonitor.getMBean().incrementPurgeTime(totalTime += end - start);
            MeasurementMonitor.getMBean().setPurgedAlerts(purgedAlerts);
            MeasurementMonitor.getMBean().setPurgedAlertConditions(purgedConditions);
            MeasurementMonitor.getMBean().setPurgedAlertNotifications(purgedNotifications);
            this.log.debug((Object)("Deleted [" + (purgedAlerts + purgedConditions + purgedNotifications) + "] " + "alert audit records in [" + totalTime + "]ms"));
            n = purgedAlerts;
        }
        catch (SQLException sqle) {
            try {
                this.log.error((Object)"Error purging alerts", (Throwable)sqle);
                throw new RuntimeException("Error purging alerts: " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(truncateConditionLogsStatement);
                JDBCUtil.safeClose(truncateNotificationLogsStatement);
                JDBCUtil.safeClose(truncateAlertsStatement);
                JDBCUtil.safeClose((Connection)conn);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Statement)truncateConditionLogsStatement);
        JDBCUtil.safeClose((Statement)truncateNotificationLogsStatement);
        JDBCUtil.safeClose((Statement)truncateAlertsStatement);
        JDBCUtil.safeClose((Connection)conn);
        return n;
    }

    @Override
    public int getAlertCountByMeasurementDefinitionId(Integer measurementDefinitionId, long begin, long end) {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Alert.findByMeasurementDefinitionId");
        query.setParameter("measurementDefinitionId", (Object)measurementDefinitionId);
        query.setParameter("begin", (Object)begin);
        query.setParameter("end", (Object)end);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    @Override
    public int getAlertCountByMeasurementDefinitionAndResources(int measurementDefinitionId, int[] resourceIds, long beginDate, long endDate) {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Alert.findByMeasDefIdAndResources");
        query.setParameter("measurementDefinitionId", (Object)measurementDefinitionId);
        query.setParameter("startDate", (Object)beginDate);
        query.setParameter("endDate", (Object)endDate);
        query.setParameter("resourceIds", (Object)ArrayUtils.wrapInList((int[])resourceIds));
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    @Override
    public int getAlertCountByMeasurementDefinitionAndResourceGroup(int measurementDefinitionId, int groupId, long beginDate, long endDate) {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Alert.findByMeasDefIdAndResourceGroup");
        query.setParameter("measurementDefinitionId", (Object)measurementDefinitionId);
        query.setParameter("startDate", (Object)beginDate);
        query.setParameter("endDate", (Object)endDate);
        query.setParameter("groupId", (Object)groupId);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    @Override
    public int getAlertCountByMeasurementDefinitionAndAutoGroup(int measurementDefinitionId, int resourceParentId, int resourceTypeId, long beginDate, long endDate) {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Alert.findByMeasDefIdAndAutoGroup");
        query.setParameter("measurementDefinitionId", (Object)measurementDefinitionId);
        query.setParameter("startDate", (Object)beginDate);
        query.setParameter("endDate", (Object)endDate);
        query.setParameter("parentId", (Object)resourceParentId);
        query.setParameter("typeId", (Object)resourceTypeId);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    @Override
    public int getAlertCountByMeasurementDefinitionAndResource(int measurementDefinitionId, int resourceId, long beginDate, long endDate) {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Alert.findByMeasDefIdAndResource");
        query.setParameter("measurementDefinitionId", (Object)measurementDefinitionId);
        query.setParameter("startDate", (Object)beginDate);
        query.setParameter("endDate", (Object)endDate);
        query.setParameter("resourceId", (Object)resourceId);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    @Override
    public Map<Integer, Integer> getAlertCountForSchedules(long begin, long end, List<Integer> scheduleIds) {
        if (scheduleIds == null || scheduleIds.size() == 0 || end < begin) {
            return new HashMap<Integer, Integer>();
        }
        int BATCH_SIZE = 1000;
        int numSched = scheduleIds.size();
        int rounds = numSched / 1000 + 1;
        HashMap<Integer, Integer> resMap = new HashMap<Integer, Integer>();
        for (int round = 0; round < rounds; ++round) {
            int fromIndex = round * 1000;
            int toIndex = fromIndex + 1000;
            if (toIndex > numSched) {
                toIndex = numSched;
            }
            List<Integer> scheds = scheduleIds.subList(fromIndex, toIndex);
            if (fromIndex == toIndex) continue;
            Query q = this.entityManager.createNamedQuery("Alert.QUERY_GET_ALERT_COUNT_FOR_SCHEDULES");
            q.setParameter("startDate", (Object)begin);
            q.setParameter("endDate", (Object)end);
            q.setParameter("schedIds", scheds);
            List ret = q.getResultList();
            if (ret.size() <= 0) continue;
            for (Object[] obj : ret) {
                Integer scheduleId = (Integer)obj[0];
                Long tmp = (Long)obj[1];
                int alertCount = tmp.intValue();
                resMap.put(scheduleId, alertCount);
            }
        }
        for (int scheduleId : scheduleIds) {
            if (resMap.containsKey(scheduleId)) continue;
            resMap.put(scheduleId, 0);
        }
        return resMap;
    }

    private void fetchCollectionFields(Alert alert) {
        alert.getConditionLogs().size();
        for (AlertConditionLog log : alert.getConditionLogs()) {
            if (log.getCondition() == null || log.getCondition().getMeasurementDefinition() == null) continue;
            log.getCondition().getMeasurementDefinition().getId();
        }
        alert.getAlertNotificationLogs().size();
    }

    private void fetchCollectionFields(List<Alert> alerts) {
        for (Alert alert : alerts) {
            this.fetchCollectionFields(alert);
        }
    }

    @Override
    public void fireAlert(int alertDefinitionId) {
        this.log.debug((Object)("Firing an alert for alertDefinition with id=" + alertDefinitionId + "..."));
        Subject overlord = this.subjectManager.getOverlord();
        AlertDefinition alertDefinition = this.alertDefinitionManager.getAlertDefinitionById(overlord, alertDefinitionId);
        Alert newAlert = new Alert(alertDefinition, System.currentTimeMillis());
        this.createAlert(newAlert);
        this.log.debug((Object)("New alert identifier=" + newAlert.getId()));
        List<AlertConditionLog> unmatchedConditionLogs = this.alertConditionLogManager.getUnmatchedLogsByAlertDefinitionId(alertDefinitionId);
        for (AlertConditionLog unmatchedLog : unmatchedConditionLogs) {
            this.log.debug((Object)("Matched alert condition log for alertId=" + newAlert.getId() + ": " + unmatchedLog));
            newAlert.addConditionLog(unmatchedLog);
        }
        this.processRecovery(alertDefinition);
        this.sendAlertNotifications(newAlert);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void sendAlertNotifications(Alert alert) {
        try {
            this.log.debug((Object)("Sending alert notifications for " + alert.toSimpleString() + "..."));
            List alertNotifications = alert.getAlertDefinition().getAlertNotifications();
            AlertSenderPluginManager alertSenderPluginManager = this.getAlertPluginManager();
            for (AlertNotification alertNotification : alertNotifications) {
                AlertNotificationLog notificationLog = null;
                String senderName = alertNotification.getSenderName();
                if (senderName == null) {
                    notificationLog = new AlertNotificationLog(alert, senderName, ResultState.FAILURE, "Sender '" + senderName + "' is not defined");
                } else {
                    AlertSender notificationSender = alertSenderPluginManager.getAlertSenderForNotification(alertNotification);
                    if (notificationSender == null) {
                        notificationLog = new AlertNotificationLog(alert, senderName, ResultState.FAILURE, "Failed to obtain a sender with given name");
                    } else {
                        try {
                            SenderResult result = notificationSender.send(alert);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)result);
                            }
                            notificationLog = result == null ? new AlertNotificationLog(alert, senderName, ResultState.UNKNOWN, "Sender did not return any result") : new AlertNotificationLog(alert, senderName, result);
                        }
                        catch (Throwable t) {
                            this.log.error((Object)("Notification processing terminated abruptly" + t.getMessage()));
                            notificationLog = new AlertNotificationLog(alert, senderName, ResultState.FAILURE, "Notification processing terminated abruptly, cause: " + t.getMessage());
                        }
                    }
                }
                this.entityManager.persist((Object)notificationLog);
                alert.addAlertNotificatinLog(notificationLog);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to send all notifications for " + alert.toSimpleString()), t);
        }
    }

    @Override
    public AlertSenderPluginManager getAlertPluginManager() {
        MasterServerPluginContainer container = LookupUtil.getServerPluginService().getMasterPluginContainer();
        if (container == null) {
            this.log.warn((Object)(MasterServerPluginContainer.class.getSimpleName() + " is not started yet"));
            return null;
        }
        AlertServerPluginContainer pc = container.getPluginContainerByClass(AlertServerPluginContainer.class);
        if (pc == null) {
            this.log.warn((Object)(AlertServerPluginContainer.class.getSimpleName() + " has not been loaded by the " + MasterServerPluginContainer.class.getSimpleName() + " yet"));
            return null;
        }
        AlertSenderPluginManager manager = (AlertSenderPluginManager)pc.getPluginManager();
        return manager;
    }

    @Override
    public Collection<String> sendAlertNotificationEmails(Alert alert, Collection<String> emailAddresses) {
        this.log.debug((Object)("Sending alert notifications for " + alert.toSimpleString() + "..."));
        if (emailAddresses.size() == 0) {
            return new ArrayList<String>(0);
        }
        AlertDefinition alertDefinition = alert.getAlertDefinition();
        Map<String, String> alertMessage = this.emailManager.getAlertEmailMessage(this.prettyPrintResourceHierarchy(alertDefinition.getResource()), alertDefinition.getResource().getName(), alertDefinition.getName(), alertDefinition.getPriority().toString(), new Date(alert.getCtime()).toString(), this.prettyPrintAlertConditions(alert.getConditionLogs(), false), this.prettyPrintAlertURL(alert));
        String messageSubject = alertMessage.keySet().iterator().next();
        String messageBody = alertMessage.values().iterator().next();
        HashSet<String> uniqueAddresses = new HashSet<String>(emailAddresses);
        Collection<String> badAddresses = this.emailManager.sendEmail(uniqueAddresses, messageSubject, messageBody);
        if (this.log.isDebugEnabled()) {
            if (badAddresses.isEmpty()) {
                this.log.debug((Object)("All notifications for " + alert.toSimpleString() + " succeeded"));
            } else {
                this.log.debug((Object)("Sending email notifications for " + badAddresses + " failed"));
            }
        }
        return badAddresses;
    }

    private String prettyPrintResourceHierarchy(org.rhq.core.domain.resource.Resource resource) {
        StringBuilder builder = new StringBuilder();
        List<org.rhq.core.domain.resource.Resource> lineage = this.resourceManager.getResourceLineage(resource.getId());
        int depth = 0;
        for (org.rhq.core.domain.resource.Resource res : lineage) {
            if (depth == 0) {
                builder.append(" - ");
            } else {
                int i;
                builder.append(NEW_LINE);
                for (i = 0; i < depth; ++i) {
                    builder.append("   ");
                }
                builder.append("|");
                builder.append(NEW_LINE);
                for (i = 0; i < depth; ++i) {
                    builder.append("   ");
                }
                builder.append("+- ");
            }
            builder.append(res.getName());
            ++depth;
        }
        return builder.toString();
    }

    @Override
    public String prettyPrintAlertConditions(Alert alert, boolean shortVersion) {
        return this.prettyPrintAlertConditions(alert.getConditionLogs(), shortVersion);
    }

    private String prettyPrintAlertConditions(Set<AlertConditionLog> conditionLogs, boolean shortVersion) {
        StringBuilder builder = new StringBuilder();
        int conditionCounter = 1;
        for (AlertConditionLog aLog : conditionLogs) {
            String formattedValue = null;
            try {
                formattedValue = MeasurementConverter.format(Double.valueOf(aLog.getValue()), aLog.getCondition().getMeasurementDefinition().getUnits(), true);
            }
            catch (Exception e) {
                formattedValue = aLog.getValue();
            }
            builder.append(NEW_LINE);
            String format = shortVersion ? "alert.email.condition.log.format.short" : "alert.email.condition.log.format";
            SimpleDateFormat dateFormat = shortVersion ? new SimpleDateFormat("yy/MM/dd HH:mm:ss z") : new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
            builder.append(AlertI18NFactory.getMessage(format, conditionCounter, this.prettyPrintAlertCondition(aLog.getCondition(), shortVersion), dateFormat.format(new Date(aLog.getCtime())), formattedValue));
            ++conditionCounter;
        }
        return builder.toString();
    }

    private String prettyPrintAlertCondition(AlertCondition condition, boolean shortVersion) {
        StringBuilder builder = new StringBuilder();
        AlertConditionCategory category = condition.getCategory();
        if (category == AlertConditionCategory.CONTROL) {
            try {
                Integer resourceTypeId = condition.getAlertDefinition().getResource().getResourceType().getId();
                String operationName = condition.getName();
                OperationDefinition definition = this.operationManager.getOperationDefinitionByResourceTypeAndName(resourceTypeId, operationName, false);
                builder.append(definition.getDisplayName()).append(' ');
            }
            catch (Exception e) {
                builder.append(condition.getName()).append(' ');
            }
        } else if (category.getName() != null) {
            builder.append(condition.getName()).append(' ');
        }
        if (category == AlertConditionCategory.CONTROL) {
            builder.append(condition.getOption());
        } else if (category == AlertConditionCategory.THRESHOLD || category == AlertConditionCategory.BASELINE) {
            builder.append(condition.getComparator());
            builder.append(' ');
            MeasurementSchedule schedule = null;
            double value = condition.getThreshold();
            MeasurementUnits units = category == AlertConditionCategory.THRESHOLD ? condition.getMeasurementDefinition().getUnits() : MeasurementUnits.PERCENTAGE;
            String formatted = MeasurementConverter.format(value, units, true);
            builder.append(formatted);
            if (category == AlertConditionCategory.BASELINE) {
                builder.append(" of ");
                builder.append(MeasurementFormatter.getBaselineText(condition.getOption(), schedule));
            }
        } else if (category == AlertConditionCategory.RESOURCE_CONFIG || category == AlertConditionCategory.CHANGE || category == AlertConditionCategory.TRAIT) {
            if (shortVersion) {
                builder.append(AlertI18NFactory.getMessage("alert.current.list.ValueChanged.short", new Object[0]));
            } else {
                builder.append(AlertI18NFactory.getMessage("alert.current.list.ValueChanged", new Object[0]));
            }
        } else if (category == AlertConditionCategory.EVENT) {
            if (condition.getOption() != null && condition.getOption().length() > 0) {
                String propsCbEventSeverityRegexMatch = shortVersion ? "alert.config.props.CB.EventSeverity.RegexMatch.short" : "alert.config.props.CB.EventSeverity.RegexMatch";
                builder.append(AlertI18NFactory.getMessage(propsCbEventSeverityRegexMatch, condition.getName(), condition.getOption()));
            } else if (shortVersion) {
                builder.append(AlertI18NFactory.getMessage("alert.config.props.CB.EventSeverity.short", condition.getName()));
            } else {
                builder.append(AlertI18NFactory.getMessage("alert.config.props.CB.EventSeverity", condition.getName()));
            }
        } else if (category == AlertConditionCategory.AVAILABILITY) {
            if (shortVersion) {
                builder.append(AlertI18NFactory.getMessage("alert.config.props.CB.Availability.short", condition.getOption()));
            } else {
                builder.append(AlertI18NFactory.getMessage("alert.config.props.CB.Availability", condition.getOption()));
            }
        }
        return builder.toString();
    }

    @Override
    public String prettyPrintAlertURL(Alert alert) {
        StringBuilder builder = new StringBuilder();
        String baseUrl = this.systemManager.getSystemConfiguration().getProperty("CAM_BASE_URL");
        builder.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            builder.append("/");
        }
        builder.append("coregui/CoreGUI.html#Resource/");
        builder.append(alert.getAlertDefinition().getResource().getId());
        builder.append("/Alerts/History/");
        builder.append(alert.getId());
        return builder.toString();
    }

    private void processRecovery(AlertDefinition firedDefinition) {
        Subject overlord = this.subjectManager.getOverlord();
        Integer recoveryDefinitionId = firedDefinition.getRecoveryId();
        if (recoveryDefinitionId != 0) {
            this.log.debug((Object)"Processing recovery rules...");
            this.log.debug((Object)("Found recoveryDefinitionId " + recoveryDefinitionId));
            AlertDefinition toBeRecoveredDefinition = this.alertDefinitionManager.getAlertDefinitionById(overlord, recoveryDefinitionId);
            boolean wasEnabled = toBeRecoveredDefinition.getEnabled();
            this.log.debug((Object)(firedDefinition + (wasEnabled ? "does not need to recover " : "needs to recover ") + toBeRecoveredDefinition + (wasEnabled ? ", it was already enabled " : ", it was currently disabled ")));
            if (!wasEnabled) {
                this.alertDefinitionManager.enableAlertDefinitions(overlord, new int[]{recoveryDefinitionId});
            }
        } else if (firedDefinition.getWillRecover()) {
            this.log.debug((Object)("Disabling " + firedDefinition + " until recovered manually or by recovery definition"));
            this.alertDefinitionManager.disableAlertDefinitions(overlord, new int[]{firedDefinition.getId()});
        }
    }

    @Override
    public boolean willDefinitionBeDisabled(Alert alert) {
        this.entityManager.refresh((Object)alert);
        AlertDefinition firedDefinition = alert.getAlertDefinition();
        Subject overlord = this.subjectManager.getOverlord();
        Integer recoveryDefinitionId = firedDefinition.getRecoveryId();
        if (recoveryDefinitionId != 0) {
            AlertDefinition toBeRecoveredDefinition = this.alertDefinitionManager.getAlertDefinitionById(overlord, recoveryDefinitionId);
            boolean wasEnabled = toBeRecoveredDefinition.getEnabled();
            if (!wasEnabled) {
                return false;
            }
        } else if (firedDefinition.getWillRecover()) {
            return true;
        }
        return false;
    }

    @Override
    public PageList<Alert> findAlertsByCriteria(Subject subject, AlertCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, "alertDefinition.resource", subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList alerts = queryRunner.execute();
        this.fetchCollectionFields((List<Alert>)alerts);
        return alerts;
    }

    @Override
    public long findAlertCountByCriteria(Subject subject, AlertCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, "alertDefinition.resource", subject.getId());
        }
        Query countQuery = generator.getCountQuery(this.entityManager);
        long count = (Long)countQuery.getSingleResult();
        return count;
    }

    class BatchIterator<T> {
        public static final int DEFAULT_BATCH_SIZE = 1000;
        private int batchSize;
        private int index;
        private List<T> data;

        public BatchIterator(List<T> data) {
            this(data, 1000);
        }

        public BatchIterator(List<T> data, int batchSize) {
            this.batchSize = batchSize;
            this.index = 0;
            this.data = data;
        }

        public boolean hasMoreBatches() {
            return this.index < this.data.size();
        }

        public List<T> getNextBatch() {
            List<T> batch = null;
            if (this.index + this.batchSize < this.data.size()) {
                batch = this.data.subList(this.index, this.index + this.batchSize);
                this.index += this.batchSize;
            } else {
                batch = this.data.subList(this.index, this.data.size());
                this.index = this.data.size();
            }
            return batch;
        }
    }
}

