/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.resource.Agent;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheCoordinator;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AlertConditionCacheManagerBean
implements AlertConditionCacheManagerLocal {
    private static final Log log = LogFactory.getLog(AlertConditionCacheManagerBean.class);
    @EJB
    private ServerManagerLocal serverManager;

    @Override
    public AlertConditionCacheStats checkConditions(MeasurementData ... measurementData) {
        AlertConditionCacheStats stats = AlertConditionCacheCoordinator.getInstance().checkConditions(measurementData);
        return stats;
    }

    @Override
    public AlertConditionCacheStats checkConditions(CallTimeData ... callTimeData) {
        AlertConditionCacheStats stats = AlertConditionCacheCoordinator.getInstance().checkConditions(callTimeData);
        return stats;
    }

    @Override
    public AlertConditionCacheStats checkConditions(OperationHistory operationHistory) {
        AlertConditionCacheStats stats = AlertConditionCacheCoordinator.getInstance().checkConditions(operationHistory);
        return stats;
    }

    @Override
    public AlertConditionCacheStats checkConditions(Availability ... availabilities) {
        AlertConditionCacheStats stats = AlertConditionCacheCoordinator.getInstance().checkConditions(availabilities);
        return stats;
    }

    @Override
    public AlertConditionCacheStats checkConditions(EventSource source, Event ... events) {
        AlertConditionCacheStats stats = AlertConditionCacheCoordinator.getInstance().checkConditions(source, events);
        return stats;
    }

    @Override
    public AlertConditionCacheStats checkConditions(ResourceConfigurationUpdate update) {
        AlertConditionCacheStats stats = AlertConditionCacheCoordinator.getInstance().checkConditions(update);
        return stats;
    }

    @Override
    public void reloadCachesForAgent(int agentId) {
        AlertConditionCacheCoordinator.getInstance().reloadCachesForAgent(agentId);
    }

    @Override
    public void reloadGlobalCache() {
        AlertConditionCacheCoordinator.getInstance().reloadGlobalCache();
    }

    @Override
    public void reloadAllCaches() {
        this.reloadGlobalCache();
        List<Agent> agents = this.serverManager.getAgents();
        for (Agent agent : agents) {
            this.reloadCachesForAgent(agent.getId());
        }
    }
}

