/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.internal;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheCoordinator;
import org.rhq.enterprise.server.alert.engine.model.AbstractCacheElement;
import org.rhq.enterprise.server.alert.engine.model.AlertConditionOperator;
import org.rhq.enterprise.server.alert.engine.model.UnsupportedAlertConditionOperatorException;

class AlertConditionCacheUtils {
    private static final Log log = LogFactory.getLog(AlertConditionCacheCoordinator.class);

    AlertConditionCacheUtils() {
    }

    public static AlertConditionOperator getAlertConditionOperator(AlertConditionCategory category, String comparator, String conditionOption) {
        if (category == AlertConditionCategory.CONTROL) {
            return AlertConditionOperator.EQUALS;
        }
        if (category == AlertConditionCategory.EVENT) {
            return AlertConditionOperator.GREATER_THAN_OR_EQUAL_TO;
        }
        if (category == AlertConditionCategory.RESOURCE_CONFIG || category == AlertConditionCategory.CHANGE || category == AlertConditionCategory.TRAIT) {
            return AlertConditionOperator.CHANGES;
        }
        if (category == AlertConditionCategory.AVAILABILITY) {
            AvailabilityType conditionOptionType = AvailabilityType.valueOf((String)conditionOption.toUpperCase());
            if (conditionOptionType == AvailabilityType.DOWN) {
                return AlertConditionOperator.CHANGES_FROM;
            }
            if (conditionOptionType == AvailabilityType.UP) {
                return AlertConditionOperator.CHANGES_TO;
            }
            throw new UnsupportedAlertConditionOperatorException("Invalid alertCondition for AVAILABILITY category");
        }
        if (comparator.equals("<")) {
            return AlertConditionOperator.LESS_THAN;
        }
        if (comparator.equals(">")) {
            return AlertConditionOperator.GREATER_THAN;
        }
        if (comparator.equals("=")) {
            return AlertConditionOperator.EQUALS;
        }
        throw new UnsupportedAlertConditionOperatorException("Comparator '" + comparator + "' " + "is not supported for ArtifactConditionCategory." + category.name());
    }

    public static String getCacheElementErrorString(int conditionId, AlertConditionOperator operator, Object option, Object value) {
        return "id=" + conditionId + ", " + "operator=" + (Object)((Object)operator) + ", " + (option != null ? "option=" + option + ", " : "") + "value=" + value;
    }

    public static <T extends AbstractCacheElement<?>> void printListCache(String cacheName, Map<Integer, List<T>> cache) {
        log.debug((Object)("Printing " + cacheName + "..."));
        for (Map.Entry<Integer, List<T>> cacheElement : cache.entrySet()) {
            log.debug((Object)("key=" + cacheElement.getKey() + ", " + "value=" + cacheElement.getValue()));
        }
    }

    public static <T extends AbstractCacheElement<?>> void printNestedCache(String cacheName, Map<Integer, Map<Integer, List<T>>> nestedCache) {
        log.debug((Object)("Printing " + cacheName + "..."));
        for (Map.Entry<Integer, Map<Integer, List<T>>> cache : nestedCache.entrySet()) {
            for (Map.Entry<Integer, List<T>> cacheElement : cache.getValue().entrySet()) {
                log.debug((Object)("key1=" + cache.getKey() + ", " + "key2=" + cacheElement.getKey() + ", " + "value=" + cacheElement.getValue()));
            }
        }
    }

    public static boolean isInvalidDouble(Double d) {
        return d == null || Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public static <S, T> int getMapListCount(Map<S, List<T>> mapList) {
        int count = 0;
        try {
            for (List<T> listValue : mapList.values()) {
                count += listValue.size();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error counting MapList", t);
        }
        return count;
    }

    public static <R, S, T> int getMapMapListCount(Map<R, Map<S, List<T>>> mapMapList) {
        int count = 0;
        try {
            for (Map<S, List<T>> mapListValue : mapMapList.values()) {
                count += AlertConditionCacheUtils.getMapListCount(mapListValue);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error counting MapMapList", t);
        }
        return count;
    }
}

