/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.RoleCriteria;
import org.rhq.core.domain.resource.group.LdapGroup;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerRemote;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class RoleManagerBean
implements RoleManagerLocal,
RoleManagerRemote {
    private final Log log = LogFactory.getLog(RoleManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private RoleManagerLocal roleManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    @IgnoreDependency
    private AlertNotificationManagerLocal alertNotificationManager;
    @EJB
    @IgnoreDependency
    private LdapGroupManagerLocal ldapGroupManager;

    @Override
    @ExcludeDefaultInterceptors
    public PageList<Role> findRolesBySubject(int subjectId, PageControl pc) {
        Subject subject = (Subject)this.entityManager.find(Subject.class, (Object)subjectId);
        PageList roles = PersistenceUtility.createPaginationFilter((EntityManager)this.entityManager, (Collection)subject.getRoles(), (PageControl)pc);
        if (roles != null) {
            for (Role role : roles) {
                role.getMemberCount();
            }
        }
        return roles;
    }

    @Override
    public PageList<Role> findRoles(PageControl pc) {
        pc.initDefaultOrderingField("r.name");
        String queryName = "Role.findAll";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        long count = (Long)queryCount.getSingleResult();
        ArrayList roles = query.getResultList();
        if (roles != null) {
            for (Role role : roles) {
                role.getMemberCount();
            }
        } else {
            roles = new ArrayList();
        }
        return new PageList(roles, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public Role createRole(Subject subject, Role newRole) {
        if (newRole.getFsystem().booleanValue()) {
            throw new IllegalArgumentException("Unable to create role [" + newRole.getName() + "] - new system roles cannot be created.");
        }
        this.processDependentPermissions(newRole);
        Set ldapGroups = newRole.getLdapGroups();
        for (LdapGroup ldapGroup : ldapGroups) {
            ldapGroup.setRole(newRole);
        }
        this.entityManager.persist((Object)newRole);
        return newRole;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void deleteRoles(Subject subject, int[] doomedRoleIds) {
        if (doomedRoleIds != null) {
            for (int roleId : doomedRoleIds) {
                Role doomedRole = (Role)this.entityManager.find(Role.class, (Object)roleId);
                HashSet subjectsToUnhook = new HashSet(doomedRole.getSubjects());
                for (Subject doomedSubjectRelationship : subjectsToUnhook) {
                    doomedRole.removeSubject(doomedSubjectRelationship);
                    this.entityManager.merge((Object)doomedSubjectRelationship);
                }
                HashSet groupsToUnhook = new HashSet(doomedRole.getResourceGroups());
                for (ResourceGroup doomedResourceGroupRelationship : groupsToUnhook) {
                    doomedRole.removeResourceGroup(doomedResourceGroupRelationship);
                    this.entityManager.merge((Object)doomedResourceGroupRelationship);
                }
                if ((doomedRole = (Role)this.entityManager.merge((Object)doomedRole)).getFsystem().booleanValue()) {
                    throw new PermissionException("You cannot delete an internal system role");
                }
                this.alertNotificationManager.cleanseAlertNotificationByRole(doomedRole.getId());
                this.entityManager.remove((Object)doomedRole);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void addRolesToSubject(Subject subject, int subjectId, int[] roleIds) {
        this.addRolesToSubject(subject, subjectId, roleIds, false);
    }

    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void addRolesToSubject(Subject subject, int subjectId, int[] roleIds, boolean isLdap) {
        if (roleIds != null) {
            Subject subjectToModify = this.subjectManager.getSubjectById(subjectId);
            if (subjectToModify == null) {
                throw new IllegalArgumentException("Could not find subject[" + subjectId + "] to add roles to");
            }
            if (subjectToModify.getFsystem() || this.authorizationManager.isSystemSuperuser(subjectToModify)) {
                throw new PermissionException("You cannot assign roles to user [" + subjectToModify.getName() + "] - roles are fixed for this user");
            }
            subjectToModify.getRoles().size();
            int[] arr$ = roleIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer roleId = arr$[i$];
                Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
                if (role == null) {
                    throw new IllegalArgumentException("Tried to add role[" + roleId + "] to subject[" + subjectId + "], but role was not found");
                }
                role.addSubject(subjectToModify);
                if (!isLdap) continue;
                role.addLdapSubject(subjectToModify);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void addSubjectsToRole(Subject subject, int roleId, int[] subjectIds) {
        if (subjectIds != null) {
            Role role = this.getRoleById(roleId);
            if (role == null) {
                throw new IllegalArgumentException("Could not find role[" + roleId + "] to add subjects to");
            }
            int[] arr$ = subjectIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer subjectId = arr$[i$];
                Subject newSubject = (Subject)this.entityManager.find(Subject.class, (Object)subjectId);
                if (newSubject == null) {
                    throw new IllegalArgumentException("Tried to add subject[" + subjectId + "] to role[" + roleId + "], but subject was not found");
                }
                if (newSubject.getFsystem() || this.authorizationManager.isSystemSuperuser(newSubject)) {
                    throw new PermissionException("You cannot alter the roles for user [" + newSubject.getName() + "] - roles are fixed for this user");
                }
                role.addSubject(newSubject);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void removeRolesFromSubject(Subject subject, int subjectId, int[] roleIds) {
        if (roleIds != null) {
            Subject subjectToModify = this.subjectManager.getSubjectById(subjectId);
            if (subjectToModify.getFsystem() || this.authorizationManager.isSystemSuperuser(subjectToModify)) {
                throw new PermissionException("You cannot remove roles from user [" + subjectToModify.getName() + "] - roles are fixed for this user");
            }
            int[] arr$ = roleIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer roleId = arr$[i$];
                Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
                if (role == null) continue;
                role.removeSubject(subjectToModify);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void setAssignedSubjectRoles(Subject subject, int subjectId, int[] roleIds) {
        Subject subjectToModify = this.subjectManager.getSubjectById(subjectId);
        ArrayList<Integer> currentRoles = new ArrayList<Integer>();
        for (Role role : subjectToModify.getRoles()) {
            currentRoles.add(role.getId());
        }
        List newRoles = ArrayUtils.wrapInList((int[])roleIds);
        newRoles.removeAll(currentRoles);
        if (newRoles.size() > 0) {
            int[] newRoleIds = new int[newRoles.size()];
            int i = 0;
            for (Integer id : newRoles) {
                newRoleIds[i++] = id;
            }
            this.roleManager.addRolesToSubject(subject, subjectId, newRoleIds);
        }
        ArrayList removedRoles = new ArrayList(currentRoles);
        removedRoles.removeAll(ArrayUtils.wrapInList((int[])roleIds));
        if (removedRoles.size() > 0) {
            int[] removedRoleIds = new int[removedRoles.size()];
            int i = 0;
            for (Integer id : removedRoles) {
                removedRoleIds[i++] = id;
            }
            this.roleManager.removeRolesFromSubject(subject, subjectId, removedRoleIds);
        }
    }

    @Override
    public Role getRoleById(Integer roleId) {
        Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
        return role;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void setPermissions(Subject subject, Integer roleId, Set<Permission> permissions) {
        Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
        Set rolePermissions = role.getPermissions();
        rolePermissions.clear();
        rolePermissions.addAll(permissions);
        this.entityManager.merge((Object)role);
        this.entityManager.flush();
    }

    @Override
    public Set<Permission> getPermissions(Integer roleId) {
        Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
        Set rolePermissions = role.getPermissions();
        return rolePermissions;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public Role updateRole(Subject whoami, Role role) {
        Set newLdapGroups;
        Set newResourceGroups;
        Role attachedRole = (Role)this.entityManager.find(Role.class, (Object)role.getId());
        if (attachedRole == null) {
            throw new IllegalStateException("Cannot update " + role + ", since no role exists with that id.");
        }
        attachedRole.setName(role.getName());
        attachedRole.setDescription(role.getDescription());
        attachedRole.setPermissions(role.getPermissions());
        this.processDependentPermissions(attachedRole);
        Set newSubjects = role.getSubjects();
        if (newSubjects != null) {
            Set currentSubjects = attachedRole.getSubjects();
            HashSet subjectsToRemove = new HashSet(currentSubjects);
            for (Subject subject : currentSubjects) {
                if (!subject.getFsystem()) continue;
                subjectsToRemove.remove(subject);
            }
            for (Subject subject : subjectsToRemove) {
                attachedRole.removeSubject(subject);
            }
            for (Subject subject : newSubjects) {
                Subject attachedSubject = (Subject)this.entityManager.find(Subject.class, (Object)subject.getId());
                attachedRole.addSubject(attachedSubject);
            }
        }
        if ((newResourceGroups = role.getResourceGroups()) != null) {
            HashSet currentResourceGroups = new HashSet(attachedRole.getResourceGroups());
            for (ResourceGroup resourceGroup : currentResourceGroups) {
                attachedRole.removeResourceGroup(resourceGroup);
            }
            for (ResourceGroup resourceGroup : newResourceGroups) {
                ResourceGroup attachedResourceGroup = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)resourceGroup.getId());
                attachedRole.addResourceGroup(attachedResourceGroup);
            }
        }
        if ((newLdapGroups = role.getLdapGroups()) != null) {
            HashSet currentLdapGroups = new HashSet(attachedRole.getLdapGroups());
            for (LdapGroup ldapGroup : currentLdapGroups) {
                if (newLdapGroups.contains(ldapGroup)) continue;
                attachedRole.removeLdapGroup(ldapGroup);
                this.entityManager.remove((Object)ldapGroup);
            }
            for (LdapGroup ldapGroup : newLdapGroups) {
                LdapGroup attachedLdapGroup;
                LdapGroup ldapGroup2 = attachedLdapGroup = ldapGroup.getId() != 0 ? (LdapGroup)this.entityManager.find(LdapGroup.class, (Object)ldapGroup.getId()) : null;
                if (attachedLdapGroup == null) {
                    ldapGroup.setRole(attachedRole);
                    this.entityManager.persist((Object)ldapGroup);
                    attachedLdapGroup = ldapGroup;
                }
                attachedRole.addLdapGroup(attachedLdapGroup);
            }
        }
        attachedRole.getResourceGroups().size();
        attachedRole.getSubjects().size();
        attachedRole.getLdapGroups().size();
        return attachedRole;
    }

    public PageList<Subject> findSubjectsByRole(Subject subject, Integer roleId, PageControl pc) {
        return this.findSubjectsByRole(roleId, pc);
    }

    @Override
    public PageList<Subject> findSubjectsByRole(Integer roleId, PageControl pc) {
        pc.initDefaultOrderingField("s.name");
        String queryName = "Subject.getSubjectsAssignedToRole";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        queryCount.setParameter("id", (Object)roleId);
        query.setParameter("id", (Object)roleId);
        long count = (Long)queryCount.getSingleResult();
        List subjects = query.getResultList();
        return new PageList((Collection)subjects, (int)count, pc);
    }

    @Override
    public PageList<Role> findRolesByIds(Integer[] roleIds, PageControl pc) {
        if (roleIds == null || roleIds.length == 0) {
            return new PageList(pc);
        }
        pc.initDefaultOrderingField("r.name");
        String queryName = "Role.findByIds";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        List<Integer> roleIdsList = Arrays.asList(roleIds);
        queryCount.setParameter("ids", roleIdsList);
        query.setParameter("ids", roleIdsList);
        long count = (Long)queryCount.getSingleResult();
        List roles = query.getResultList();
        for (Role role : roles) {
            role.getMemberCount();
        }
        return new PageList((Collection)roles, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public PageList<Role> findAvailableRolesForSubject(Subject subject, Integer subjectId, Integer[] pendingRoleIds, PageControl pc) {
        pc.initDefaultOrderingField("r.name");
        String queryName = pendingRoleIds == null || pendingRoleIds.length == 0 ? "Role.findAvailableRoles" : "Role.findAvailableRolesWithExcludes";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName, (String)"distinct r");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        queryCount.setParameter("subjectId", (Object)subjectId);
        query.setParameter("subjectId", (Object)subjectId);
        if (pendingRoleIds != null && pendingRoleIds.length > 0) {
            List<Integer> pendingIdsList = Arrays.asList(pendingRoleIds);
            queryCount.setParameter("excludes", pendingIdsList);
            query.setParameter("excludes", pendingIdsList);
        }
        long count = (Long)queryCount.getSingleResult();
        List roles = query.getResultList();
        for (Role role : roles) {
            role.getMemberCount();
        }
        return new PageList((Collection)roles, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public PageList<Role> findSubjectUnassignedRoles(Subject subject, int subjectId, PageControl pc) {
        return this.findAvailableRolesForSubject(subject, subjectId, null, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void addResourceGroupsToRole(Subject subject, int roleId, int[] groupIds) {
        if (groupIds != null && groupIds.length > 0) {
            Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
            if (role == null) {
                throw new IllegalArgumentException("Could not find role[" + roleId + "] to add resourceGroups to");
            }
            role.getResourceGroups().size();
            int[] arr$ = groupIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer groupId = arr$[i$];
                ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)groupId);
                if (role == null) {
                    throw new IllegalArgumentException("Tried to add resourceGroup[" + groupId + "] to role[" + roleId + "], but resourceGroup was not found");
                }
                role.addResourceGroup(group);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void removeResourceGroupsFromRole(Subject subject, int roleId, int[] groupIds) {
        if (groupIds != null && groupIds.length > 0) {
            Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
            if (role == null) {
                throw new IllegalArgumentException("Could not find role[" + roleId + "] to remove resourceGroups from");
            }
            role.getResourceGroups().size();
            int[] arr$ = groupIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer groupId = arr$[i$];
                ResourceGroup doomedGroup = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)groupId);
                if (doomedGroup == null) {
                    throw new IllegalArgumentException("Tried to remove doomedGroup[" + groupId + "] from role[" + roleId + "], but subject was not found");
                }
                role.removeResourceGroup(doomedGroup);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void setAssignedResourceGroups(Subject subject, int roleId, int[] groupIds) {
        Role role = this.getRole(subject, roleId);
        ArrayList<Integer> currentGroups = new ArrayList<Integer>();
        for (ResourceGroup group : role.getResourceGroups()) {
            currentGroups.add(group.getId());
        }
        List newGroups = ArrayUtils.wrapInList((int[])groupIds);
        newGroups.removeAll(currentGroups);
        int[] newGroupIds = ArrayUtils.unwrapCollection((Collection)newGroups);
        this.roleManager.addResourceGroupsToRole(subject, roleId, newGroupIds);
        ArrayList removedGroups = new ArrayList(currentGroups);
        removedGroups.removeAll(ArrayUtils.wrapInList((int[])groupIds));
        int[] removedGroupIds = ArrayUtils.unwrapCollection(removedGroups);
        this.roleManager.removeResourceGroupsFromRole(subject, roleId, removedGroupIds);
    }

    private void processDependentPermissions(Role role) {
        if (role.getPermissions().contains(Permission.MANAGE_SECURITY)) {
            role.getPermissions().addAll(EnumSet.allOf(Permission.class));
        }
        if (role.getPermissions().contains(Permission.MANAGE_INVENTORY)) {
            role.getPermissions().addAll(Permission.RESOURCE_ALL);
        }
        if (role.getPermissions().contains(Permission.CONFIGURE_WRITE)) {
            role.getPermissions().add(Permission.CONFIGURE_READ);
        }
        if (!role.getPermissions().contains(Permission.CONFIGURE_READ)) {
            role.getPermissions().remove(Permission.CONFIGURE_WRITE);
        }
    }

    @Override
    public PageList<Role> findSubjectAssignedRoles(Subject subject, int subjectId, PageControl pc) {
        PageList<Role> assignedRoles = this.findRolesBySubject(subjectId, pc);
        return assignedRoles;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void removeSubjectsFromRole(Subject subject, int roleId, int[] subjectIds) {
        if (subjectIds != null && subjectIds.length > 0) {
            Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
            if (role == null) {
                throw new IllegalArgumentException("Could not find role[" + roleId + "] to remove subjects from");
            }
            role.getSubjects().size();
            int[] arr$ = subjectIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer subjectId = arr$[i$];
                Subject doomedSubject = (Subject)this.entityManager.find(Subject.class, (Object)subjectId);
                if (doomedSubject == null) {
                    throw new IllegalArgumentException("Tried to remove subject[" + subjectId + "] from role[" + roleId + "], but subject was not found");
                }
                if (doomedSubject.getFsystem() || this.authorizationManager.isSystemSuperuser(doomedSubject)) {
                    throw new PermissionException("You cannot remove user[" + doomedSubject.getName() + "] from role[" + roleId + "] - roles are fixed for this user");
                }
                role.removeSubject(doomedSubject);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void setAssignedSubjects(Subject subject, int roleId, int[] subjectIds) {
        Role role = this.getRole(subject, roleId);
        ArrayList<Integer> currentSubjects = new ArrayList<Integer>();
        for (Subject currentSubject : role.getSubjects()) {
            currentSubjects.add(currentSubject.getId());
        }
        List newSubjects = ArrayUtils.wrapInList((int[])subjectIds);
        newSubjects.removeAll(currentSubjects);
        if (newSubjects.size() > 0) {
            int[] newSubjectIds = new int[newSubjects.size()];
            int i = 0;
            for (Integer id : newSubjects) {
                newSubjectIds[i++] = id;
            }
            this.roleManager.addSubjectsToRole(subject, roleId, newSubjectIds);
        }
        ArrayList removedSubjects = new ArrayList(currentSubjects);
        removedSubjects.removeAll(ArrayUtils.wrapInList((int[])subjectIds));
        if (removedSubjects.size() > 0) {
            int[] removedSubjectIds = new int[removedSubjects.size()];
            int i = 0;
            for (Integer id : removedSubjects) {
                removedSubjectIds[i++] = id;
            }
            this.roleManager.removeSubjectsFromRole(subject, roleId, removedSubjectIds);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void removeRolesFromResourceGroup(Subject subject, int groupId, int[] roleIds) {
        if (roleIds != null && roleIds.length > 0) {
            ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)groupId);
            if (group == null) {
                throw new IllegalArgumentException("Could not find resourceGroup[" + groupId + "] to remove roles from");
            }
            group.getRoles().size();
            int[] arr$ = roleIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer roleId = arr$[i$];
                Role doomedRole = (Role)this.entityManager.find(Role.class, (Object)roleId);
                if (doomedRole == null) {
                    throw new IllegalArgumentException("Tried to remove role[" + roleId + "] from resourceGroup[" + groupId + "], but role was not found");
                }
                group.removeRole(doomedRole);
            }
        }
    }

    @Override
    public Role getRole(Subject subject, int roleId) {
        return (Role)this.entityManager.find(Role.class, (Object)roleId);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void addRolesToResourceGroup(Subject subject, int groupId, int[] roleIds) {
        if (roleIds != null && roleIds.length > 0) {
            ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)groupId);
            if (group == null) {
                throw new IllegalArgumentException("Could not find resourceGroup[" + groupId + "] to add roles to");
            }
            group.getRoles().size();
            int[] arr$ = roleIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer roleId = arr$[i$];
                Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
                if (role == null) {
                    throw new IllegalArgumentException("Tried to add role[" + roleId + "] to resourceGroup[" + groupId + "], but role was not found");
                }
                group.addRole(role);
            }
        }
    }

    @Override
    public PageList<Role> findRolesByCriteria(Subject subject, RoleCriteria criteria) {
        if (criteria.isSecurityManagerRequired() && !this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SECURITY)) {
            throw new PermissionException("Subject [" + subject.getName() + "] requires SecurityManager permission for requested query criteria.");
        }
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList roles = queryRunner.execute();
        return roles;
    }
}

