/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.cloud.FailoverListDetails;
import org.rhq.core.domain.cloud.PartitionEventType;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.cloud.composite.ServerWithAgentCountComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.cloud.CloudManagerException;
import org.rhq.enterprise.server.cloud.CloudManagerLocal;
import org.rhq.enterprise.server.cloud.FailoverListManagerLocal;
import org.rhq.enterprise.server.cloud.PartitionEventManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class CloudManagerBean
implements CloudManagerLocal {
    private final Log log = LogFactory.getLog(CloudManagerBean.class);
    private static final long SERVER_DOWN_INTERVAL = 120000L;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private CloudManagerLocal cloudManager;
    @EJB
    private FailoverListManagerLocal failoverListManager;
    @EJB
    private PartitionEventManagerLocal partitionEventManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    @IgnoreDependency
    private ServerManagerLocal serverManager;

    @Override
    public List<Agent> getAgentsByServerName(String serverName) {
        Server server = this.cloudManager.getServerByName(serverName);
        List agents = server.getAgents();
        agents.size();
        return agents;
    }

    @Override
    public Server getServerById(int serverId) {
        Server server = (Server)this.entityManager.find(Server.class, (Object)serverId);
        return server;
    }

    @Override
    public Server getServerByName(String serverName) {
        Query query = this.entityManager.createNamedQuery("Server.findByName");
        query.setParameter("name", (Object)serverName);
        try {
            Server server = (Server)query.getSingleResult();
            return server;
        }
        catch (NoResultException nre) {
            this.log.info((Object)("Server[name=" + serverName + "] not found, returning null..."));
            return null;
        }
    }

    @Override
    public List<Server> getAllCloudServers() {
        Query query = this.entityManager.createNamedQuery("Server.findAllCloudMembers");
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<Server> getAllServers() {
        Query query = this.entityManager.createNamedQuery("Server.findAll");
        List results = query.getResultList();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ServerWithAgentCountComposite> getServerComposites(Subject subject, PageControl pc) {
        pc.initDefaultOrderingField("s.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Server.findAllComposites", (PageControl)pc);
        List results = query.getResultList();
        int count = this.getServerCount();
        return new PageList((Collection)results, count, pc);
    }

    @Override
    public int getServerCount() {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Server.findAll");
        try {
            long serverCount = (Long)query.getSingleResult();
            return (int)serverCount;
        }
        catch (NoResultException nre) {
            this.log.debug((Object)"Could not get count of cloud instances, returning 0...");
            return 0;
        }
    }

    @Override
    public int getNormalServerCount() {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Server.findAllNormalCloudMembers");
        try {
            long serverCount = (Long)query.getSingleResult();
            return (int)serverCount;
        }
        catch (NoResultException nre) {
            this.log.debug((Object)"Could not get count of normal cloud instances, returning 0...");
            return 0;
        }
    }

    @Override
    public void deleteServers(Integer[] serverIds) throws CloudManagerException {
        if (serverIds == null) {
            return;
        }
        for (Integer nextServerId : serverIds) {
            this.cloudManager.deleteServer(nextServerId);
        }
    }

    @Override
    public void deleteServer(Integer serverId) throws CloudManagerException {
        try {
            Server server = (Server)this.entityManager.find(Server.class, (Object)serverId);
            if (Server.OperationMode.NORMAL == server.getOperationMode()) {
                throw new CloudManagerException("Could not delete server " + server.getName() + ". Server must be down or in maintenance mode. Current operating mode is: " + server.getOperationMode().name());
            }
            this.failoverListManager.deleteServerListDetailsForServer(serverId);
            Query query = this.entityManager.createNamedQuery("Agent.removeServerReference");
            query.setParameter("serverId", (Object)serverId);
            query.executeUpdate();
            query = this.entityManager.createNamedQuery("Server.deleteById");
            query.setParameter("serverId", (Object)serverId);
            query.executeUpdate();
            this.entityManager.flush();
            this.entityManager.clear();
            this.log.info((Object)("Removed server " + server));
            this.partitionEventManager.cloudPartitionEventRequest(LookupUtil.getSubjectManager().getOverlord(), PartitionEventType.SERVER_DELETION, server.getName());
        }
        catch (Exception e) {
            throw new CloudManagerException("Could not delete server[id=" + serverId + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void updateServerMode(Integer[] serverIds, Server.OperationMode mode) {
        if (serverIds == null) {
            return;
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null");
        }
        if (serverIds.length > 0) {
            try {
                for (Integer id : serverIds) {
                    Server server = (Server)this.entityManager.find(Server.class, (Object)id);
                    if (server.getOperationMode() == mode) continue;
                    if (Server.OperationMode.DOWN == mode) {
                        String audit = server.getName() + ": " + server.getOperationMode().name() + " --> " + mode;
                        this.partitionEventManager.auditPartitionEvent(LookupUtil.getSubjectManager().getOverlord(), PartitionEventType.OPERATION_MODE_CHANGE, audit);
                    }
                    server.setOperationMode(mode);
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("Failed to update HA server modes: " + e));
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Server updateServer(Subject subject, Server server) {
        return (Server)this.entityManager.merge((Object)server);
    }

    @Override
    public PageList<FailoverListDetails> getFailoverListDetailsByAgentId(int agentId, PageControl pc) {
        pc.initDefaultOrderingField("fld.ordinal");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"FailoverListDetails.getViaAgentIdWithServers", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"FailoverListDetails.getViaAgentId");
        query.setParameter("agentId", (Object)agentId);
        countQuery.setParameter("agentId", (Object)agentId);
        List list = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)list, (int)count, pc);
    }

    @Override
    public void markStaleServersDown(Subject subject) {
        if (!this.authorizationManager.isOverlord(subject)) {
            throw new IllegalArgumentException("The markStaleServersDown method must be called by the overlord");
        }
        long staleTime = System.currentTimeMillis() - 120000L;
        String serverName = null;
        try {
            serverName = this.serverManager.getIdentity();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(serverName + " is marking stale servers DOWN"));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Could not determine which instance is marking stale servers DOWN");
        }
        Query query = this.entityManager.createNamedQuery("Server.updateSetStaleDown");
        query.setParameter("downMode", (Object)Server.OperationMode.DOWN);
        query.setParameter("normalMode", (Object)Server.OperationMode.NORMAL);
        query.setParameter("staleTime", (Object)staleTime);
        query.setParameter("thisServerName", (Object)serverName);
        int resultCount = query.executeUpdate();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(String.valueOf(resultCount) + " stale servers were marked DOWN"));
        }
        this.partitionEventManager.processRequestedPartitionEvents();
    }
}

