/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.dashboard;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.dashboard.Dashboard;
import org.rhq.enterprise.server.auth.SubjectManagerBean;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.dashboard.DashboardManagerLocal;
import org.rhq.enterprise.server.dashboard.DashboardManagerRemote;

@Stateless
public class DashboardManagerBean
implements DashboardManagerLocal,
DashboardManagerRemote {
    private final Log log = LogFactory.getLog(SubjectManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @Override
    public List<Dashboard> findDashboardsForSubject(Subject subject) {
        Query query = this.entityManager.createQuery("SELECT d FROM Dashboard d WHERE d.owner.id = :subjectId");
        query.setParameter("subjectId", (Object)subject.getId());
        return query.getResultList();
    }

    @Override
    public List<Dashboard> findSharedDashboards(Subject subject) {
        Query query = this.entityManager.createQuery("SELECT d FROM Dashboard d WHERE d.shared = true");
        return query.getResultList();
    }

    @Override
    public Dashboard storeDashboard(Subject subject, Dashboard dashboard) {
        Dashboard d = null;
        d = (Dashboard)this.entityManager.find(Dashboard.class, (Object)dashboard.getId());
        if (d == null) {
            dashboard.setOwner(subject);
            this.entityManager.persist((Object)dashboard);
            return dashboard;
        }
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS) && d.getOwner().getId() != subject.getId()) {
            throw new PermissionException("You may only alter dashboards you own.");
        }
        return (Dashboard)this.entityManager.merge((Object)dashboard);
    }

    @Override
    public void removeDashboard(Subject subject, int dashboardId) {
        Dashboard toDelete = (Dashboard)this.entityManager.find(Dashboard.class, (Object)dashboardId);
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS) && toDelete.getOwner().getId() != subject.getId()) {
            throw new PermissionException("You may only delete dashboards you own.");
        }
        this.entityManager.remove((Object)toDelete);
    }
}

