/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.jaxb.adapter;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceError;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
class WsResourceListWrapper
extends Resource {
    private List<Resource> lineageList = new LinkedList<Resource>();
    private int parentResourceId = -1;
    private List<Integer> resourceErrorIds = new ArrayList<Integer>();

    public WsResourceListWrapper() {
    }

    public WsResourceListWrapper(List<Resource> opaque) {
        if (opaque != null) {
            for (Resource r : opaque) {
                WsResourceListWrapper copy = new WsResourceListWrapper();
                this.copyResource(copy, r);
                this.lineageList.add(copy);
            }
        }
    }

    private void copyResource(WsResourceListWrapper destination, Resource source) {
        if (destination == null || source == null) {
            throw new IllegalArgumentException("Neither source or destination references can be null.");
        }
        destination.setAgent(source.getAgent());
        destination.setAlertDefinitions(source.getAlertDefinitions());
        destination.setDescription(source.getDescription());
        destination.setChildResources(source.getChildResources());
        destination.setConnected(source.isConnected());
        destination.setContentServiceRequests(source.getContentServiceRequests());
        destination.setCreateChildResourceRequests(source.getCreateChildResourceRequests());
        destination.setCurrentAvailability(source.getCurrentAvailability());
        destination.setDeleteResourceRequests(source.getDeleteResourceRequests());
        destination.setExplicitGroups(source.getExplicitGroups());
        destination.setImplicitGroups(source.getImplicitGroups());
        destination.setInstalledPackageHistory(source.getInstalledPackageHistory());
        destination.setInstalledPackages(source.getInstalledPackages());
        destination.setInventoryStatus(source.getInventoryStatus());
        destination.setItime(source.getItime());
        destination.setLocation(source.getLocation());
        destination.setModifiedBy(source.getModifiedBy());
        destination.setMtime(source.getMtime());
        destination.setOperationHistories(source.getOperationHistories());
        destination.setPluginConfiguration(source.getPluginConfiguration());
        destination.setPluginConfigurationUpdates(source.getPluginConfigurationUpdates());
        destination.setProductVersion(source.getProductVersion());
        destination.setResourceConfiguration(source.getResourceConfiguration());
        destination.setResourceConfigurationUpdates(source.getResourceConfigurationUpdates());
        destination.setSchendules(source.getSchedules());
        destination.setUuid(source.getUuid());
        if (source.getParentResource() != null) {
            destination.parentResourceId = source.getParentResource().getId();
        }
        if (source.getResourceErrors() != null && !source.getResourceErrors().isEmpty()) {
            for (ResourceError error : source.getResourceErrors()) {
                destination.resourceErrorIds.add(error.getId());
            }
        }
        destination.setId(source.getId());
        destination.setName(source.getName());
        destination.setResourceKey(source.getResourceKey());
        destination.setResourceType(source.getResourceType());
        destination.setVersion(source.getVersion());
    }
}

