/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.license;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.enterprise.server.license.ExpirationTag;
import org.rhq.enterprise.server.license.LRES;
import org.rhq.enterprise.server.license.LicenseManager;

public final class License
implements Serializable {
    public static final int FEATURE_BASIC = 1;
    public static final int FEATURE_MONITOR = 2;
    public static final int FEATURE_ALL = 3;
    private String _masterKey = null;
    private String _version = null;
    private String _licenseeName = null;
    private String _licenseeEmail = null;
    private String _licenseePhone = null;
    private long _expiration = 9223372036854775307L;
    private int _platformLimit = 0;
    private List _serverIps = new ArrayList();
    private List _plugins = new ArrayList();
    private int _supportLevel = 1;
    private boolean trial = false;
    static final long EXPIRES_NEVER = 9223372036854775307L;
    static final int PLATFORMS_UNLIMITED = 2147483624;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String MUNGABLE_CHARS_ALNUM = "6JCqLxnjaOSAkyWXsvQ7G4ueNf1hIMgbV2dDEcTU5o9HlRwFPYZBirm8ztK03p";
    private static final String MUNGABLE_CHARS = "_{my*K|c~1kJ@apv!6l?MF9ZeH\"+#L&NC3Y`>BV0nERiA:DGdqQuh 2S<=WgtOf%r'[\\7s5o}UPT$(^bx)X]/-I4wj8;.z,";

    protected License() {
    }

    protected String getMasterKey() {
        return this._masterKey;
    }

    protected void setMasterKey(String m) {
        this._masterKey = m;
    }

    protected String getVersion() {
        return this._version;
    }

    protected void setVersion(String v) {
        this._version = v;
    }

    public String getLicenseeName() {
        return this._licenseeName;
    }

    protected void setLicenseeName(String n) {
        this._licenseeName = n;
    }

    public String getLicenseeEmail() {
        return this._licenseeEmail;
    }

    protected void setLicenseeEmail(String e) {
        this._licenseeEmail = e;
    }

    public String getLicenseePhone() {
        return this._licenseePhone;
    }

    protected void setLicenseePhone(String p) {
        this._licenseePhone = p;
    }

    public boolean getIsPerpetualLicense() {
        return this._expiration == 9223372036854775307L;
    }

    public long getLicenseExpiration() {
        return this._expiration;
    }

    protected void setPlatformLimit(int l) {
        this._platformLimit = l;
    }

    public boolean getPlatformsUnlimited() {
        return this._platformLimit == 2147483624;
    }

    public int getPlatformLimit() {
        return this._platformLimit;
    }

    public int getSupportLevel() {
        return this._supportLevel;
    }

    protected void setSupportLevel(int level) {
        this._supportLevel = level;
    }

    protected void addServerIp(int count, String addr) {
        if (this._serverIps.size() >= count) {
            LicenseManager.doHalt("+( hW/8jJf~S'J\"xh.G6z$m");
            return;
        }
        this._serverIps.add(addr);
    }

    public boolean getIsAnyIpOk() {
        return this._serverIps.size() > 0 && this._serverIps.get(0).equals(LRES.get("l"));
    }

    public List getServerIps() {
        return this._serverIps;
    }

    public boolean getIsAnyPluginOk() {
        return this._plugins.size() > 0 && this._plugins.get(0).equals(LRES.get("l"));
    }

    protected void addPlugin(String plugin) {
        this._plugins.add(plugin);
    }

    public List getPlugins() {
        return this._plugins;
    }

    public boolean equals(Object o) {
        if (!(o instanceof License)) {
            return false;
        }
        License l = (License)o;
        return this.getMasterKey().equals(l.getMasterKey());
    }

    public String toString() {
        return LRES.get(",WUV<U~hX|e}=y-") + this.getLicenseeName() + LRES.get("U:e>\\i]") + this.getLicenseeEmail() + LRES.get("U`P,rq]") + this.getLicenseePhone() + LRES.get("^Q@R},A-sy7I") + (this.getIsPerpetualLicense() ? LRES.get("Wi`:I") : ExpirationTag.DFORMAT.format(new Date(this._expiration))) + LRES.get("(0Anw;|w+_/") + (this.getPlatformsUnlimited() ? LRES.get("U%R7#5wDo") : String.valueOf(this._platformLimit)) + LRES.get("(,Q;i ,v*_/") + (this.getIsAnyIpOk() ? LRES.get("L=F") : StringUtil.listToString((List)this._serverIps)) + LRES.get("TBR$-57;x") + (this.getIsAnyPluginOk() ? LRES.get("L`>") : StringUtil.listToString((List)this._plugins)) + LRES.get("T.T0ny.Xx") + this.getSupportLevel() + LRES.get("m");
    }

    static String simpleHash(String s) {
        int i;
        String reverse = new StringBuffer(s).reverse().toString();
        String m = License.munge(s);
        int i2 = 0;
        while (m.length() < 1024) {
            String rm = new StringBuffer(m).reverse().toString();
            switch ((i2 + m.length()) % 5) {
                case 0: {
                    m = License.munge(reverse + m + s);
                    break;
                }
                case 1: {
                    m = License.munge(s + reverse + rm);
                    break;
                }
                case 2: {
                    m = License.munge(rm + reverse);
                    break;
                }
                case 3: {
                    m = License.munge(s + m);
                    break;
                }
                case 4: {
                    m = License.munge(reverse + rm + m + rm);
                }
            }
            ++i2;
        }
        m = License.munge(m);
        int[] accum = new int[32];
        for (i = 0; i < 32; ++i) {
            accum[i] = 0;
        }
        for (i = 0; i < m.length(); ++i) {
            int n = i % 32;
            accum[n] = accum[n] + m.charAt(i);
        }
        StringBuffer result = new StringBuffer();
        for (int i3 = 0; i3 < 32; ++i3) {
            result.append(HEX[accum[i3] % 16]);
        }
        return result.toString();
    }

    static String unmunge(String s) {
        return License.unmunge(s, MUNGABLE_CHARS);
    }

    static String unmunge(String s, String mungeMap) {
        StringBuffer rstr = new StringBuffer();
        int mlen = mungeMap.length();
        int lenmod = s.length() % 37;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            int idx = mungeMap.indexOf(c);
            if (idx == -1) {
                rstr.append(c);
                continue;
            }
            int newIdx = (idx - 13 - i % 7 - lenmod + mlen) % mlen;
            rstr.append(mungeMap.charAt(newIdx));
        }
        return rstr.toString();
    }

    static String munge(String s) {
        return License.munge(s, MUNGABLE_CHARS);
    }

    static String munge(String s, String mungeMap) {
        StringBuffer rstr = new StringBuffer();
        int mlen = mungeMap.length();
        int lenmod = s.length() % 37;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            int idx = mungeMap.indexOf(c);
            if (idx == -1) {
                rstr.append(c);
                continue;
            }
            int newIdx = (idx + 13 + i % 7 + lenmod) % mlen;
            rstr.append(mungeMap.charAt(newIdx));
        }
        return rstr.toString();
    }

    static String shuffle(String s) {
        ArrayList<Character> chars = new ArrayList<Character>();
        for (int i = 0; i < s.length(); ++i) {
            chars.add(new Character(s.charAt(i)));
        }
        Collections.shuffle(chars);
        StringBuffer rstr = new StringBuffer();
        for (int i = 0; i < chars.size(); ++i) {
            rstr.append(((Character)chars.get(i)).charValue());
        }
        return rstr.toString();
    }

    public boolean isTrial() {
        return this.trial;
    }

    protected void setTrial(boolean trial) {
        this.trial = trial;
    }
}

