/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.util.List;
import javax.ejb.Stateless;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.measurement.MeasurementViewException;
import org.rhq.enterprise.server.measurement.MeasurementViewManagerLocal;

@Stateless
public class MeasurementViewManagerBean
implements MeasurementViewManagerLocal {
    @Override
    public List<String> getViewNames(Subject user, EntityContext context) {
        String key = context.getLegacyKey();
        MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
        MeasurementPreferences.MetricViewsPreferences prefs = measurementPreferences.getMetricViews(key);
        return prefs.views;
    }

    @Override
    public void createView(Subject user, EntityContext context, String viewName) throws MeasurementViewException {
        String key = context.getLegacyKey();
        MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
        MeasurementPreferences.MetricViewsPreferences prefs = measurementPreferences.getMetricViews(key);
        if (prefs.views.contains(viewName)) {
            throw new MeasurementViewException("View name already in use: '" + viewName + "'");
        }
        prefs.views.add(viewName);
        measurementPreferences.setMetricViews(prefs, key);
    }

    @Override
    public void deleteView(Subject user, EntityContext context, String viewName) {
        String key = context.getLegacyKey();
        MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
        MeasurementPreferences.MetricViewsPreferences prefs = measurementPreferences.getMetricViews(key);
        prefs.views.remove(viewName);
        measurementPreferences.setMetricViews(prefs, key);
        measurementPreferences.deleteMetricViewData(key, viewName);
    }

    @Override
    public String getSelectedView(Subject user, EntityContext context) {
        String key = context.getLegacyKey();
        MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
        String selectedView = measurementPreferences.getSelectedView(key);
        return selectedView;
    }

    @Override
    public void setSelectedView(Subject user, EntityContext context, String viewName) {
        String key = context.getLegacyKey();
        MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
        measurementPreferences.setSelectedView(key, viewName);
    }

    @Override
    public List<String> getCharts(Subject user, EntityContext context, String viewName) throws MeasurementViewException {
        try {
            String key = context.getLegacyKey();
            MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
            MeasurementPreferences.MetricViewData viewData = measurementPreferences.getMetricViewData(key, viewName);
            return viewData.charts;
        }
        catch (IllegalArgumentException iae) {
            throw new MeasurementViewException("Could not find view " + viewName + " in context " + context);
        }
    }

    @Override
    public void saveCharts(Subject user, EntityContext context, String viewName, List<String> charts) {
        String key = context.getLegacyKey();
        MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
        MeasurementPreferences.MetricViewData viewData = new MeasurementPreferences.MetricViewData();
        viewData.charts = charts;
        measurementPreferences.setMetricViewData(key, viewName, viewData);
    }

    @Override
    public void moveChartUp(Subject user, EntityContext context, String viewName, String viewKey) {
        String key = context.getLegacyKey();
        MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
        MeasurementPreferences.MetricViewData viewData = measurementPreferences.getMetricViewData(key, viewName);
        List<String> charts = viewData.charts;
        int index = charts.indexOf(viewKey);
        if (index < 1) {
            return;
        }
        charts.set(index, charts.get(index - 1));
        charts.set(index - 1, viewKey);
        measurementPreferences.setMetricViewData(key, viewName, viewData);
    }

    @Override
    public void moveChartDown(Subject user, EntityContext context, String viewName, String viewKey) {
        String key = context.getLegacyKey();
        MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
        MeasurementPreferences.MetricViewData viewData = measurementPreferences.getMetricViewData(key, viewName);
        List<String> charts = viewData.charts;
        int index = charts.indexOf(viewKey);
        if (index == -1 && index >= charts.size() - 1) {
            return;
        }
        charts.set(index, charts.get(index + 1));
        charts.set(index + 1, viewKey);
        measurementPreferences.setMetricViewData(key, viewName, viewData);
    }

    @Override
    public void addChart(Subject user, EntityContext context, String viewName, String viewKey) {
        String key = context.getLegacyKey();
        MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
        MeasurementPreferences.MetricViewData viewData = measurementPreferences.getMetricViewData(key, viewName);
        if (!viewData.charts.contains(viewKey)) {
            viewData.charts.add(viewKey);
            measurementPreferences.setMetricViewData(key, viewName, viewData);
        }
    }

    @Override
    public void removeChart(Subject user, EntityContext context, String viewName, String viewKey) {
        String key = context.getLegacyKey();
        MeasurementPreferences measurementPreferences = new MeasurementPreferences(user);
        MeasurementPreferences.MetricViewData viewData = measurementPreferences.getMetricViewData(key, viewName);
        viewData.charts.remove(viewKey);
        measurementPreferences.setMetricViewData(key, viewName, viewData);
    }
}

