/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplaySummary;

public class MeasurementUtils {
    private static final Log LOG = LogFactory.getLog(MeasurementUtils.class);
    public static final int UNIT_COLLECTION_POINTS = 1;
    public static final int UNIT_MINUTES = 2;
    public static final int UNIT_HOURS = 3;
    public static final int UNIT_DAYS = 4;
    public static final int UNIT_WEEKS = 5;

    public static List<Long> calculateTimeFrame(int lastN, int unit) {
        ArrayList<Long> l = new ArrayList<Long>(0);
        if (unit == 1) {
            return null;
        }
        long now = System.currentTimeMillis();
        long retrospective = lastN;
        switch (unit) {
            case 5: {
                retrospective *= 604800000L;
                break;
            }
            case 2: {
                retrospective *= 60000L;
                break;
            }
            case 3: {
                retrospective *= 3600000L;
                break;
            }
            case 4: {
                retrospective *= 86400000L;
                break;
            }
            default: {
                retrospective = -1L;
            }
        }
        l.add(now - retrospective);
        l.add(now);
        return l;
    }

    public static MetricDisplaySummary parseMetricToken(String token) {
        String DELIMITER = ",";
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("parseMetricToken: input is " + token));
        }
        MetricDisplaySummary ret = new MetricDisplaySummary();
        String[] tokens = token.split(DELIMITER);
        if (tokens == null || tokens.length < 2) {
            throw new IllegalArgumentException(token + " is not valid");
        }
        if (tokens[0].equals("cg")) {
            ret.setGroupId(Integer.parseInt(tokens[1]));
            ret.setDefinitionId(Integer.parseInt(tokens[2]));
        } else if (tokens[0].equals("ag")) {
            ret.setParentId(Integer.parseInt(tokens[1]));
            ret.setDefinitionId(Integer.parseInt(tokens[2]));
            ret.setChildTypeId(Integer.parseInt(tokens[3]));
        } else {
            ret.setResourceId(Integer.parseInt(tokens[0]));
            ret.setScheduleId(Integer.parseInt(tokens[1]));
        }
        ret.setMetricToken(token);
        return ret;
    }
}

