/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.operation;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.JobId;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OperationSchedule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String jobName;
    private String jobGroup;
    private String operationName;
    private String operationDisplayName;
    private Configuration parameters;
    private Subject subject;
    private String description;

    public String getJobGroup() {
        return this.jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationDisplayName() {
        if (this.operationDisplayName == null || this.operationDisplayName.equals("")) {
            return this.getOperationName();
        }
        return this.operationDisplayName;
    }

    public void setOperationDisplayName(String operationDisplayName) {
        this.operationDisplayName = operationDisplayName;
    }

    public Configuration getParameters() {
        return this.parameters;
    }

    public void setParameters(Configuration parameters) {
        this.parameters = parameters;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        if (subject == null) {
            throw new NullPointerException("Cannot schedule an operation without a user associated with it");
        }
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement
    public JobId getJobId() {
        return new JobId(this.jobName, this.jobGroup);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("job-name=[" + this.jobName);
        str.append("], job-group=[" + this.jobGroup);
        str.append("], operation-name=[" + this.operationName);
        str.append("], subject=[" + this.subject);
        str.append("], description=[" + this.description);
        str.append("]");
        return str.toString();
    }
}

