/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.plugin.PluginDeploymentType;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ControlResults;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginServiceManagement;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.ControlDefinition;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorMetadataParser;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class ServerPluginsBean
implements ServerPluginsLocal {
    private final Log log = LogFactory.getLog(ServerPluginsBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS")
    private DataSource dataSource;
    @EJB
    private ServerPluginsLocal serverPluginsBean;

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void restartMasterPluginContainer(Subject subject) {
        LookupUtil.getServerPluginService().restartMasterPluginContainer();
    }

    @Override
    public List<ServerPlugin> getServerPlugins() {
        Query q = this.entityManager.createNamedQuery("ServerPlugin.findAllInstalled");
        return q.getResultList();
    }

    @Override
    public List<ServerPlugin> getAllServerPlugins() {
        Query q = this.entityManager.createNamedQuery("ServerPlugin.findAll");
        return q.getResultList();
    }

    @Override
    public ServerPlugin getServerPlugin(PluginKey key) {
        Query query = this.entityManager.createNamedQuery("ServerPlugin.findByName");
        query.setParameter("name", (Object)key.getPluginName());
        ServerPlugin plugin = (ServerPlugin)query.getSingleResult();
        return plugin;
    }

    @Override
    public ServerPlugin getServerPluginRelationships(ServerPlugin plugin) {
        Query query = this.entityManager.createNamedQuery("ServerPlugin.findByName");
        query.setParameter("name", (Object)plugin.getName());
        plugin = (ServerPlugin)query.getSingleResult();
        Configuration config = plugin.getPluginConfiguration();
        if (config != null) {
            config = (Configuration)this.entityManager.find(Configuration.class, (Object)config.getId());
            plugin.setPluginConfiguration(config.deepCopy());
        }
        if ((config = plugin.getScheduledJobsConfiguration()) != null) {
            config = (Configuration)this.entityManager.find(Configuration.class, (Object)config.getId());
            plugin.setScheduledJobsConfiguration(config.deepCopy());
        }
        return plugin;
    }

    @Override
    public List<ServerPlugin> getServerPluginsById(List<Integer> pluginIds) {
        if (pluginIds == null || pluginIds.size() == 0) {
            return new ArrayList<ServerPlugin>();
        }
        Query query = this.entityManager.createNamedQuery("ServerPlugin.findByIds");
        query.setParameter("ids", pluginIds);
        return query.getResultList();
    }

    @Override
    public List<ServerPlugin> getAllServerPluginsById(List<Integer> pluginIds) {
        if (pluginIds == null || pluginIds.size() == 0) {
            return new ArrayList<ServerPlugin>();
        }
        Query query = this.entityManager.createNamedQuery("ServerPlugin.findAllByIds");
        query.setParameter("ids", pluginIds);
        return query.getResultList();
    }

    @Override
    public long getLastConfigurationChangeTimestamp(int pluginId) {
        Query query = this.entityManager.createNamedQuery("ServerPlugin.getConfigMTimes");
        query.setParameter("id", (Object)pluginId);
        Object[] timestamps = (Object[])query.getSingleResult();
        long lastConfigChangeTimestamp = 0L;
        for (Object timestamp : timestamps) {
            long val;
            if (timestamp == null || (val = ((Long)timestamp).longValue()) <= lastConfigChangeTimestamp) continue;
            lastConfigChangeTimestamp = val;
        }
        return lastConfigChangeTimestamp;
    }

    @Override
    public ServerPluginDescriptorType getServerPluginDescriptor(PluginKey pluginKey) throws Exception {
        ServerPlugin plugin = this.getServerPlugin(pluginKey);
        File pluginsDir = LookupUtil.getServerPluginService().getServerPluginsDirectory();
        File pluginJar = new File(pluginsDir, plugin.getPath());
        URL url = pluginJar.toURI().toURL();
        ServerPluginDescriptorType descriptor = ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)url);
        return descriptor;
    }

    @Override
    public List<PluginKey> getServerPluginKeysByEnabled(boolean enabled) {
        Query query = this.entityManager.createNamedQuery("ServerPlugin.queryGetKeysByEnabled");
        query.setParameter("enabled", (Object)enabled);
        return query.getResultList();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public List<PluginKey> enableServerPlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return new ArrayList<PluginKey>();
        }
        ArrayList<PluginKey> pluginKeys = new ArrayList<PluginKey>();
        for (Integer pluginId : pluginIds) {
            this.serverPluginsBean.setServerPluginEnabledFlag(subject, pluginId, true);
            ServerPlugin plugin = null;
            try {
                plugin = (ServerPlugin)this.entityManager.getReference(ServerPlugin.class, (Object)pluginId);
            }
            catch (Exception e) {
                this.log.debug((Object)("Cannot enable plugin [" + pluginId + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            }
            if (plugin == null) continue;
            PluginKey pluginKey = new PluginKey(plugin);
            boolean success = this.enableServerPluginInMasterContainer(pluginKey);
            if (success) {
                pluginKeys.add(pluginKey);
                continue;
            }
            this.serverPluginsBean.setServerPluginEnabledFlag(subject, pluginId, false);
        }
        return pluginKeys;
    }

    private boolean enableServerPluginInMasterContainer(PluginKey pluginKey) {
        Object pc;
        ServerPluginServiceManagement serverPluginService = LookupUtil.getServerPluginService();
        MasterServerPluginContainer master = serverPluginService.getMasterPluginContainer();
        boolean success = true;
        if (master != null && (pc = master.getPluginContainerByPlugin(pluginKey)) != null) {
            try {
                ((AbstractTypeServerPluginContainer)pc).reloadPlugin(pluginKey, true);
                try {
                    ((AbstractTypeServerPluginContainer)pc).schedulePluginJobs(pluginKey);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to schedule jobs for plugin [" + pluginKey + "]"), (Throwable)e);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to enable server plugin [" + pluginKey + "]"), (Throwable)e);
                success = false;
            }
        }
        return success;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public List<PluginKey> disableServerPlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return new ArrayList<PluginKey>();
        }
        ArrayList<PluginKey> pluginKeys = new ArrayList<PluginKey>();
        for (Integer pluginId : pluginIds) {
            PluginKey pluginKey;
            boolean success;
            this.serverPluginsBean.setServerPluginEnabledFlag(subject, pluginId, false);
            ServerPlugin plugin = null;
            try {
                plugin = (ServerPlugin)this.entityManager.getReference(ServerPlugin.class, (Object)pluginId);
            }
            catch (Exception e) {
                this.log.debug((Object)("Cannot disable plugin [" + pluginId + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            }
            if (plugin == null || !(success = this.disableServerPluginInMasterContainer(pluginKey = new PluginKey(plugin)))) continue;
            pluginKeys.add(pluginKey);
        }
        return pluginKeys;
    }

    private boolean disableServerPluginInMasterContainer(PluginKey pluginKey) {
        Object pc;
        ServerPluginServiceManagement serverPluginService = LookupUtil.getServerPluginService();
        MasterServerPluginContainer master = serverPluginService.getMasterPluginContainer();
        boolean success = true;
        if (master != null && (pc = master.getPluginContainerByPlugin(pluginKey)) != null) {
            try {
                ((AbstractTypeServerPluginContainer)pc).unschedulePluginJobs(pluginKey);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to unschedule jobs for plugin [" + pluginKey + "]"), (Throwable)e);
            }
            try {
                ((AbstractTypeServerPluginContainer)pc).reloadPlugin(pluginKey, false);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to disable server plugin [" + pluginKey + "]"), (Throwable)e);
                success = false;
            }
        }
        return success;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public List<PluginKey> undeployServerPlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return new ArrayList<PluginKey>();
        }
        ArrayList<PluginKey> pluginKeys = new ArrayList<PluginKey>();
        for (Integer pluginId : pluginIds) {
            this.serverPluginsBean.setServerPluginEnabledFlag(subject, pluginId, false);
            ServerPlugin plugin = null;
            try {
                plugin = (ServerPlugin)this.entityManager.getReference(ServerPlugin.class, (Object)pluginId);
            }
            catch (Exception e) {
                this.log.debug((Object)("Cannot undeploy plugin [" + pluginId + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            }
            if (plugin == null) continue;
            PluginKey pluginKey = new PluginKey(plugin);
            boolean success = this.undeployServerPluginInMasterContainer(pluginKey);
            if (success) {
                pluginKeys.add(pluginKey);
            }
            if (plugin.getPluginConfiguration() != null) {
                this.entityManager.remove((Object)plugin.getPluginConfiguration());
                plugin.setPluginConfiguration(null);
            }
            if (plugin.getScheduledJobsConfiguration() != null) {
                this.entityManager.remove((Object)plugin.getScheduledJobsConfiguration());
                plugin.setScheduledJobsConfiguration(null);
            }
            plugin.setStatus(PluginStatusType.DELETED);
            try {
                File pluginDir = LookupUtil.getServerPluginService().getServerPluginsDirectory();
                File currentFile = new File(pluginDir, plugin.getPath());
                currentFile.delete();
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to delete the undeployed plugin file [" + plugin.getPath() + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            }
            this.log.info((Object)("Server plugin [" + pluginKey + "] has been undeployed"));
        }
        return pluginKeys;
    }

    private boolean undeployServerPluginInMasterContainer(PluginKey pluginKey) {
        Object pc;
        ServerPluginServiceManagement serverPluginService = LookupUtil.getServerPluginService();
        MasterServerPluginContainer master = serverPluginService.getMasterPluginContainer();
        boolean success = true;
        if (master != null && (pc = master.getPluginContainerByPlugin(pluginKey)) != null) {
            try {
                ((AbstractTypeServerPluginContainer)pc).unschedulePluginJobs(pluginKey);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to unschedule jobs for server plugin [" + pluginKey + "]"), (Throwable)e);
            }
            try {
                ((AbstractTypeServerPluginContainer)pc).unloadPlugin(pluginKey);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to unload server plugin [" + pluginKey + "]"), (Throwable)e);
                success = false;
            }
        }
        return success;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public List<PluginKey> purgeServerPlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return new ArrayList<PluginKey>();
        }
        List<PluginKey> purgePlugins = this.undeployServerPlugins(subject, pluginIds);
        for (PluginKey pluginKey : purgePlugins) {
            this.purgeServerPlugin(subject, pluginKey);
        }
        this.log.info((Object)("Server plugins " + purgePlugins + " have been purged"));
        return purgePlugins;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setServerPluginEnabledFlag(Subject subject, int pluginId, boolean enabled) throws Exception {
        Query q = this.entityManager.createNamedQuery("ServerPlugin.updatePluginEnabledById");
        q.setParameter("id", (Object)pluginId);
        q.setParameter("enabled", (Object)enabled);
        q.executeUpdate();
        this.log.info((Object)((enabled ? "Enabling" : "Disabling") + " server plugin [" + pluginId + "]"));
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setServerPluginStatus(Subject subject, List<Integer> pluginIds, PluginStatusType status) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return;
        }
        List<ServerPlugin> plugins = this.getServerPluginsById(pluginIds);
        for (ServerPlugin plugin : plugins) {
            plugin.setStatus(status);
            this.updateServerPluginExceptContent(subject, plugin);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public ServerPlugin registerServerPlugin(Subject subject, ServerPlugin plugin, File pluginFile) throws Exception {
        if (plugin.getDeployment() != PluginDeploymentType.SERVER) {
            throw new IllegalArgumentException("Plugin [" + plugin.getName() + "] must be a server plugin to be registered");
        }
        PluginKey pluginKey = new PluginKey(plugin);
        ServerPlugin existingPlugin = null;
        boolean newOrUpdated = false;
        try {
            existingPlugin = this.getServerPlugin(pluginKey);
        }
        catch (NoResultException nre) {
            newOrUpdated = true;
        }
        if (existingPlugin != null) {
            if (existingPlugin.getStatus() == PluginStatusType.DELETED) {
                throw new IllegalArgumentException("Cannot register plugin [" + plugin.getName() + "], it has been marked as deleted");
            }
            ServerPlugin obsolete = ServerPluginDescriptorUtil.determineObsoletePlugin((ServerPlugin)plugin, (ServerPlugin)existingPlugin);
            if (obsolete == existingPlugin) {
                plugin.setPluginConfiguration(existingPlugin.getPluginConfiguration());
                plugin.setScheduledJobsConfiguration(existingPlugin.getScheduledJobsConfiguration());
                newOrUpdated = true;
            }
            plugin.setId(existingPlugin.getId());
        }
        if (newOrUpdated) {
            if (plugin.getDisplayName() == null) {
                plugin.setDisplayName(plugin.getName());
            }
            if (plugin.getId() == 0) {
                this.entityManager.persist((Object)plugin);
            } else {
                this.undeployServerPluginInMasterContainer(pluginKey);
                plugin = this.updateServerPluginExceptContent(subject, plugin);
            }
            if (pluginFile != null) {
                this.entityManager.flush();
                this.streamPluginFileContentToDatabase(plugin.getId(), pluginFile);
                this.loadServerPluginInMasterContainer(pluginFile.toURI().toURL());
            }
            if (plugin.isEnabled()) {
                this.enableServerPluginInMasterContainer(pluginKey);
            }
            this.log.info((Object)("Server plugin [" + plugin.getName() + "] has been registered in the database"));
        }
        return plugin;
    }

    private void loadServerPluginInMasterContainer(URL pluginUrl) throws Exception {
        ServerPluginServiceManagement serverPluginService = LookupUtil.getServerPluginService();
        MasterServerPluginContainer master = serverPluginService.getMasterPluginContainer();
        if (master != null) {
            master.loadPlugin(pluginUrl, false);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void purgeServerPlugin(Subject subject, PluginKey pluginKey) {
        Query q = this.entityManager.createNamedQuery("ServerPlugin.findAnyByName");
        q.setParameter("name", (Object)pluginKey.getPluginName());
        ServerPlugin doomed = (ServerPlugin)q.getSingleResult();
        doomed = (ServerPlugin)this.entityManager.getReference(ServerPlugin.class, (Object)doomed.getId());
        this.entityManager.remove((Object)doomed);
        this.log.info((Object)("Server plugin [" + pluginKey + "] has been purged from the db"));
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public ServerPlugin updateServerPluginExceptContent(Subject subject, ServerPlugin plugin) throws Exception {
        if (plugin.getId() == 0) {
            throw new IllegalArgumentException("Plugin must already exist to update it");
        }
        Configuration config = plugin.getPluginConfiguration();
        if (config != null) {
            config = (Configuration)this.entityManager.merge((Object)config);
            plugin.setPluginConfiguration(config);
        }
        if ((config = plugin.getScheduledJobsConfiguration()) != null) {
            config = (Configuration)this.entityManager.merge((Object)config);
            plugin.setScheduledJobsConfiguration(config);
        }
        ServerPlugin pluginEntity = (ServerPlugin)this.entityManager.getReference(ServerPlugin.class, (Object)plugin.getId());
        pluginEntity.setName(plugin.getName());
        pluginEntity.setPath(plugin.getPath());
        pluginEntity.setDisplayName(plugin.getDisplayName());
        pluginEntity.setEnabled(plugin.isEnabled());
        pluginEntity.setStatus(plugin.getStatus());
        pluginEntity.setMd5(plugin.getMD5());
        pluginEntity.setVersion(plugin.getVersion());
        pluginEntity.setAmpsVersion(plugin.getAmpsVersion());
        pluginEntity.setDeployment(plugin.getDeployment());
        pluginEntity.setPluginConfiguration(plugin.getPluginConfiguration());
        pluginEntity.setScheduledJobsConfiguration(plugin.getScheduledJobsConfiguration());
        pluginEntity.setType(plugin.getType());
        pluginEntity.setDescription(plugin.getDescription());
        pluginEntity.setHelp(plugin.getHelp());
        pluginEntity.setMtime(plugin.getMtime());
        try {
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new Exception("Failed to update a plugin that matches [" + plugin + "]", e);
        }
        return plugin;
    }

    @Override
    public PluginStatusType getServerPluginStatus(PluginKey pluginKey) {
        PluginStatusType status;
        Query q = this.entityManager.createNamedQuery("ServerPlugin.queryGetStatusByName");
        q.setParameter("name", (Object)pluginKey.getPluginName());
        try {
            status = (PluginStatusType)q.getSingleResult();
        }
        catch (NoResultException nre) {
            status = null;
        }
        return status;
    }

    @Override
    public Map<ServerPluginType, List<PluginKey>> getInstalledServerPluginsGroupedByType() {
        Query q = this.entityManager.createNamedQuery("ServerPlugin.findAllInstalledKeys");
        List keys = q.getResultList();
        HashMap<ServerPluginType, List<PluginKey>> allPlugins = new HashMap<ServerPluginType, List<PluginKey>>();
        for (PluginKey key : keys) {
            try {
                ServerPluginType type = new ServerPluginType(key.getPluginType());
                ArrayList<PluginKey> knownPluginsForType = (ArrayList<PluginKey>)allPlugins.get(type);
                if (knownPluginsForType == null) {
                    knownPluginsForType = new ArrayList<PluginKey>();
                    allPlugins.put(type, knownPluginsForType);
                }
                knownPluginsForType.add(key);
            }
            catch (Exception e) {
                this.log.warn((Object)("Invalid plugin key found [" + key + "]"), (Throwable)e);
            }
        }
        return allPlugins;
    }

    @Override
    public List<ControlDefinition> getServerPluginControlDefinitions(PluginKey pluginKey) throws Exception {
        ServerPluginServiceManagement serverPluginService = LookupUtil.getServerPluginService();
        MasterServerPluginContainer master = serverPluginService.getMasterPluginContainer();
        if (master != null) {
            Object pc = master.getPluginContainerByPlugin(pluginKey);
            if (pc != null) {
                ServerPluginEnvironment env = ((AbstractTypeServerPluginContainer)pc).getPluginManager().getPluginEnvironment(pluginKey.getPluginName());
                List defs = ServerPluginDescriptorMetadataParser.getControlDefinitions((ServerPluginDescriptorType)env.getPluginDescriptor());
                return defs;
            }
            throw new Exception("There is no known plugin named [" + pluginKey + "]");
        }
        throw new Exception("Master plugin container not available - is it initialized?");
    }

    @Override
    public ControlResults invokeServerPluginControl(PluginKey pluginKey, String controlName, Configuration params) throws Exception {
        ServerPluginServiceManagement serverPluginService = LookupUtil.getServerPluginService();
        MasterServerPluginContainer master = serverPluginService.getMasterPluginContainer();
        if (master != null) {
            Object pc = master.getPluginContainerByPlugin(pluginKey);
            if (pc != null) {
                ControlResults results = ((AbstractTypeServerPluginContainer)pc).invokePluginControl(pluginKey, controlName, params);
                return results;
            }
            throw new Exception("There is no known plugin named [" + pluginKey + "]. Cannot invoke [" + controlName + "]");
        }
        throw new Exception("Master plugin container not available - is it initialized?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamPluginFileContentToDatabase(int id, File file) throws Exception {
        FileInputStream fis;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            rs = null;
            fis = new FileInputStream(file);
            try {
                conn = this.dataSource.getConnection();
                ps = conn.prepareStatement("UPDATE RHQ_PLUGIN SET CONTENT = ? WHERE ID = ?");
                ps.setBinaryStream(1, (InputStream)new BufferedInputStream(fis), (int)file.length());
                ps.setInt(2, id);
                int updateResults = ps.executeUpdate();
                if (updateResults == 1) break block6;
                throw new Exception("Failed to update content for plugin [" + id + "] from [" + file + "]");
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose((Connection)conn, ps, rs);
                try {
                    fis.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
        try {
            fis.close();
        }
        catch (Throwable t) {}
    }

    private List<PluginKey> getPluginKeysFromIds(List<Integer> pluginIds) {
        Query q = this.entityManager.createNamedQuery("ServerPlugin.findKeysByIds");
        q.setParameter("ids", pluginIds);
        List keys = q.getResultList();
        return keys;
    }
}

