/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ClusterKey;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.ClusterFlyweight;
import org.rhq.core.domain.resource.group.composite.ClusterKeyFlyweight;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.resource.cluster.ClusterManagerLocal;
import org.rhq.enterprise.server.resource.cluster.ClusterManagerRemote;
import org.rhq.enterprise.server.resource.group.ResourceGroupAlreadyExistsException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;

@Stateless
public class ClusterManagerBean
implements ClusterManagerLocal,
ClusterManagerRemote {
    private final Log log = LogFactory.getLog(ClusterManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    public ResourceGroup createAutoClusterBackingGroup(Subject subject, ClusterKey clusterKey, boolean addResources) {
        ResourceGroup autoClusterBackingGroup = null;
        Query query = this.entityManager.createNamedQuery("ResourceGroup.findByClusterKey");
        query.setParameter("clusterKey", (Object)clusterKey.toString());
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)ClusterKey.getResourceType((ClusterKey)clusterKey));
        ResourceGroup resourceGroup = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)clusterKey.getClusterGroupId());
        if (!this.authorizationManager.canViewGroup(subject, clusterKey.getClusterGroupId())) {
            throw new PermissionException("You do not have permission to view child cluster groups of the group [" + resourceGroup.getName() + "]");
        }
        List<Resource> resources = null;
        try {
            autoClusterBackingGroup = (ResourceGroup)query.getSingleResult();
        }
        catch (NoResultException nre) {
            try {
                resources = this.getAutoClusterResources(subject, clusterKey);
                String name = null;
                if (resources.isEmpty()) {
                    name = "Group of " + resourceType.getName();
                } else {
                    for (Resource res : resources) {
                        if (name == null) {
                            name = res.getName();
                            continue;
                        }
                        if (name.equals(res.getName())) continue;
                        name = "Group of " + resourceType.getName();
                    }
                }
                autoClusterBackingGroup = new ResourceGroup(name, resourceType);
                autoClusterBackingGroup.setClusterKey(clusterKey.toString());
                autoClusterBackingGroup.setClusterResourceGroup(resourceGroup);
                autoClusterBackingGroup.setVisible(false);
                int id = this.resourceGroupManager.createResourceGroup(this.subjectManager.getOverlord(), autoClusterBackingGroup).getId();
                autoClusterBackingGroup = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)id);
            }
            catch (ResourceGroupAlreadyExistsException e) {
                this.log.error((Object)("Unexpected Error, group exists " + e));
                return null;
            }
        }
        if (addResources) {
            if (resources == null) {
                resources = this.getAutoClusterResources(subject, clusterKey);
            }
            int i = 0;
            int[] resourceIds = new int[resources.size()];
            for (Resource res : resources) {
                resourceIds[i++] = res.getId();
            }
            try {
                this.resourceGroupManager.setAssignedResources(this.subjectManager.getOverlord(), autoClusterBackingGroup.getId(), resourceIds, false);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not add resources to group:" + e));
            }
        }
        return autoClusterBackingGroup;
    }

    @Override
    public ResourceGroup getAutoClusterBackingGroup(Subject subject, ClusterKey clusterKey) {
        ResourceGroup result = null;
        Query query = this.entityManager.createNamedQuery("ResourceGroup.findByClusterKey");
        query.setParameter("clusterKey", (Object)clusterKey.toString());
        try {
            result = (ResourceGroup)query.getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        return result;
    }

    @Override
    public List<Resource> getAutoClusterResources(Subject subject, ClusterKey clusterKey) {
        String queryString = this.getClusterKeyQuery(clusterKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getAutoClusterResources() generated query: " + queryString));
        }
        Query query = this.entityManager.createQuery(queryString);
        List rs = query.getResultList();
        return rs;
    }

    @Override
    public ClusterFlyweight getClusterTree(Subject subject, int groupId) {
        Query query = this.entityManager.createQuery("SELECT r.id, r.resourceType.id, r.parentResource.id, r.resourceKey, r.name, (SELECT count(r2) FROM Resource r2 join r2.explicitGroups g2 WHERE g2.id = :groupId and r2.id = r.id) FROM Resource r join r.implicitGroups g WHERE g.id = :groupId");
        query.setParameter("groupId", (Object)groupId);
        List rs = query.getResultList();
        HashMap<Integer, List<Object[]>> dataMap = new HashMap<Integer, List<Object[]>>();
        HashSet<Integer> explicitResources = new HashSet<Integer>();
        for (Object[] d : rs) {
            Integer parentId = (Integer)d[2];
            ArrayList<Object[]> childList = (ArrayList<Object[]>)dataMap.get(parentId);
            if (childList == null) {
                childList = new ArrayList<Object[]>();
                dataMap.put(parentId, childList);
            }
            childList.add(d);
            if ((Long)d[5] <= 0L) continue;
            explicitResources.add((Integer)d[0]);
        }
        ClusterFlyweight key = new ClusterFlyweight(groupId);
        this.buildTree(groupId, key, explicitResources, dataMap);
        return key;
    }

    private void buildTree(int groupId, ClusterFlyweight parent, Set<Integer> parentIds, Map<Integer, List<Object[]>> data) {
        for (Integer parentId : parentIds) {
            HashMap<ClusterKeyFlyweight, ClusterFlyweight> children = new HashMap<ClusterKeyFlyweight, ClusterFlyweight>();
            HashMap<ClusterKeyFlyweight, HashSet<Integer>> members = new HashMap<ClusterKeyFlyweight, HashSet<Integer>>();
            if (data.get(parentId) != null) {
                for (Object[] objectArray : data.get(parentId)) {
                    ClusterKeyFlyweight n = new ClusterKeyFlyweight(((Integer)objectArray[1]).intValue(), (String)objectArray[3]);
                    ClusterFlyweight flyweight = (ClusterFlyweight)children.get(n);
                    HashSet<Integer> memberList = (HashSet<Integer>)members.get(n);
                    if (flyweight == null) {
                        flyweight = new ClusterFlyweight(n);
                        children.put(n, flyweight);
                        memberList = new HashSet<Integer>();
                        members.put(n, memberList);
                    }
                    flyweight.addResource((String)objectArray[4]);
                    memberList.add((Integer)objectArray[0]);
                }
            }
            parent.setChildren(new ArrayList(children.values()));
            for (ClusterFlyweight clusterFlyweight : children.values()) {
                this.buildTree(groupId, clusterFlyweight, (Set)members.get(clusterFlyweight.getClusterKey()), data);
            }
        }
    }

    private String getClusterKeyQuery(ClusterKey clusterKey) {
        if (null == clusterKey) {
            return null;
        }
        if (0 == clusterKey.getDepth()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        this.buildQuery(query, clusterKey, clusterKey.getHierarchy());
        return query.toString();
    }

    private void buildQuery(StringBuilder query, ClusterKey clusterKey, List<ClusterKey.Node> nodes) {
        int size = nodes.size();
        ClusterKey.Node node = nodes.get(size - 1);
        String alias = "r" + size;
        query.append(" SELECT " + alias + " FROM Resource " + alias + " WHERE ");
        query.append(alias + ".resourceKey = '" + node.getResourceKey() + "' AND ");
        query.append(alias + ".resourceType = " + node.getResourceTypeId() + " AND ");
        query.append(alias + ".parentResource IN ( ");
        if (1 == size) {
            query.append("SELECT rgir FROM ResourceGroup rg JOIN rg.implicitResources rgir WHERE rg = " + clusterKey.getClusterGroupId());
        } else {
            this.buildQuery(query, clusterKey, nodes.subList(0, size - 1));
        }
        query.append(")");
    }
}

