/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.disambiguation;

import java.util.ArrayList;
import java.util.List;
import org.rhq.core.domain.resource.composite.DisambiguationReport;

public class MutableDisambiguationReport<T> {
    public T original;
    public Resource resource;
    public List<Resource> parents;

    public DisambiguationReport<T> getReport() {
        ArrayList<DisambiguationReport.Resource> realParents = new ArrayList<DisambiguationReport.Resource>();
        if (this.parents != null) {
            for (Resource p : this.parents) {
                realParents.add(p.getResource());
            }
        }
        return new DisambiguationReport(this.original, realParents, this.resource.resourceType.getResourceType(), this.resource.name);
    }

    public String toString() {
        return "MutableDisambiguationReport[resource=" + this.resource + ", parents=" + this.parents + "]";
    }

    public static class Resource
    implements Cloneable {
        public int id;
        public String name;
        public ResourceType resourceType;

        public DisambiguationReport.Resource getResource() {
            return new DisambiguationReport.Resource(this.id, this.name, this.resourceType.getResourceType());
        }

        public String toString() {
            return "MutableResource[id=" + this.id + ", name='" + this.name + ", resourceType=" + this.resourceType + "]";
        }

        public Resource clone() {
            Resource ret = new Resource();
            ret.id = this.id;
            ret.name = this.name;
            ret.resourceType = this.resourceType.clone();
            return ret;
        }
    }

    public static class ResourceType
    implements Cloneable {
        public int id;
        public String name;
        public String plugin;
        public boolean singleton;

        public DisambiguationReport.ResourceType getResourceType() {
            return new DisambiguationReport.ResourceType(this.name, this.plugin, this.singleton);
        }

        public String toString() {
            return "MutableResourceType[id=" + this.id + ", name='" + this.name + "', plugin='" + this.plugin + "', singleton=" + this.singleton + "]";
        }

        public ResourceType clone() {
            ResourceType ret = new ResourceType();
            ret.id = this.id;
            ret.name = this.name;
            ret.plugin = this.plugin;
            ret.singleton = this.singleton;
            return ret;
        }
    }
}

