/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.exception.UnscheduleException;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.operation.ResourceOperationSchedule;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.util.LookupUtil;

public class AsyncResourceDeleteJob
extends AbstractStatefulJob {
    private final Log log = LogFactory.getLog(AsyncResourceDeleteJob.class);
    Subject overlord = LookupUtil.getSubjectManager().getOverlord();
    ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();

    @Override
    public void executeJobCode(JobExecutionContext arg0) throws JobExecutionException {
        List<Integer> toBeRemovedIds = this.resourceManager.findResourcesMarkedForAsyncDeletion(this.overlord);
        AsyncDeletionStats stats = new AsyncDeletionStats();
        for (Integer doomedResourceId : toBeRemovedIds) {
            try {
                this.uninventoryResource(this.overlord, doomedResourceId, stats, false);
            }
            catch (Throwable t) {
                this.log.debug((Object)("Simple asynchronous deletion of resource[id=" + doomedResourceId + "] failed, " + "trying more robust yet expensive removal method, cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
                try {
                    this.uninventoryResource(this.overlord, doomedResourceId, stats, true);
                }
                catch (Throwable tt) {
                    this.log.debug((Object)("Error during asynchronous deletion of resource[id=" + doomedResourceId + "], cause: " + ThrowableUtil.getAllMessages((Throwable)tt)));
                    ++stats.deletedWithFailure;
                }
            }
        }
        if (stats.deletedSuccessfully > 0 || stats.deletedWithFailure > 0) {
            this.log.info((Object)stats);
        }
    }

    private void uninventoryResource(Subject overlord, Integer doomedResourceId, AsyncDeletionStats stats, boolean recurse) {
        if (recurse) {
            List<Integer> doomedChildrenIds = this.resourceManager.findChildrenResourceIds(doomedResourceId, null);
            for (Integer nextDoomedChildId : doomedChildrenIds) {
                this.uninventoryResource(overlord, nextDoomedChildId, stats, recurse);
            }
        }
        this.log.debug((Object)("Before " + (recurse ? "(recursive)" : "") + " asynchronous deletion of resource[id=" + doomedResourceId + "]"));
        long startTime = System.currentTimeMillis();
        this.unscheduleJobs(overlord, doomedResourceId);
        this.resourceManager.uninventoryResourceAsyncWork(overlord, doomedResourceId);
        ++stats.deletedSuccessfully;
        long endTime = System.currentTimeMillis();
        this.log.debug((Object)("After " + (recurse ? "(recursive)" : "") + " asynchronous deletion of resource[id=" + doomedResourceId + "] took [" + (endTime - startTime) + "]ms"));
        stats.deletionTime += endTime - startTime;
    }

    private void unscheduleJobs(Subject overlord, Integer resourceId) {
        this.log.debug((Object)("Unscheduling jobs for resource[id=" + resourceId + "]"));
        OperationManagerLocal operationManager = LookupUtil.getOperationManager();
        try {
            List<ResourceOperationSchedule> schedules = operationManager.findScheduledResourceOperations(overlord, resourceId);
            for (ResourceOperationSchedule schedule : schedules) {
                try {
                    operationManager.unscheduleResourceOperation(overlord, schedule.getJobId().toString(), resourceId);
                }
                catch (UnscheduleException ise) {
                    this.log.warn((Object)("Failed to unschedule job [" + schedule + "] for a resource being deleted [" + resourceId + "]"), (Throwable)ise);
                }
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Failed to get jobs for a resource being deleted [" + resourceId + "]; will not attempt to unschedule anything"), t);
        }
    }

    private class AsyncDeletionStats {
        int deletedSuccessfully = 0;
        int deletedWithFailure = 0;
        long deletionTime;

        private AsyncDeletionStats() {
        }

        public String toString() {
            return "Async resource deletion - " + this.deletedSuccessfully + " successful, " + this.deletedWithFailure + " failed, took [" + this.deletionTime + "] ms";
        }
    }
}

