/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.common;

import org.rhq.enterprise.server.search.translation.antlr.RHQLComparisonOperator;
import org.rhq.enterprise.server.util.QueryUtility;

public class SearchQueryGenerationUtility {
    public static String getJPQLForString(String fragment, String value) {
        if (value == null) {
            value = "";
        }
        return SearchQueryGenerationUtility.getJPQLForString(fragment, RHQLComparisonOperator.EQUALS, value);
    }

    public static String getJPQLForString(String fragment, RHQLComparisonOperator operator, String value) {
        if (value == null) {
            value = "";
        }
        int size = value.length();
        if (value.startsWith("^")) {
            if (value.endsWith("$")) {
                return SearchQueryGenerationUtility.getJPQLForString(fragment, operator, value.substring(1, size - 1), ValueFilter.EXACT_MATCH);
            }
            return SearchQueryGenerationUtility.getJPQLForString(fragment, operator, value.substring(1), ValueFilter.STARTS_WITH);
        }
        if (value.endsWith("$")) {
            return SearchQueryGenerationUtility.getJPQLForString(fragment, operator, value.substring(0, size - 1), ValueFilter.ENDS_WITH);
        }
        return SearchQueryGenerationUtility.getJPQLForString(fragment, operator, value, ValueFilter.INDEX_OF);
    }

    private static String getJPQLForString(String fragment, RHQLComparisonOperator operator, String value, ValueFilter filter) {
        if (operator == RHQLComparisonOperator.EQUALS) {
            return SearchQueryGenerationUtility.lower(fragment) + " LIKE " + SearchQueryGenerationUtility.process(filter, value.toLowerCase());
        }
        if (operator == RHQLComparisonOperator.EQUALS_STRICT) {
            return fragment + " LIKE " + SearchQueryGenerationUtility.process(filter, value);
        }
        if (operator == RHQLComparisonOperator.NOT_EQUALS) {
            return SearchQueryGenerationUtility.lower(fragment) + " NOT LIKE " + SearchQueryGenerationUtility.process(filter, value.toLowerCase());
        }
        if (operator == RHQLComparisonOperator.NOT_EQUALS_STRICT) {
            return fragment + " NOT LIKE " + SearchQueryGenerationUtility.process(filter, value);
        }
        if (operator == RHQLComparisonOperator.NULL) {
            return fragment + " IS NULL";
        }
        if (operator == RHQLComparisonOperator.NOT_NULL) {
            return fragment + " IS NOT NULL";
        }
        throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)operator));
    }

    private static String process(ValueFilter filter, String value) {
        if (filter == ValueFilter.STARTS_WITH) {
            return "'" + SearchQueryGenerationUtility.escape(value) + "%'";
        }
        if (filter == ValueFilter.ENDS_WITH) {
            return "'%" + SearchQueryGenerationUtility.escape(value) + "'";
        }
        if (filter == ValueFilter.INDEX_OF) {
            return "'%" + SearchQueryGenerationUtility.escape(value) + "%'";
        }
        if (filter == ValueFilter.EXACT_MATCH) {
            return "'" + SearchQueryGenerationUtility.escape(value) + "'";
        }
        throw new IllegalArgumentException("Unsupported ValueFilter: " + (Object)((Object)filter));
    }

    public static String lower(String data) {
        return "LOWER(" + data + ")";
    }

    public static String escape(String data) {
        return QueryUtility.escapeSearchParameter(data);
    }

    public static enum ValueFilter {
        STARTS_WITH,
        ENDS_WITH,
        INDEX_OF,
        EXACT_MATCH;

    }
}

