/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.test.ResourceGroupTestBeanLocal;

@Stateless
public class ResourceGroupTestBean
implements ResourceGroupTestBeanLocal {
    private static int compatCounter = 0;
    private static int mixedCounter = 0;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    private int getNextCompat() {
        return compatCounter++;
    }

    private int getNextMixed() {
        return mixedCounter++;
    }

    @Override
    public void setupCompatibleGroups() {
        List types = this.entityManager.createQuery("SELECT rt FROM ResourceType rt").getResultList();
        for (ResourceType type : types) {
            Query query = this.entityManager.createQuery("SELECT res FROM Resource res WHERE res.resourceType = :type");
            query.setParameter("type", (Object)type);
            List resources = query.getResultList();
            ResourceGroup compatGroup = new ResourceGroup("Compat Group - " + this.getNextCompat(), type);
            this.entityManager.persist((Object)compatGroup);
            compatGroup.getExplicitResources().addAll(resources);
            compatGroup.getImplicitResources().addAll(resources);
            for (Resource resource : resources) {
                resource.getExplicitGroups().add(compatGroup);
                resource.getImplicitGroups().add(compatGroup);
                this.entityManager.merge((Object)resource);
            }
            this.entityManager.merge((Object)compatGroup);
        }
    }

    @Override
    public void setupUberMixedGroup() {
        Query query = this.entityManager.createQuery("SELECT res FROM Resource res");
        List resources = query.getResultList();
        ResourceGroup mixedGroup = new ResourceGroup("Mixed Group - " + this.getNextMixed());
        this.entityManager.persist((Object)mixedGroup);
        mixedGroup.getExplicitResources().addAll(resources);
        mixedGroup.getImplicitResources().addAll(resources);
        for (Resource resource : resources) {
            resource.getExplicitGroups().add(mixedGroup);
            resource.getImplicitGroups().add(mixedGroup);
            this.entityManager.merge((Object)resource);
        }
        this.entityManager.merge((Object)mixedGroup);
    }
}

