/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;

public class CriteriaQueryRunner<T> {
    private static final Log LOG = LogFactory.getLog(CriteriaQueryRunner.class);
    private Criteria criteria;
    private CriteriaQueryGenerator queryGenerator;
    private EntityManager entityManager;
    private boolean autoInitializeBags;

    public CriteriaQueryRunner(Criteria criteria, CriteriaQueryGenerator queryGenerator, EntityManager entityManager) {
        this(criteria, queryGenerator, entityManager, true);
    }

    public CriteriaQueryRunner(Criteria criteria, CriteriaQueryGenerator queryGenerator, EntityManager entityManager, boolean autoInitializeBags) {
        this.criteria = criteria;
        this.queryGenerator = queryGenerator;
        this.entityManager = entityManager;
        this.autoInitializeBags = autoInitializeBags;
    }

    public PageList<T> execute() {
        Query query = this.queryGenerator.getQuery(this.entityManager);
        Query countQuery = this.queryGenerator.getCountQuery(this.entityManager);
        long count = (Long)countQuery.getSingleResult();
        List results = query.getResultList();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("resultSize=" + results.size() + ", count=" + count));
        }
        if (this.autoInitializeBags && !this.queryGenerator.getPersistentBagFields().isEmpty()) {
            for (Object entity : results) {
                this.initPersistentBags(entity);
            }
        }
        PageControl pageControl = CriteriaQueryGenerator.getPageControl(this.criteria);
        PageList pagedResults = new PageList((Collection)results, (int)count, pageControl);
        return pagedResults;
    }

    public void initPersistentBags(Object entity) {
        for (Field persistentBagField : this.queryGenerator.getPersistentBagFields()) {
            List<?> persistentBag = this.getList(entity, persistentBagField);
            persistentBag.size();
        }
    }

    private List<?> getList(Object entity, Field field) {
        try {
            field.setAccessible(true);
            return (List)field.get(entity);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

