/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.rhq.enterprise.server.util.security.BogusTrustManager;

public class UntrustedSSLProtocolSocketFactory
extends SSLProtocolSocketFactory {
    private static Protocol defaultSSL;
    private static Protocol untrustSSL;
    private SSLSocketFactory factory;

    private static boolean isRegistered() {
        Protocol https = Protocol.getProtocol((String)"https");
        boolean isRegistered = https.getSocketFactory() instanceof UntrustedSSLProtocolSocketFactory;
        if (!isRegistered) {
            defaultSSL = https;
        }
        return isRegistered;
    }

    public static void register() {
        if (!UntrustedSSLProtocolSocketFactory.isRegistered()) {
            if (untrustSSL == null) {
                untrustSSL = new Protocol("https", (ProtocolSocketFactory)new UntrustedSSLProtocolSocketFactory(), 443);
            }
            Protocol.registerProtocol((String)"https", (Protocol)untrustSSL);
        }
    }

    public static void unregister() {
        if (UntrustedSSLProtocolSocketFactory.isRegistered()) {
            Protocol.registerProtocol((String)"https", (Protocol)defaultSSL);
        }
    }

    public UntrustedSSLProtocolSocketFactory() {
        try {
            BogusTrustManager trustMan = new BogusTrustManager();
            SSLContext tlsContext = SSLContext.getInstance("TLS");
            tlsContext.init(null, new X509TrustManager[]{trustMan}, null);
            this.factory = tlsContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException exc) {
            throw new IllegalStateException("Unable to get SSL context: " + exc.getMessage());
        }
        catch (KeyManagementException exc) {
            throw new IllegalStateException("Unable to initialize ctx with BogusTrustManager: " + exc.getMessage());
        }
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.factory.createSocket(socket, host, port, autoClose);
    }
}

