/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.rhq.core.domain.util.Summary;

public class SummaryFilter {
    public PropertyDescriptor[] getPropertyDescriptors(Object object, boolean exportMode) throws IntrospectionException {
        BeanInfo info = Introspector.getBeanInfo(object.getClass(), object.getClass().getSuperclass());
        final HashMap<PropertyDescriptor, Integer> indexes = new HashMap<PropertyDescriptor, Integer>();
        for (PropertyDescriptor property : info.getPropertyDescriptors()) {
            int index;
            boolean add;
            block8: {
                add = false;
                index = 100;
                try {
                    Field field = this.getField(property);
                    if (field.isAnnotationPresent(Summary.class)) {
                        add = true;
                        index = field.getAnnotation(Summary.class).index();
                    } else if (property.getReadMethod() != null && property.getReadMethod().isAnnotationPresent(Summary.class)) {
                        add = true;
                        index = property.getReadMethod().getAnnotation(Summary.class).index();
                    }
                }
                catch (NoSuchFieldException e) {
                    if (property.getReadMethod() == null || !property.getReadMethod().isAnnotationPresent(Summary.class)) break block8;
                    add = true;
                    index = property.getReadMethod().getAnnotation(Summary.class).index();
                }
            }
            if (!add && !exportMode) continue;
            indexes.put(property, index);
        }
        if (indexes.isEmpty()) {
            for (PropertyDescriptor property : info.getPropertyDescriptors()) {
                indexes.put(property, 0);
            }
        }
        PropertyDescriptor[] descriptors = indexes.keySet().toArray(new PropertyDescriptor[indexes.size()]);
        Arrays.sort(descriptors, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                int i = ((Integer)indexes.get(o1)).compareTo((Integer)indexes.get(o2));
                if (i == 0) {
                    i = o1.getName().compareTo(o2.getName());
                }
                return i;
            }
        });
        return descriptors;
    }

    private Field getField(PropertyDescriptor property) throws NoSuchFieldException {
        String propertyName = property.getName();
        Class<?> declaringClass = this.getDeclaringClass(property);
        return declaringClass.getDeclaredField(propertyName);
    }

    private Class<?> getDeclaringClass(PropertyDescriptor property) {
        Method method = null;
        if (property instanceof IndexedPropertyDescriptor) {
            method = ((IndexedPropertyDescriptor)property).getIndexedReadMethod();
            if (method == null) {
                method = ((IndexedPropertyDescriptor)property).getIndexedWriteMethod();
            }
        } else {
            method = property.getReadMethod();
            if (method == null) {
                method = property.getWriteMethod();
            }
        }
        return method.getDeclaringClass();
    }
}

