/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.commands;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.util.PageControl;
import org.rhq.enterprise.client.ClientMain;
import org.rhq.enterprise.client.Controller;
import org.rhq.enterprise.client.RemoteClient;
import org.rhq.enterprise.client.TabularWriter;
import org.rhq.enterprise.client.commands.ClientCommand;
import org.rhq.enterprise.client.export.Exporter;
import org.rhq.enterprise.client.proxy.ConfigurationEditor;
import org.rhq.enterprise.client.proxy.ResourceClientFactory;
import org.rhq.enterprise.client.script.CLIScriptException;
import org.rhq.enterprise.client.script.CmdLineParser;
import org.rhq.enterprise.client.script.CommandLineParseException;
import org.rhq.enterprise.client.script.NamedScriptArg;
import org.rhq.enterprise.client.script.ScriptArg;
import org.rhq.enterprise.client.script.ScriptCmdLine;
import org.rhq.enterprise.client.utility.PackageFinder;
import org.rhq.enterprise.client.utility.ScriptAssert;
import org.rhq.enterprise.client.utility.ScriptUtil;

public class ScriptCommand
implements ClientCommand {
    private ScriptEngineManager sem;
    private ScriptEngine jsEngine;
    private final Log log = LogFactory.getLog(ScriptCommand.class);
    private StringBuilder script = new StringBuilder();
    private boolean isMultilineScript = false;
    private boolean inMultilineScript = false;

    public ScriptCommand() {
        this.sem = new ScriptEngineManager();
        PageControl pc = new PageControl();
        pc.setPageNumber(-1);
        this.sem.getBindings().put("unlimitedPC", (Object)pc);
        this.sem.getBindings().put("pageControl", (Object)PageControl.getUnlimitedInstance());
        this.sem.put("exporter", new Exporter());
        this.jsEngine = this.sem.getEngineByName("JavaScript");
        try {
            this.jsEngine.eval("1+1");
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        this.importRecursive(this.jsEngine);
    }

    private void importRecursive(ScriptEngine jsEngine) {
        try {
            List<String> packages = new PackageFinder().findPackages("org.rhq.core.domain");
            for (String pkg : packages) {
                jsEngine.eval("importPackage(" + pkg + ")");
            }
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    public ScriptEngine getScriptEngine() {
        return this.jsEngine;
    }

    @Override
    public String getPromptCommandString() {
        return "exec";
    }

    @Override
    public boolean execute(ClientMain client, String[] args) {
        int i;
        this.initBindings(client);
        if (this.isScriptFileCommandLine(args)) {
            try {
                CmdLineParser cmdLineParser = new CmdLineParser();
                ScriptCmdLine scriptCmdLine = cmdLineParser.parse(args);
                this.bindScriptArgs(scriptCmdLine);
                this.executeUtilScripts();
                return this.executeScriptFile(new FileReader(scriptCmdLine.getScriptFileName()), client);
            }
            catch (FileNotFoundException e) {
                client.getPrintWriter().println(e.getMessage());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unable to locate script file: " + e.getMessage()));
                }
            }
            catch (CommandLineParseException e) {
                if (client.isInteractiveMode()) {
                    client.getPrintWriter().println("parse error: " + e.getMessage());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"A parse error occurred.", (Throwable)e);
                    }
                }
                throw new CLIScriptException(e);
            }
            return true;
        }
        this.isMultilineScript = "\\".equals(args[args.length - 1]);
        boolean bl = this.inMultilineScript = this.inMultilineScript || this.isMultilineScript;
        if (!this.isMultilineScript && !this.inMultilineScript) {
            this.script = new StringBuilder();
        }
        if (this.isMultilineScript) {
            args = Arrays.copyOfRange(args, 0, args.length - 1);
        }
        int n = i = "exec".equals(args[0]) ? 1 : 0;
        while (i < args.length) {
            this.script.append(args[i]);
            this.script.append(" ");
            ++i;
        }
        if (this.isMultilineScript) {
            return true;
        }
        try {
            Object result = this.jsEngine.eval(this.script.toString());
            this.inMultilineScript = false;
            this.script = new StringBuilder();
            if (result != null) {
                TabularWriter writer = new TabularWriter(client.getPrintWriter());
                if (client.isInteractiveMode()) {
                    writer.setWidth(client.getConsoleWidth());
                }
                writer.print(result);
            }
        }
        catch (ScriptException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            message = message.replace("sun.org.mozilla.javascript.internal.EcmaError: ", "");
            message = message.replace("(<Unknown source>#1) in <Unknown source> at line number 1", "");
            client.getPrintWriter().println(message);
            client.getPrintWriter().println(this.script);
            for (int i2 = 0; i2 < e.getColumnNumber(); ++i2) {
                client.getPrintWriter().print(" ");
            }
            client.getPrintWriter().println("^");
            this.script = new StringBuilder();
            this.inMultilineScript = false;
        }
        client.getPrintWriter().println();
        return true;
    }

    public void initBindings(ClientMain client) {
        if (client.getSubject() != null) {
            this.jsEngine.put("subject", client.getSubject());
            this.sem.getBindings().putAll(client.getRemoteClient().getManagers());
        }
        TabularWriter tw = new TabularWriter(client.getPrintWriter());
        tw.setWidth(client.getConsoleWidth());
        this.sem.getBindings().put("pretty", (Object)tw);
        this.sem.getBindings().put("ProxyFactory", (Object)new ResourceClientFactory(client));
        this.bindObjectAndGlobalFuctions(new Controller(client), "rhq");
        this.bindObjectAndGlobalFuctions(new ScriptUtil(client), "scriptUtil");
        this.bindObjectAndGlobalFuctions(new ConfigurationEditor(client), "configurationEditor");
        this.bindObjectAndGlobalFuctions(new ScriptAssert(this.jsEngine), "Assert");
    }

    private void bindObjectAndGlobalFuctions(Object object, String bindingName) {
        this.jsEngine.put(bindingName, object);
        try {
            MethodDescriptor[] methodDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
            for (MethodDescriptor methodDescriptor : methodDescriptors = beanInfo.getMethodDescriptors()) {
                Method method = methodDescriptor.getMethod();
                String methodName = method.getName();
                int argCount = method.getParameterTypes().length;
                StringBuilder functionBuilder = new StringBuilder();
                functionBuilder.append(methodName).append("(");
                for (int i = 0; i < argCount; ++i) {
                    if (i != 0) {
                        functionBuilder.append(", ");
                    }
                    functionBuilder.append("arg_" + i);
                }
                functionBuilder.append(")");
                String functionFragment = functionBuilder.toString();
                boolean returnsVoid = method.getReturnType().equals(Void.TYPE);
                String functionDefinition = "function " + functionFragment + " { " + (returnsVoid ? "" : "return ") + bindingName + "." + functionFragment + "; }";
                this.log.info((Object)("Binding global function --> " + functionDefinition));
                try {
                    this.jsEngine.eval(functionDefinition);
                }
                catch (ScriptException e) {
                    this.log.warn((Object)("Unable to bind global function " + functionFragment), (Throwable)e);
                }
            }
        }
        catch (IntrospectionException e) {
            this.log.warn((Object)("Could not bind " + object.getClass().getName() + " into script engine."));
        }
    }

    private void executeUtilScripts() {
        InputStream stream = this.getClass().getResourceAsStream("test_utils.js");
        InputStreamReader reader = new InputStreamReader(stream);
        try {
            this.jsEngine.eval(reader);
        }
        catch (ScriptException e) {
            this.log.warn((Object)"An error occurred while executing test_utils.js", (Throwable)e);
        }
    }

    private boolean isScriptFileCommandLine(String[] args) {
        if (args == null || args.length < 3) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-f")) continue;
            return true;
        }
        return false;
    }

    private void bindScriptArgs(ScriptCmdLine cmdLine) {
        this.bindArgsArray(cmdLine);
        if (cmdLine.getArgType() == ScriptCmdLine.ArgType.NAMED) {
            this.bindNamedArgs(cmdLine);
        }
        this.jsEngine.put("script", new File(cmdLine.getScriptFileName()).getName());
    }

    private void bindArgsArray(ScriptCmdLine cmdLine) {
        String[] args = new String[cmdLine.getArgs().size()];
        int i = 0;
        for (ScriptArg arg : cmdLine.getArgs()) {
            args[i++] = arg.getValue();
        }
        this.jsEngine.put("args", args);
    }

    private void bindNamedArgs(ScriptCmdLine cmdLine) {
        for (ScriptArg arg : cmdLine.getArgs()) {
            NamedScriptArg namedArg = (NamedScriptArg)arg;
            this.jsEngine.put(namedArg.getName(), namedArg.getValue());
        }
    }

    private boolean executeScriptFile(Reader reader, ClientMain client) {
        try {
            Object result = this.jsEngine.eval(reader);
            if (result != null && client.isInteractiveMode()) {
                new TabularWriter(client.getPrintWriter()).print(result);
            }
        }
        catch (ScriptException e) {
            if (client.isInteractiveMode()) {
                client.getPrintWriter().println(e.getMessage());
                client.getPrintWriter().println("^");
            }
            throw new CLIScriptException(e);
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "exec <statement> | [-s<indexed|named>] -f <file> [args]";
    }

    @Override
    public String getHelp() {
        return "Execute a statement or a script";
    }

    @Override
    public String getDetailedHelp() {
        return "Execute a statement or a script. The following services managers are available: " + RemoteClient.Manager.values();
    }

    public ScriptContext getContext() {
        return this.jsEngine.getContext();
    }
}

