/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.utility;

import java.util.Collection;
import javax.script.ScriptEngine;
import org.rhq.enterprise.client.utility.ScriptAssertionException;
import org.testng.Assert;

public class ScriptAssert {
    private ScriptEngine scriptEngine;

    public ScriptAssert(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void assertTrue(boolean condition, String msg) {
        try {
            Assert.assertTrue((boolean)condition, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertTrue(boolean condition) {
        try {
            Assert.assertTrue((boolean)condition);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertFalse(boolean condition, String msg) {
        try {
            Assert.assertFalse((boolean)condition, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertFalse(boolean condition) {
        try {
            Assert.assertFalse((boolean)condition);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void fail(String msg, Throwable throwable) {
        try {
            Assert.fail((String)msg, (Throwable)throwable);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void fail(String msg) {
        try {
            Assert.fail((String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void fail() {
        throw new ScriptAssertionException(new AssertionError());
    }

    public void assertEquals(Object actual, Object expected, String msg) {
        try {
            Assert.assertEquals((Object)actual, (Object)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(Object actual, Object expected) {
        try {
            Assert.assertEquals((Object)actual, (Object)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(String actual, String expected, String msg) {
        try {
            Assert.assertEquals((String)actual, (String)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(String actual, String expected) {
        try {
            Assert.assertEquals((String)actual, (String)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(double actual, double expected, double delta, String msg) {
        try {
            Assert.assertEquals((double)actual, (double)expected, (double)delta, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(double actual, double expected, double delta) {
        try {
            Assert.assertEquals((double)actual, (double)expected, (double)delta);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(float actual, float expected, float delta, String msg) {
        try {
            Assert.assertEquals((float)actual, (float)expected, (float)delta, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(float actual, float expected, float delta) {
        try {
            Assert.assertEquals((float)actual, (float)expected, (float)delta);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(long actual, long expected, String msg) {
        try {
            Assert.assertEquals((long)actual, (long)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(long actual, long expected) {
        try {
            Assert.assertEquals((long)actual, (long)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(boolean actual, boolean expected, String msg) {
        try {
            Assert.assertEquals((boolean)actual, (boolean)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(boolean actual, boolean expected) {
        try {
            Assert.assertEquals((boolean)actual, (boolean)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(byte actual, byte expected, String msg) {
        try {
            Assert.assertEquals((byte)actual, (byte)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(byte actual, byte expected) {
        try {
            Assert.assertEquals((byte)actual, (byte)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(char actual, char expected, String msg) {
        try {
            Assert.assertEquals((char)actual, (char)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(char actual, char expected) {
        try {
            Assert.assertEquals((char)actual, (char)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(short actual, short expected, String msg) {
        try {
            Assert.assertEquals((short)actual, (short)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(short actual, short expected) {
        try {
            Assert.assertEquals((short)actual, (short)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(int actual, int expected, String msg) {
        try {
            Assert.assertEquals((int)actual, (int)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(int actual, int expected) {
        try {
            Assert.assertEquals((int)actual, (int)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertNotNull(Object object) {
        try {
            Assert.assertNotNull((Object)object);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertNotNull(Object object, String msg) {
        try {
            Assert.assertNotNull((Object)object, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertNull(Object object) {
        try {
            Assert.assertNull((Object)object);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertNull(Object object, String msg) {
        try {
            Assert.assertNull((Object)object, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertSame(Object actual, Object expected, String msg) {
        try {
            Assert.assertSame((Object)actual, (Object)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertSame(Object actual, Object expected) {
        try {
            Assert.assertSame((Object)actual, (Object)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertNotSame(Object actual, Object expected, String msg) {
        try {
            Assert.assertNotSame((Object)actual, (Object)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertNotSame(Object actual, Object expected) {
        try {
            Assert.assertNotSame((Object)actual, (Object)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(Collection actual, Collection expected) {
        try {
            Assert.assertEquals((Collection)actual, (Collection)expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(Collection actual, Collection expected, String msg) {
        try {
            Assert.assertEquals((Collection)actual, (Collection)expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(Object[] actual, Object[] expected, String msg) {
        try {
            Assert.assertEquals((Object[])actual, (Object[])expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEqualsNoOrder(Object[] actual, Object[] expected, String msg) {
        try {
            Assert.assertEqualsNoOrder((Object[])actual, (Object[])expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(Object[] actual, Object[] expected) {
        try {
            Assert.assertEquals((Object[])actual, (Object[])expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEqualsNoOrder(Object[] actual, Object[] expected) {
        try {
            Assert.assertEqualsNoOrder((Object[])actual, (Object[])expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(byte[] actual, byte[] expected) {
        try {
            Assert.assertEquals((byte[])actual, (byte[])expected);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertEquals(byte[] actual, byte[] expected, String msg) {
        try {
            Assert.assertEquals((byte[])actual, (byte[])expected, (String)msg);
        }
        catch (AssertionError e) {
            throw new ScriptAssertionException(e);
        }
    }

    public void assertExists(String identifier) {
        this.assertNotNull(this.scriptEngine.get(identifier), identifier + " is not defined");
    }

    public void assertNumberEqualsJS(double actual, double expected, String msg) {
        this.assertEquals((Object)actual, (Object)expected, msg);
    }
}

