/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.clientapi;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.client.RhqManagers;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.clientapi.RemoteClientProxy;
import org.rhq.enterprise.communications.util.SecurityUtil;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerRemote;
import org.rhq.enterprise.server.alert.AlertManagerRemote;
import org.rhq.enterprise.server.auth.SubjectManagerRemote;
import org.rhq.enterprise.server.authz.RoleManagerRemote;
import org.rhq.enterprise.server.bundle.BundleManagerRemote;
import org.rhq.enterprise.server.configuration.ConfigurationManagerRemote;
import org.rhq.enterprise.server.content.ContentManagerRemote;
import org.rhq.enterprise.server.content.RepoManagerRemote;
import org.rhq.enterprise.server.discovery.DiscoveryBossRemote;
import org.rhq.enterprise.server.drift.DriftManagerRemote;
import org.rhq.enterprise.server.drift.DriftTemplateManagerRemote;
import org.rhq.enterprise.server.event.EventManagerRemote;
import org.rhq.enterprise.server.install.remote.RemoteInstallManagerRemote;
import org.rhq.enterprise.server.measurement.AvailabilityManagerRemote;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerRemote;
import org.rhq.enterprise.server.operation.OperationManagerRemote;
import org.rhq.enterprise.server.report.DataAccessManagerRemote;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerRemote;
import org.rhq.enterprise.server.resource.ResourceManagerRemote;
import org.rhq.enterprise.server.resource.ResourceTypeManagerRemote;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerRemote;
import org.rhq.enterprise.server.search.SavedSearchManagerRemote;
import org.rhq.enterprise.server.support.SupportManagerRemote;
import org.rhq.enterprise.server.sync.SynchronizationManagerRemote;
import org.rhq.enterprise.server.system.SystemManagerRemote;
import org.rhq.enterprise.server.tagging.TagManagerRemote;

public class RemoteClient
implements RhqFacade {
    private static final Log LOG = LogFactory.getLog(RemoteClient.class);
    public static final String NONSECURE_TRANSPORT = "servlet";
    public static final String SECURE_TRANSPORT = "sslservlet";
    private String transport;
    private final String host;
    private final int port;
    private boolean loggedIn;
    private boolean connected;
    private Map<String, Object> managers;
    private Subject subject;
    private Client remotingClient;
    private String subsystem = null;

    public RemoteClient(String host, int port) {
        this(null, host, port);
    }

    public RemoteClient(String transport, String host, int port) {
        this(transport, host, port, null);
    }

    public RemoteClient(String transport, String host, int port, String subsystem) {
        this.transport = transport != null ? transport : this.guessTransport(port);
        this.host = host;
        this.port = port;
        this.subsystem = subsystem;
    }

    public Subject login(String user, String password) throws Exception {
        this.logout();
        this.doConnect();
        this.subject = this.getSubjectManager().login(user, password);
        this.loggedIn = true;
        return this.subject;
    }

    public void logout() {
        try {
            if (this.loggedIn && this.subject != null) {
                this.getSubjectManager().logout(this.subject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doDisconnect();
        this.subject = null;
        this.loggedIn = false;
    }

    public void connect() throws Exception {
        if (this.loggedIn) {
            String name = null == this.subject ? "" : this.subject.getName();
            throw new IllegalStateException("User " + name + " must log out before connection can be established.");
        }
        this.doDisconnect();
        this.doConnect();
        this.connected = true;
    }

    public void disconnect() {
        if (this.loggedIn) {
            String name = null == this.subject ? "" : this.subject.getName();
            throw new IllegalStateException("User " + name + " is logged in. Call logout() instead of disconnect().");
        }
        this.doDisconnect();
        this.connected = false;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    protected String guessTransport(int port) {
        return String.valueOf(port).endsWith("443") ? SECURE_TRANSPORT : NONSECURE_TRANSPORT;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public AlertManagerRemote getAlertManager() {
        return (AlertManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.AlertManager);
    }

    public AlertDefinitionManagerRemote getAlertDefinitionManager() {
        return (AlertDefinitionManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.AlertDefinitionManager);
    }

    public AvailabilityManagerRemote getAvailabilityManager() {
        return (AvailabilityManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.AvailabilityManager);
    }

    public BundleManagerRemote getBundleManager() {
        return (BundleManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.BundleManager);
    }

    public CallTimeDataManagerRemote getCallTimeDataManager() {
        return (CallTimeDataManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.CallTimeDataManager);
    }

    public DriftManagerRemote getDriftManager() {
        return (DriftManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.DriftManager);
    }

    public DriftTemplateManagerRemote getDriftTemplateManager() {
        return (DriftTemplateManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.DriftTemplateManager);
    }

    public RepoManagerRemote getRepoManager() {
        return (RepoManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.RepoManager);
    }

    public ConfigurationManagerRemote getConfigurationManager() {
        return (ConfigurationManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.ConfigurationManager);
    }

    public ContentManagerRemote getContentManager() {
        return (ContentManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.ContentManager);
    }

    public DataAccessManagerRemote getDataAccessManager() {
        return (DataAccessManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.DataAccessManager);
    }

    public DiscoveryBossRemote getDiscoveryBoss() {
        return (DiscoveryBossRemote)RemoteClientProxy.getProcessor(this, RhqManagers.DiscoveryBoss);
    }

    public EventManagerRemote getEventManager() {
        return (EventManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.EventManager);
    }

    public MeasurementBaselineManagerRemote getMeasurementBaselineManager() {
        return (MeasurementBaselineManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.MeasurementBaselineManager);
    }

    public MeasurementDataManagerRemote getMeasurementDataManager() {
        return (MeasurementDataManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.MeasurementDataManager);
    }

    public MeasurementDefinitionManagerRemote getMeasurementDefinitionManager() {
        return (MeasurementDefinitionManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.MeasurementDefinitionManager);
    }

    public MeasurementScheduleManagerRemote getMeasurementScheduleManager() {
        return (MeasurementScheduleManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.MeasurementScheduleManager);
    }

    public OperationManagerRemote getOperationManager() {
        return (OperationManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.OperationManager);
    }

    public ResourceManagerRemote getResourceManager() {
        return (ResourceManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.ResourceManager);
    }

    public ResourceFactoryManagerRemote getResourceFactoryManager() {
        return (ResourceFactoryManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.ResourceFactoryManager);
    }

    public ResourceGroupManagerRemote getResourceGroupManager() {
        return (ResourceGroupManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.ResourceGroupManager);
    }

    public ResourceTypeManagerRemote getResourceTypeManager() {
        return (ResourceTypeManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.ResourceTypeManager);
    }

    public RoleManagerRemote getRoleManager() {
        return (RoleManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.RoleManager);
    }

    public SavedSearchManagerRemote getSavedSearchManager() {
        return (SavedSearchManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.SavedSearchManager);
    }

    public SubjectManagerRemote getSubjectManager() {
        return (SubjectManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.SubjectManager);
    }

    public SupportManagerRemote getSupportManager() {
        return (SupportManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.SupportManager);
    }

    public SystemManagerRemote getSystemManager() {
        return (SystemManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.SystemManager);
    }

    public RemoteInstallManagerRemote getRemoteInstallManager() {
        return (RemoteInstallManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.RemoteInstallManager);
    }

    public TagManagerRemote getTagManager() {
        return (TagManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.TagManager);
    }

    public SynchronizationManagerRemote getSynchronizationManager() {
        return (SynchronizationManagerRemote)RemoteClientProxy.getProcessor(this, RhqManagers.SynchronizationManager);
    }

    public Map<String, Object> getManagers() {
        if (this.managers == null) {
            this.managers = new HashMap<String, Object>();
            for (RhqManagers manager : RhqManagers.values()) {
                try {
                    Method m = this.getClass().getMethod("get" + manager.name(), new Class[0]);
                    if (!manager.enabled()) continue;
                    this.managers.put(manager.name(), m.invoke((Object)this, new Object[0]));
                }
                catch (Throwable e) {
                    LOG.error((Object)("Failed to load manager " + manager + " due to missing class."), e);
                }
            }
        }
        return this.managers;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "transport=" + this.transport + ", host=" + this.host + ", port=" + this.port + ", subsystem=" + this.subsystem + ", connected=" + this.connected + ", loggedIn=" + this.loggedIn + ", subject=" + this.subject + ']';
    }

    Client getRemotingClient() {
        return this.remotingClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisconnect() {
        try {
            if (this.remotingClient != null && this.remotingClient.isConnected()) {
                this.remotingClient.disconnect();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
        finally {
            this.remotingClient = null;
        }
    }

    private void doConnect() throws Exception {
        String locatorURI = this.transport + "://" + this.host + ":" + this.port + "/jboss-remoting-servlet-invoker/ServerInvokerServlet";
        InvokerLocator locator = new InvokerLocator(locatorURI);
        String subsystem = "REMOTEAPI";
        if (this.subsystem != null && this.subsystem.trim().equalsIgnoreCase("WSREMOTEAPI")) {
            subsystem = "WSREMOTEAPI";
        }
        Map<String, String> remotingConfig = this.buildRemotingConfig(locatorURI);
        this.remotingClient = new Client(locator, subsystem, remotingConfig);
        this.remotingClient.connect();
    }

    private Map<String, String> buildRemotingConfig(String locatorURI) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (SecurityUtil.isTransportSecure((String)locatorURI)) {
            this.setConfigProp(config, "org.jboss.remoting.keyStore", "data/keystore.dat");
            this.setConfigProp(config, "org.jboss.remoting.keyStoreAlgorithm", "SunX509");
            this.setConfigProp(config, "org.jboss.remoting.keyStoreType", "JKS");
            this.setConfigProp(config, "org.jboss.remoting.keyStorePassword", "password");
            this.setConfigProp(config, "org.jboss.remoting.keyPassword", "password");
            this.setConfigProp(config, "org.jboss.remoting.trustStore", null);
            this.setConfigProp(config, "org.jboss.remoting.trustStoreAlgorithm", null);
            this.setConfigProp(config, "org.jboss.remoting.trustStoreType", null);
            this.setConfigProp(config, "org.jboss.remoting.trustStorePassword", null);
            this.setConfigProp(config, "org.jboss.remoting.sslProtocol", null);
            this.setConfigProp(config, "org.jboss.remoting.keyAlias", "self");
            this.setConfigProp(config, "org.jboss.remoting.serverAuthMode", "false");
            config.put("org.jboss.remoting.socket.useClientMode", "true");
            SSLSocketBuilder dummy_sslbuilder = new SSLSocketBuilder();
            try {
                dummy_sslbuilder.setKeyStoreURL((String)config.get("org.jboss.remoting.keyStore"));
            }
            catch (Exception e) {
                SecurityUtil.createKeyStore((String)((String)config.get("org.jboss.remoting.keyStore")), (String)((String)config.get("org.jboss.remoting.keyAlias")), (String)"CN=RHQ, OU=RedHat, O=redhat.com, C=US", (String)((String)config.get("org.jboss.remoting.keyStorePassword")), (String)((String)config.get("org.jboss.remoting.keyPassword")), (String)"DSA", (int)36500);
                dummy_sslbuilder.setKeyStoreURL((String)config.get("org.jboss.remoting.keyStore"));
            }
            config.put("org.jboss.security.ignoreHttpsHost", "true");
        }
        return config;
    }

    private void setConfigProp(Map<String, String> configMap, String propName, String defaultValue) {
        String propValue = System.getProperty(propName, defaultValue);
        if (propValue != null) {
            configMap.put(propName, propValue);
        }
    }
}

