/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.SandboxedScriptEngine;
import org.rhq.bindings.StandardBindings;
import org.rhq.bindings.engine.JsEngineInitializer;
import org.rhq.bindings.engine.ScriptEngineInitializer;
import org.rhq.bindings.util.NoTopLevelIndirection;
import org.rhq.bindings.util.PackageFinder;

public class ScriptEngineFactory {
    private static final Log LOG = LogFactory.getLog(ScriptEngineFactory.class);
    private static final ScriptEngineInitializer[] KNOWN_ENGINES = new ScriptEngineInitializer[]{new JsEngineInitializer()};

    private ScriptEngineFactory() {
    }

    public static ScriptEngine getScriptEngine(String language, PackageFinder packageFinder, StandardBindings bindings) throws ScriptException, IOException {
        ScriptEngineInitializer initializer = ScriptEngineFactory.getInitializer(language);
        if (initializer == null) {
            return null;
        }
        ScriptEngine engine = initializer.instantiate(packageFinder.findPackages("org.rhq.core.domain"));
        if (bindings != null) {
            ScriptEngineFactory.injectStandardBindings(engine, bindings, true);
        }
        return engine;
    }

    public static ScriptEngine getSecuredScriptEngine(final String language, final PackageFinder packageFinder, final StandardBindings bindings, final PermissionCollection permissions) throws ScriptException, IOException {
        CodeSource src = new CodeSource(new URL("http://rhq-project.org/scripting"), (Certificate[])null);
        ProtectionDomain scriptDomain = new ProtectionDomain(src, permissions);
        AccessControlContext ctx = new AccessControlContext(new ProtectionDomain[]{scriptDomain});
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ScriptEngine>(){

                @Override
                public ScriptEngine run() throws Exception {
                    return new SandboxedScriptEngine(ScriptEngineFactory.getScriptEngine(language, packageFinder, bindings), permissions);
                }
            }, ctx);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof ScriptException) {
                throw (ScriptException)cause;
            }
            throw new ScriptException(e);
        }
    }

    public static void injectStandardBindings(ScriptEngine engine, StandardBindings bindings, boolean deleteExistingBindings) {
        bindings.preInject(engine);
        Bindings engineBindings = deleteExistingBindings ? engine.createBindings() : engine.getBindings(100);
        for (Map.Entry entry : bindings.entrySet()) {
            engineBindings.put((String)entry.getKey(), entry.getValue());
        }
        engine.setBindings(engineBindings, 100);
        bindings.postInject(engine);
    }

    public static void removeBindings(ScriptEngine engine, Set<String> keySet) {
        Bindings engineBindings = engine.getBindings(100);
        for (String key : keySet) {
            engineBindings.remove(key);
        }
        engine.setBindings(engineBindings, 100);
    }

    public static void bindIndirectionMethods(ScriptEngine scriptEngine, String bindingName) {
        Object object = scriptEngine.get(bindingName);
        if (object == null) {
            LOG.debug((Object)("The script engine doesn't contain a binding called '" + bindingName + "'. No indirection functions will be generated."));
            return;
        }
        ScriptEngineInitializer initializer = ScriptEngineFactory.getInitializer(scriptEngine.getFactory().getLanguageName());
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
            MethodDescriptor[] methodDescriptors = beanInfo.getMethodDescriptors();
            HashMap<String, HashSet<Method>> overloadsPerMethodName = new HashMap<String, HashSet<Method>>();
            for (MethodDescriptor methodDescriptor : methodDescriptors) {
                Method method = methodDescriptor.getMethod();
                if (!ScriptEngineFactory.shouldIndirect(method)) continue;
                HashSet<Method> overloads = (HashSet<Method>)overloadsPerMethodName.get(method.getName());
                if (overloads == null) {
                    overloads = new HashSet<Method>();
                    overloadsPerMethodName.put(method.getName(), overloads);
                }
                overloads.add(method);
            }
            for (Set overloads : overloadsPerMethodName.values()) {
                Set<String> methodDefs = initializer.generateIndirectionMethods(bindingName, overloads);
                for (String methodDef : methodDefs) {
                    try {
                        scriptEngine.eval(methodDef);
                    }
                    catch (ScriptException e) {
                        LOG.warn((Object)("Unable to define global function declared as:\n" + methodDef), (Throwable)e);
                    }
                }
            }
        }
        catch (IntrospectionException e) {
            LOG.debug((Object)("Could not inspect class " + object.getClass().getName() + ". No indirection methods for variable '" + bindingName + "' will be generated."), (Throwable)e);
        }
    }

    public static ScriptEngineInitializer getInitializer(String language) {
        for (ScriptEngineInitializer i : KNOWN_ENGINES) {
            if (!i.implementsLanguage(language)) continue;
            return i;
        }
        return null;
    }

    private static boolean shouldIndirect(Method method) {
        return method.getAnnotation(NoTopLevelIndirection.class) == null;
    }
}

