/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import java.text.DateFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.rhq.core.domain.measurement.calltime.CallTimeDataValue;
import org.rhq.enterprise.server.alert.engine.model.AbstractCacheElement;
import org.rhq.enterprise.server.alert.engine.model.AlertConditionOperator;
import org.rhq.enterprise.server.alert.engine.model.InvalidCacheElementException;

public class CallTimeDataCacheElement
extends AbstractCacheElement<CallTimeDataValue> {
    private static CallTimeDataValue dummy = new CallTimeDataValue();
    private Double compareValue = null;
    private CalltimeChangeOp comparator;
    private ConcurrentHashMap<String, CallTimeDataValue> previous = new ConcurrentHashMap();
    private Pattern callDestPattern = null;

    private String fixPattern(String regex) {
        boolean sw = regex.startsWith(".*");
        boolean ew = regex.endsWith(".*");
        return (!sw ? ".*" : "") + regex + (!ew ? ".*" : "");
    }

    public CallTimeDataCacheElement(AlertConditionOperator operator, CallTimeElementValue whichValue, String comparator, Double value, int conditionId, String callDestPattern) {
        super(operator, (Object)whichValue, dummy, conditionId);
        if (value == null) {
            throw new InvalidCacheElementException("Invalid Cache Element: condition with id=" + conditionId + " " + "and operator='" + operator.toString() + "' " + "requires a non-null value");
        }
        if (whichValue == null) {
            throw new InvalidCacheElementException("operator '" + operator.toString() + "'" + " requires an operator option; it can not be null");
        }
        this.compareValue = value;
        this.callDestPattern = callDestPattern != null ? Pattern.compile(this.fixPattern(callDestPattern)) : null;
        if (comparator != null) {
            this.comparator = CalltimeChangeOp.valueOf(comparator);
        }
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        if (operator == AlertConditionOperator.GREATER_THAN || operator == AlertConditionOperator.EQUALS || operator == AlertConditionOperator.LESS_THAN || operator == AlertConditionOperator.CHANGES) {
            return operator.getDefaultType();
        }
        return AlertConditionOperator.Type.NONE;
    }

    @Override
    public boolean matches(CallTimeDataValue providedValue, Object ... extras) {
        if (this.compareValue == null || this.compareValue.isNaN() || this.compareValue.isInfinite() || this.alertConditionOperatorOption == null) {
            return false;
        }
        Double provided = this.getCallTimeElementValue(providedValue);
        if (provided == null || provided.isInfinite() || provided.isNaN()) {
            return false;
        }
        String key = "";
        if (extras != null && extras[0] != null) {
            key = (String)extras[0];
        }
        if (this.callDestPattern != null && !this.callDestPattern.matcher(key).matches()) {
            return false;
        }
        switch (this.alertConditionOperator) {
            case EQUALS: {
                return this.compareValue.compareTo(provided) == 0;
            }
            case GREATER_THAN: {
                return this.compareValue.compareTo(provided) < 0;
            }
            case LESS_THAN: {
                return this.compareValue.compareTo(provided) > 0;
            }
            case CHANGES: {
                if (!this.previous.containsKey(key)) {
                    this.previous.put(key, providedValue);
                    return false;
                }
                CallTimeDataValue previousElem = this.previous.get(key);
                double compare = this.getCallTimeElementValue(previousElem);
                boolean result = this.computeChangeResult(provided, compare, this.comparator);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Changes at least " + this.compareValue + "% [" + result + "]; current:" + providedValue + "; previous:" + previousElem));
                }
                this.previous.put(key, providedValue);
                return result;
            }
        }
        return false;
    }

    private boolean computeChangeResult(Double provided, double compare, CalltimeChangeOp op) {
        switch (op) {
            case LO: {
                return provided < compare - this.compareValue * compare;
            }
            case CH: {
                return provided < compare - this.compareValue * compare || provided > compare + this.compareValue * compare;
            }
            case HI: {
                return provided > compare + this.compareValue * compare;
            }
        }
        return false;
    }

    private Double getCallTimeElementValue(CallTimeDataValue struct) {
        switch ((CallTimeElementValue)((Object)this.alertConditionOperatorOption)) {
            case MIN: {
                return struct.getMinimum();
            }
            case MAX: {
                return struct.getMaximum();
            }
            case AVG: {
                return struct.getTotal() / (double)struct.getCount();
            }
            case COUNT: {
                return struct.getCount();
            }
        }
        return null;
    }

    @Override
    public String convertValueToString(CallTimeDataValue value) {
        return "[From:" + DateFormat.getDateTimeInstance(2, 2).format(value.getBeginTime()) + ", To:" + DateFormat.getDateTimeInstance(2, 2).format(value.getEndTime()) + ", " + this.alertConditionOperatorOption + ":" + this.getCallTimeElementValue(value) + "]";
    }

    private static enum CalltimeChangeOp {
        LO,
        CH,
        HI;

    }

    public static enum CallTimeElementValue {
        MAX,
        MIN,
        AVG,
        COUNT;

    }
}

