/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth.prefs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.auth.prefs.SubjectPreferencesCache;

public abstract class SubjectPreferencesBase {
    protected final Log log = LogFactory.getLog(SubjectPreferencesBase.class);
    protected static final String PREF_LIST_DELIM = ",";
    protected static final String PREF_ITEM_DELIM = "|";
    protected static final String PREF_ITEM_DELIM_REGEX = "\\|";
    private int subjectId;
    private Set<String> changed;

    public SubjectPreferencesBase(Subject subject) {
        this.subjectId = subject.getId();
        this.changed = new HashSet<String>();
    }

    protected boolean getBooleanPref(String key) {
        String val = this.getPreference(key);
        return Boolean.valueOf(val);
    }

    protected boolean getBooleanPref(String key, boolean ifNull) {
        String val;
        try {
            val = this.getPreference(key);
        }
        catch (IllegalArgumentException e) {
            return ifNull;
        }
        return Boolean.valueOf(val);
    }

    protected int getIntPref(String key) {
        String val = this.getPreference(key);
        return Integer.parseInt(val);
    }

    protected int getIntPref(String key, int ifNull) {
        String val;
        try {
            val = this.getPreference(key);
            if ("".equals(val)) {
                return ifNull;
            }
        }
        catch (IllegalArgumentException e) {
            return ifNull;
        }
        return Integer.parseInt(val);
    }

    protected Long getLongPref(String key) {
        String val = this.getPreference(key);
        return Long.parseLong(val);
    }

    protected String getPreference(String key) throws IllegalArgumentException {
        PropertySimple prop = SubjectPreferencesCache.getInstance().getUserProperty(this.subjectId, key);
        if (prop == null) {
            if (this.subjectId == 0) {
                return "";
            }
            throw new IllegalArgumentException("preference '" + key + "' requested is not valid");
        }
        String value = prop.getStringValue();
        if (value != null) {
            value = value.trim();
        }
        this.log.trace((Object)("Getting " + key + "[" + value + "]"));
        return value;
    }

    public <T> T getPreference(String key, T defaultValue) {
        Object result;
        block7: {
            try {
                String preferenceValue = this.getPreference(key);
                Class type = String.class;
                if (defaultValue != null) {
                    type = defaultValue.getClass();
                }
                if (type == String.class) {
                    result = preferenceValue;
                    break block7;
                }
                if (type == Boolean.class) {
                    preferenceValue = preferenceValue.equalsIgnoreCase("on") || preferenceValue.equalsIgnoreCase("yes") || preferenceValue.equalsIgnoreCase("true") ? "true" : "false";
                }
                try {
                    Method m = type.getMethod("valueOf", String.class);
                    result = m.invoke(null, preferenceValue);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("No support for automatic conversion of preferences of type " + type);
                }
            }
            catch (IllegalArgumentException iae) {
                result = defaultValue;
            }
        }
        return result;
    }

    public List<String> getPreferenceAsList(String key) {
        return this.getPreferenceAsList(key, PREF_LIST_DELIM);
    }

    public List<String> getPreferenceAsList(String key, String delimiter) {
        String pref = null;
        try {
            pref = this.getPreference(key);
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)("A user preference named '" + key + "' does not exist."));
        }
        return pref != null ? StringUtil.explode((String)pref, (String)delimiter) : new ArrayList();
    }

    protected List<Integer> getPreferenceAsIntegerList(String key, String delimiter) {
        try {
            List<String> values = this.getPreferenceAsList(key, delimiter);
            ArrayList<Integer> result = new ArrayList<Integer>(values.size());
            for (String value : values) {
                String trimmed = value.trim();
                if (trimmed.length() <= 0) continue;
                result.add(Integer.valueOf(trimmed));
            }
            return result;
        }
        catch (Exception e) {
            return new ArrayList<Integer>();
        }
    }

    protected void setPreference(String key, List<?> values) throws IllegalArgumentException {
        this.setPreference(key, values, PREF_LIST_DELIM);
    }

    protected void setPreference(String key, List<?> values, String delim) throws IllegalArgumentException {
        String stringified = StringUtil.listToString(values, (String)delim);
        this.setPreference(key, stringified);
    }

    public void setPreference(String key, Object value) throws IllegalArgumentException {
        String val = value == null ? "" : (value instanceof String ? (String)value : value.toString());
        SubjectPreferencesCache.getInstance().setUserProperty(this.subjectId, key, val);
    }

    protected void unsetPreference(String key) {
        SubjectPreferencesCache.getInstance().unsetUserProperty(this.subjectId, key);
    }
}

