/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.plugin;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceCircularityException;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceController;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceException;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ProductPluginDeployer {
    private Log log = LogFactory.getLog((String)ProductPluginDeployer.class.getName());
    private File pluginDir = null;
    private boolean isStarted = false;
    private boolean isReady = false;
    private Map<String, DeploymentInfo> deploymentInfos = new HashMap<String, DeploymentInfo>();
    private Map<String, PluginDescriptor> pluginDescriptors = new HashMap<String, PluginDescriptor>();
    private Map<String, ComparableVersion> pluginVersions = new HashMap<String, ComparableVersion>();
    private Set<String> namesOfPluginsToBeRegistered = new HashSet<String>();

    public File getPluginDir() {
        return this.pluginDir;
    }

    public void setPluginDir(File pluginDir) {
        this.pluginDir = pluginDir;
        if (!this.pluginDir.exists()) {
            this.pluginDir.mkdirs();
        }
    }

    public void startDeployment() {
        this.registerPlugins();
        this.isReady = true;
    }

    public void start() throws Exception {
        if (!this.isStarted) {
            this.isStarted = true;
        }
    }

    public void stop() {
        if (this.isStarted) {
            this.deploymentInfos.clear();
            this.pluginDescriptors.clear();
            this.pluginVersions.clear();
            this.namesOfPluginsToBeRegistered.clear();
            this.isStarted = false;
            this.isReady = false;
        }
    }

    public void pluginDetected(DeploymentInfo deploymentInfo) throws Exception {
        if (!this.accepts(deploymentInfo)) {
            return;
        }
        String key = null;
        for (Map.Entry<String, DeploymentInfo> entry : this.deploymentInfos.entrySet()) {
            if (!entry.getValue().equals(deploymentInfo)) continue;
            key = entry.getKey();
            break;
        }
        if (key != null) {
            this.deploymentInfos.put(key, deploymentInfo);
        }
        String name = this.preprocessPlugin(deploymentInfo);
        if (this.isReady) {
            this.log.debug((Object)("Will hot deploy plugin [" + name + "] from [" + deploymentInfo.url + "]"));
        } else {
            this.log.debug((Object)("Not ready yet - will deploy plugin [" + name + "] from [" + deploymentInfo.url + "] later"));
        }
    }

    private boolean accepts(DeploymentInfo di) {
        String urlString = di.url.getFile();
        if (!urlString.endsWith(".jar")) {
            return false;
        }
        File deploymentDirectory = new File(urlString).getParentFile();
        if (deploymentDirectory.getName().equals(this.pluginDir.getName())) {
            this.log.debug((Object)("accepting agent plugin=" + urlString));
            return true;
        }
        return false;
    }

    public void registerPlugins() {
        if (!this.isReady) {
            return;
        }
        Iterator<String> it = this.namesOfPluginsToBeRegistered.iterator();
        while (it.hasNext()) {
            String pluginName = it.next();
            if (this.isNewOrUpdated(pluginName)) continue;
            this.log.debug((Object)("Plugin [" + pluginName + "] has not been updated."));
            it.remove();
        }
        if (this.namesOfPluginsToBeRegistered.isEmpty()) {
            this.log.debug((Object)"All agent plugins were already up to date in the database.");
            return;
        }
        HashSet<String> pluginsToBeRegistered = new HashSet<String>(this.namesOfPluginsToBeRegistered);
        this.log.info((Object)("Deploying [" + pluginsToBeRegistered.size() + "] new or updated agent plugins: " + pluginsToBeRegistered));
        PluginDependencyGraph dependencyGraph = this.buildDependencyGraph();
        StringBuilder errorBuffer = new StringBuilder();
        if (!dependencyGraph.isComplete(errorBuffer)) {
            this.log.error((Object)errorBuffer.toString());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)dependencyGraph.toString());
            }
            dependencyGraph = dependencyGraph.reduceGraph();
            pluginsToBeRegistered.retainAll(dependencyGraph.getPlugins());
        }
        if (pluginsToBeRegistered.size() > 0) {
            this.registerPlugins(dependencyGraph, pluginsToBeRegistered);
        }
        this.log.info((Object)("Plugin metadata updates are complete for [" + pluginsToBeRegistered.size() + "] plugins: " + pluginsToBeRegistered));
        this.namesOfPluginsToBeRegistered.removeAll(pluginsToBeRegistered);
        try {
            ResourceTypeManagerLocal typeManager = LookupUtil.getResourceTypeManager();
            typeManager.reloadResourceFacetsCache();
        }
        catch (Throwable t) {
            this.log.error((Object)"Could not load ResourceFacets cache", t);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        Subject superuser = LookupUtil.getSubjectManager().getOverlord();
        SystemManagerLocal systemManager = LookupUtil.getSystemManager();
        systemManager.vacuum(superuser, new String[]{"RHQ_MEASUREMENT_DEF", "RHQ_CONFIG_DEF", "RHQ_RESOURCE_TYPE", "RHQ_RESOURCE_TYPE_PARENTS", "RHQ_PLUGIN"});
    }

    private String preprocessPlugin(DeploymentInfo deploymentInfo) throws Exception {
        File pluginFile = new File(deploymentInfo.url.getFile());
        this.ensureDeploymentIsValid(pluginFile);
        PluginDescriptor descriptor = this.getPluginDescriptor(deploymentInfo);
        String pluginName = descriptor.getName();
        boolean initialDeploy = !this.deploymentInfos.containsKey(pluginName);
        ComparableVersion version = AgentPluginDescriptorUtil.getPluginVersion((File)pluginFile, (PluginDescriptor)descriptor);
        if (initialDeploy) {
            this.log.info((Object)("Discovered agent plugin [" + pluginName + "]"));
        } else {
            this.log.info((Object)("Rediscovered agent plugin [" + pluginName + "]"));
        }
        if (initialDeploy || this.isNewestVersion(pluginName, version)) {
            this.deploymentInfos.put(pluginName, deploymentInfo);
            this.pluginDescriptors.put(pluginName, descriptor);
            this.pluginVersions.put(pluginName, version);
            this.namesOfPluginsToBeRegistered.add(pluginName);
        }
        return pluginName;
    }

    private PluginDescriptor getPluginDescriptor(DeploymentInfo di) throws Exception {
        try {
            PluginDescriptor pluginDescriptor = AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)di.url);
            return pluginDescriptor;
        }
        catch (Exception e) {
            throw new Exception("Failed to parse descriptor found in plugin [" + di.url + "]", e);
        }
    }

    private boolean isNewestVersion(String pluginName, ComparableVersion version) {
        boolean newestVersion;
        ComparableVersion existingVersion = this.pluginVersions.get(pluginName);
        if (existingVersion != null) {
            boolean bl = newestVersion = version.compareTo((Object)existingVersion) >= 0;
            if (newestVersion) {
                this.log.info((Object)("Newer version of [" + pluginName + "] plugin found (version " + version + ") - older version (" + existingVersion + ") will be ignored."));
            }
        } else {
            newestVersion = false;
        }
        return newestVersion;
    }

    private boolean isNewOrUpdated(String pluginName) {
        Plugin plugin;
        DeploymentInfo deploymentInfo = this.deploymentInfos.get(pluginName);
        if (deploymentInfo == null) {
            throw new IllegalStateException("DeploymentInfo was not found for plugin [" + pluginName + " ] - it should have been initialized by preprocessPlugin().");
        }
        PluginManagerLocal pluginMgr = LookupUtil.getPluginManager();
        try {
            plugin = pluginMgr.getPlugin(pluginName);
        }
        catch (RuntimeException e) {
            this.log.debug((Object)("New plugin [" + pluginName + "] detected."));
            return true;
        }
        String md5 = null;
        try {
            md5 = MessageDigestGenerator.getDigestString((File)new File(deploymentInfo.url.toURI()));
        }
        catch (Exception e) {
            this.log.error((Object)("Error generating MD5 for plugin [" + pluginName + "]. Cause: " + e));
        }
        if (!plugin.getMd5().equals(md5)) {
            this.log.debug((Object)("Updated plugin [" + pluginName + "] detected."));
            return true;
        }
        return false;
    }

    private PluginDependencyGraph buildDependencyGraph() {
        PluginDependencyGraph dependencyGraph = new PluginDependencyGraph();
        for (String pluginName : this.deploymentInfos.keySet()) {
            PluginDescriptor descriptor = this.pluginDescriptors.get(pluginName);
            AgentPluginDescriptorUtil.addPluginToDependencyGraph((PluginDependencyGraph)dependencyGraph, (PluginDescriptor)descriptor);
        }
        return dependencyGraph;
    }

    private void registerPlugins(PluginDependencyGraph dependencyGraph, Set<String> pluginsToBeRegistered) {
        this.log.debug((Object)("Dependency graph deployment order: " + dependencyGraph.getDeploymentOrder()));
        HashMap<String, LatchedPluginDeploymentService> latchedDependencyMap = new HashMap<String, LatchedPluginDeploymentService>();
        for (String pluginName : pluginsToBeRegistered) {
            LatchedPluginDeploymentService service = this.getServiceIfExists(pluginName, latchedDependencyMap);
            for (String dependencyPluginName : dependencyGraph.getPluginDependencies(pluginName)) {
                LatchedPluginDeploymentService dependencyService = this.getServiceIfExists(dependencyPluginName, latchedDependencyMap);
                if (null != dependencyService) {
                    service.addDependency(dependencyService);
                    continue;
                }
                this.log.warn((Object)("Ignoring [" + pluginName + "] dependency on missing dependency plugin: " + dependencyPluginName));
            }
            List optionalDependents = dependencyGraph.getOptionalDependents(pluginName);
            for (String dependentPluginName : optionalDependents) {
                LatchedPluginDeploymentService dependentService = this.getServiceIfExists(dependentPluginName, latchedDependencyMap);
                if (null != dependentService) {
                    dependentService.setForceUpdate(true);
                    dependentService.addDependency(service);
                    continue;
                }
                this.log.warn((Object)("Ignoring [" + pluginName + "] dependent on missing dependent plugin: " + dependentPluginName));
            }
        }
        ArrayList<LatchedPluginDeploymentService> orderedLatchedServices = new ArrayList<LatchedPluginDeploymentService>();
        List pluginOrder = dependencyGraph.getDeploymentOrder();
        for (String nextPlugin : pluginOrder) {
            LatchedPluginDeploymentService nextService = (LatchedPluginDeploymentService)latchedDependencyMap.get(nextPlugin);
            if (nextService == null) continue;
            orderedLatchedServices.add(nextService);
        }
        long startDeployTime = System.currentTimeMillis();
        LatchedServiceController controller = new LatchedServiceController(orderedLatchedServices);
        try {
            controller.executeServices();
        }
        catch (LatchedServiceCircularityException lsce) {
            this.log.error((Object)lsce.getMessage());
        }
        long endDeployTime = System.currentTimeMillis();
        this.log.debug((Object)("Registered [" + pluginsToBeRegistered.size() + "] plugins in [" + (endDeployTime - startDeployTime) + "]ms"));
    }

    private LatchedPluginDeploymentService getServiceIfExists(String pluginName, Map<String, LatchedPluginDeploymentService> latchedServiceMap) {
        LatchedPluginDeploymentService result = latchedServiceMap.get(pluginName);
        if (result == null) {
            DeploymentInfo deploymentInfo = this.deploymentInfos.get(pluginName);
            PluginDescriptor descriptor = this.pluginDescriptors.get(pluginName);
            if (null != deploymentInfo && null != descriptor) {
                result = new LatchedPluginDeploymentService(pluginName, deploymentInfo, descriptor);
                latchedServiceMap.put(pluginName, result);
            }
        }
        return result;
    }

    private void registerPluginJar(PluginDescriptor pluginDescriptor, DeploymentInfo deploymentInfo, boolean forceUpdate) {
        if (pluginDescriptor == null) {
            this.log.error((Object)("Missing plugin descriptor; is [" + deploymentInfo.url + "] a valid plugin?"));
            return;
        }
        try {
            File localPluginFile = new File(deploymentInfo.url.toURI());
            String pluginName = pluginDescriptor.getName();
            String displayName = pluginDescriptor.getDisplayName();
            String pluginNameDisplayName = pluginName + " (" + displayName + ")";
            ComparableVersion comparableVersion = this.pluginVersions.get(pluginName);
            String version = comparableVersion != null ? comparableVersion.toString() : null;
            this.log.debug((Object)("Registering RHQ plugin " + pluginNameDisplayName + ", " + (version != null ? "version " + version : "undefined version") + "..."));
            this.checkVersionCompatibility(pluginDescriptor.getAmpsVersion());
            String filename = this.getPluginJarFilename(deploymentInfo);
            Plugin plugin = new Plugin(pluginName, filename);
            plugin.setDisplayName(displayName != null ? displayName : pluginName);
            plugin.setEnabled(true);
            plugin.setDescription(pluginDescriptor.getDescription());
            plugin.setAmpsVersion(this.getAmpsVersion(pluginDescriptor));
            long mtime = deploymentInfo.url.openConnection().getLastModified();
            plugin.setMtime(mtime);
            if (pluginDescriptor.getHelp() != null && !pluginDescriptor.getHelp().getContent().isEmpty()) {
                plugin.setHelp(String.valueOf(pluginDescriptor.getHelp().getContent().get(0)));
            }
            plugin.setVersion(version);
            plugin.setMD5(MessageDigestGenerator.getDigestString((File)localPluginFile));
            PluginManagerLocal pluginMgr = LookupUtil.getPluginManager();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            pluginMgr.registerPlugin(subjectManager.getOverlord(), plugin, pluginDescriptor, localPluginFile, forceUpdate);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to register RHQ plugin file [" + deploymentInfo.url + "]"), (Throwable)e);
        }
    }

    private String getAmpsVersion(PluginDescriptor pluginDescriptor) {
        ComparableVersion version2;
        if (pluginDescriptor.getAmpsVersion() == null) {
            return "2.0";
        }
        ComparableVersion version = new ComparableVersion(pluginDescriptor.getAmpsVersion());
        if (version.compareTo((Object)(version2 = new ComparableVersion("2.0"))) <= 0) {
            return "2.0";
        }
        return pluginDescriptor.getAmpsVersion();
    }

    private void checkVersionCompatibility(String version) throws RuntimeException {
    }

    private void ensureDeploymentIsValid(File pluginFile) throws Exception {
        int retries = 4;
        while (!this.isDeploymentValidZipFile(pluginFile)) {
            if (--retries <= 0) {
                throw new Exception("File [" + pluginFile + "] is not a valid jarfile - " + " it is either corrupted or file has not been fully written yet.");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDeploymentValidZipFile(File pluginFile) {
        boolean isValid;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(pluginFile);
            if (jarFile.size() <= 0) {
                throw new Exception("There are no entries in the plugin file");
            }
            JarEntry entry = jarFile.entries().nextElement();
            entry.getName();
            isValid = true;
        }
        catch (Exception e) {
            this.log.info((Object)("File [" + pluginFile + "] is not a valid jarfile - " + " the file may not have been fully written yet. Cause: " + e));
            isValid = false;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to close jar file [" + pluginFile + "]"));
                }
            }
        }
        return isValid;
    }

    private String getPluginJarFilename(DeploymentInfo di) {
        return new File(di.url.getPath()).getName();
    }

    static class DeploymentInfo {
        public final URL url;

        public DeploymentInfo(URL url) {
            if (url == null) {
                throw new IllegalArgumentException("url == null");
            }
            this.url = url;
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof DeploymentInfo)) {
                return false;
            }
            return this.url.equals(((DeploymentInfo)obj).url);
        }
    }

    class LatchedPluginDeploymentService
    extends LatchedServiceController.LatchedService {
        private final DeploymentInfo pluginDeploymentInfo;
        private final PluginDescriptor pluginDescriptor;
        private boolean forceUpdate;

        public LatchedPluginDeploymentService(String pluginName, DeploymentInfo di, PluginDescriptor descriptor) {
            super(pluginName);
            this.pluginDeploymentInfo = di;
            this.pluginDescriptor = descriptor;
            this.forceUpdate = false;
        }

        public void setForceUpdate(boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
        }

        @Override
        public void executeService() throws LatchedServiceException {
            try {
                ProductPluginDeployer.this.registerPluginJar(this.pluginDescriptor, this.pluginDeploymentInfo, this.forceUpdate);
            }
            catch (Throwable t) {
                throw new LatchedServiceException(t);
            }
        }
    }
}

