/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.install.remote;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.install.remote.AgentInstallInfo;
import org.rhq.core.domain.install.remote.AgentInstallStep;
import org.rhq.core.domain.install.remote.RemoteAccessInfo;
import org.rhq.enterprise.server.install.remote.SSHFileSend;
import org.rhq.enterprise.server.util.LookupUtil;

public class SSHInstallUtility {
    private static final String RHQ_AGENT_LATEST_VERSION_PROP = "rhq-agent.latest.version";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final long TIMEOUT = 30000L;
    private static final long POLL_TIMEOUT = 1000L;
    private Log log = LogFactory.getLog(SSHInstallUtility.class);
    private RemoteAccessInfo accessInfo;
    private Session session;
    private String agentFile;
    private String agentPath;
    private String agentVersion;

    public SSHInstallUtility(RemoteAccessInfo accessInfo) {
        this.accessInfo = accessInfo;
        try {
            File agentBinaryFile = LookupUtil.getAgentManager().getAgentUpdateBinaryFile();
            this.agentFile = agentBinaryFile.getName();
            this.agentPath = agentBinaryFile.getCanonicalPath();
            Properties props = LookupUtil.getAgentManager().getAgentUpdateVersionFileContent();
            this.agentVersion = props.getProperty(RHQ_AGENT_LATEST_VERSION_PROP);
        }
        catch (Exception e) {
            this.agentVersion = this.getClass().getPackage().getImplementationVersion();
            this.agentFile = "rhq-enterprise-agent-" + this.agentVersion + ".jar";
            this.agentPath = "/tmp/rhq-agent/" + this.agentFile;
            this.log.warn((Object)("Failed agent binary file lookup - using [" + this.agentPath + "]"), (Throwable)e);
        }
        if (!new File(this.agentPath).exists()) {
            throw new RuntimeException("Unable to find agent binary file for installation at [" + this.agentPath + "]");
        }
        this.connect();
    }

    public void connect() {
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(this.accessInfo.getUser(), this.accessInfo.getHost(), this.accessInfo.getPort());
            if (this.accessInfo.getPassword() != null) {
                this.session.setPassword(this.accessInfo.getPassword());
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.connect(30000);
        }
        catch (JSchException e) {
            throw new RuntimeException("Failed SSH connection", e);
        }
    }

    public void disconnect() {
        this.session.disconnect();
    }

    public boolean agentInstallCheck(String agentInstallPath) {
        String agentWrapperScript = this.buildAgentWrapperScriptPath(agentInstallPath);
        String value = this.executeCommand("if  [ -f '" + agentWrapperScript + "' ]; then echo \"exists\"; fi", "Agent Install Check");
        return value != null && value.trim().length() != 0;
    }

    public AgentInstallInfo installAgent(String parentPath) {
        String serverAddress = LookupUtil.getServerManager().getServer().getAddress();
        AgentInstallInfo info = new AgentInstallInfo(parentPath, this.accessInfo.getUser(), this.agentVersion, serverAddress, this.accessInfo.getHost());
        this.executeCommand("uname -a", "Machine uname", info);
        this.executeCommand("java -version", "Java Version Check", info);
        this.executeCommand("mkdir -p '" + parentPath + "'", "Create Agent Install Directory", info);
        this.log.info((Object)("Copying agent binary update distribution file to [" + this.accessInfo.getHost() + "]..."));
        long start = System.currentTimeMillis();
        boolean fileSent = SSHFileSend.sendFile(this.session, this.agentPath, parentPath);
        AgentInstallStep scpStep = new AgentInstallStep("ssh copy '" + this.agentPath + "' -> '" + parentPath + "'", "Remote copy the agent binary update distribution", 0, fileSent ? "Success" : "Failed", this.getTimeDiff(start));
        info.addStep(scpStep);
        this.log.info((Object)"Agent binary update distribution file copied");
        this.executeCommand("cd '" + parentPath + "'", "Change to install directory", info);
        this.executeCommand("java -jar '" + parentPath + "/" + this.agentFile + "' '--install=" + parentPath + "'", "Install Agent", info);
        this.log.info((Object)("Will start new agent @ [" + this.accessInfo.getHost() + "] pointing to server @ [" + serverAddress + "]"));
        String agentScript = parentPath + "/rhq-agent/bin/rhq-agent.sh";
        String startStringArgs = info.getConfigurationStartString();
        String envCmd1 = "RHQ_AGENT_IN_BACKGROUND='" + parentPath + "/rhq-agent/bin/rhq-agent.pid'";
        String envCmd2 = "export RHQ_AGENT_IN_BACKGROUND";
        String startCommand = envCmd1 + " ; " + envCmd2 + " ; nohup '" + agentScript + "' " + startStringArgs + " &";
        this.executeCommand(startCommand, "Start New Agent", info);
        return info;
    }

    public String startAgent(String agentInstallPath) {
        String agentWrapperScript = this.buildAgentWrapperScriptPath(agentInstallPath);
        return this.executeCommand("'" + agentWrapperScript + "' start", "Agent Start");
    }

    public String stopAgent(String agentInstallPath) {
        String agentWrapperScript = this.buildAgentWrapperScriptPath(agentInstallPath);
        return this.executeCommand("'" + agentWrapperScript + "' stop", "Agent Stop");
    }

    public String agentStatus(String agentInstallPath) {
        String agentWrapperScript = this.buildAgentWrapperScriptPath(agentInstallPath);
        if (!this.agentInstallCheck(agentInstallPath)) {
            return "Agent Not Installed";
        }
        return this.executeCommand("'" + agentWrapperScript + "' status", "Agent Status");
    }

    public String findAgentInstallPath(String parentPath) {
        if (parentPath == null || parentPath.trim().length() == 0) {
            String[] possiblePaths;
            for (String possiblePath : possiblePaths = new String[]{"/opt", "/usr/local", "/usr/share", "/rhq", "/home/" + this.accessInfo.getUser()}) {
                String path = this.findAgentInstallPath(possiblePath);
                if (path == null) continue;
                return path;
            }
            return null;
        }
        if (parentPath.endsWith("rhq-agent") || parentPath.endsWith("rhq-agent/")) {
            return parentPath;
        }
        String full = this.executeCommand("find '" + parentPath + "' -name rhq-agent -print", "Find Agent Install Path");
        if (full == null || full.trim().length() == 0) {
            return null;
        }
        String[] results = full.split("\n");
        String path = results[0];
        return path;
    }

    public String[] pathDiscovery(String parentPath) {
        String full = this.executeCommand("ls -1 '" + parentPath + "'", "Path Discovery");
        return full.split("\n");
    }

    private String buildAgentWrapperScriptPath(String agentInstallPath) {
        String foundAgentInstall = this.findAgentInstallPath(agentInstallPath);
        if (foundAgentInstall != null) {
            agentInstallPath = foundAgentInstall;
        }
        String agentWrapperScript = agentInstallPath + "/bin/rhq-agent-wrapper.sh";
        return agentWrapperScript;
    }

    private String executeCommand(String command, String description) {
        return this.executeCommand(command, description, new AgentInstallInfo());
    }

    private String executeCommand(String command, String description, AgentInstallInfo info) {
        this.log.info((Object)("Running SSH command [" + description + "]"));
        long start = System.currentTimeMillis();
        String result = null;
        try {
            result = this.executeCommand(command);
            info.addStep(new AgentInstallStep(command, description, 0, result, this.getTimeDiff(start)));
        }
        catch (ExecuteException e) {
            info.addStep(new AgentInstallStep(command, description, e.errorCode, e.getMessage(), this.getTimeDiff(start)));
        }
        this.log.info((Object)("Result of SSH command [" + description + "]: " + result));
        return result;
    }

    private String executeCommand(String command) {
        ChannelExec channel = null;
        int exitStatus = -1;
        InputStream is = null;
        InputStream es = null;
        try {
            channel = (ChannelExec)this.session.openChannel("exec");
            channel.setCommand(command);
            is = channel.getInputStream();
            es = channel.getErrStream();
            channel.connect(30000);
            String out = this.read(is, (Channel)channel);
            String err = this.read(es, (Channel)channel);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("SSH command output: " + out));
            }
            if (err.length() > 0) {
                exitStatus = channel.getExitStatus();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("SSH command error [" + exitStatus + "]: " + err));
                }
                if (exitStatus != 0) {
                    throw new ExecuteException(exitStatus, err);
                }
                if (out.length() == 0) {
                    String string = err;
                    return string;
                }
            } else {
                exitStatus = 0;
            }
            String string = out;
            return string;
        }
        catch (ExecuteException ee) {
            throw ee;
        }
        catch (Exception e) {
            throw new ExecuteException(exitStatus, e.toString());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
            if (es != null) {
                try {
                    es.close();
                }
                catch (Exception e) {}
            }
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to disconnect", (Throwable)e);
                }
            }
        }
    }

    private String read(InputStream is, Channel channel) throws IOException {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        long endTime = System.currentTimeMillis() + 30000L;
        while (System.currentTimeMillis() < endTime) {
            int count;
            while (is.available() > 0 && (count = is.read(buffer, 0, 4096)) >= 0) {
                bos.write(buffer, 0, count);
            }
            if (channel.isClosed()) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("SSH reading exit status=" + channel.getExitStatus()));
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        return bos.toString();
    }

    private long getTimeDiff(long start) {
        return System.currentTimeMillis() - start;
    }

    public static void main(String[] args) throws IOException {
        String pass = null;
        if (args.length > 2) {
            pass = args[2];
        }
        RemoteAccessInfo info = new RemoteAccessInfo(args[0], args[1], pass);
        SSHInstallUtility ssh = new SSHInstallUtility(info);
        String parentPath = "/tmp/new-remote-agent";
        String agentInstallPath = parentPath + "/rhq-agent";
        System.out.println("Agent status: " + ssh.agentStatus(agentInstallPath));
        System.out.println("Agent stop: " + ssh.stopAgent(agentInstallPath));
        System.out.println("Agent find: " + ssh.findAgentInstallPath(parentPath));
        System.out.println("Agent install: " + ssh.installAgent(parentPath));
        System.out.println("Agent find: " + ssh.findAgentInstallPath(parentPath));
        System.out.println("Agent status: " + ssh.agentStatus(agentInstallPath));
        System.out.println("Agent stop: " + ssh.stopAgent(agentInstallPath));
        System.out.println("Agent status: " + ssh.agentStatus(agentInstallPath));
        System.out.println("Agent start: " + ssh.startAgent(agentInstallPath));
        ssh.disconnect();
    }

    private static class ExecuteException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        int errorCode;

        public ExecuteException(int errorCode, String message) {
            super(message);
            this.errorCode = errorCode;
        }
    }
}

