/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.io.File;
import java.util.List;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.xmlschema.ScheduledJobDefinition;

public class ServerPluginContext {
    private final ServerPluginEnvironment pluginEnvironment;
    private final File temporaryDirectory;
    private final File dataDirectory;
    private final Configuration pluginConfiguration;
    private final List<ScheduledJobDefinition> schedules;

    public ServerPluginContext(ServerPluginEnvironment env, File dataDirectory, File tmpDirectory, Configuration pluginConfiguration, List<ScheduledJobDefinition> schedules) {
        this.pluginEnvironment = env;
        this.dataDirectory = dataDirectory;
        this.pluginConfiguration = pluginConfiguration;
        if (schedules != null && schedules.size() == 0) {
            schedules = null;
        }
        this.schedules = schedules;
        if (tmpDirectory == null) {
            this.temporaryDirectory = new File(System.getProperty("java.io.tmpdir"), "SERVERPLUGIN_TMP");
            this.temporaryDirectory.mkdirs();
        } else {
            this.temporaryDirectory = tmpDirectory;
        }
    }

    public ServerPluginEnvironment getPluginEnvironment() {
        return this.pluginEnvironment;
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public Configuration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public List<ScheduledJobDefinition> getSchedules() {
        return this.schedules;
    }
}

