/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.alert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderValidationResults;

public abstract class AlertSender<T extends ServerPluginComponent> {
    protected Configuration preferences;
    protected Configuration alertParameters;
    protected Configuration extraParameters;
    protected T pluginComponent;
    protected ServerPluginEnvironment serverPluginEnvironment;

    public abstract SenderResult send(Alert var1);

    public String previewConfiguration() {
        StringBuilder builder = new StringBuilder();
        ArrayList properties = new ArrayList(this.alertParameters.getProperties());
        Collections.sort(properties);
        boolean first = true;
        for (Property next : properties) {
            if (first) {
                first = false;
            } else {
                builder.append(" | ");
            }
            builder.append(next.getName());
            builder.append(": ");
            builder.append(this.printProperty(next));
        }
        return builder.toString();
    }

    public AlertSenderValidationResults validateAndFinalizeConfiguration(Subject subject) {
        return new AlertSenderValidationResults(this.alertParameters, this.extraParameters);
    }

    private String printProperty(Property property) {
        if (property instanceof PropertySimple) {
            return ((PropertySimple)property).getStringValue();
        }
        if (property instanceof PropertyMap) {
            Map map = ((PropertyMap)property).getMap();
            StringBuilder builder = new StringBuilder();
            for (Property next : map.values()) {
                builder.append(this.printProperty(next));
            }
            return builder.toString();
        }
        return "no preview available";
    }

    public static <T> List<T> unfence(String fencedData, Class<T> type) {
        return AlertSender.unfence(fencedData, type, "\\|");
    }

    public static <T> List<T> unfence(String fencedData, Class<T> type, String delimiter) {
        String[] elements = fencedData.split(delimiter);
        ArrayList<Object> results = new ArrayList<Object>(elements.length);
        if (Integer.class.equals(type)) {
            for (String next : elements) {
                if (next.length() == 0) continue;
                results.add(Integer.valueOf(next));
            }
        } else if (String.class.equals(type)) {
            for (String next : elements) {
                if (next.length() == 0) continue;
                results.add(next);
            }
        } else {
            throw new IllegalArgumentException("No support for unfencing data of type " + type);
        }
        return results;
    }

    public static String fence(List<?> elements) {
        if (elements.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('|');
        for (Object next : elements) {
            builder.append(String.valueOf(next)).append('|');
        }
        return builder.toString();
    }
}

