/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.criteria.SavedSearchCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.search.SavedSearch;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.search.SavedSearchManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SavedSearchResultCountRecalculationJob
extends AbstractStatefulJob {
    private static final Log LOG = LogFactory.getLog(SavedSearchResultCountRecalculationJob.class);
    private SavedSearchManagerLocal savedSearchManager = LookupUtil.getSavedSearchManager();
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private ResourceGroupManagerLocal resourceGroupManager = LookupUtil.getResourceGroupManager();
    private Subject overlord = LookupUtil.getSubjectManager().getOverlord();

    @Override
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        List<SavedSearch> staleSavedSearches = this.getSavedSearchesNeedingRecomputation();
        int errors = 0;
        int updated = 0;
        long totalMillis = 0L;
        for (SavedSearch next : staleSavedSearches) {
            if (next.isGlobal()) continue;
            try {
                ResourceCriteria criteria;
                PageList<Resource> results = null;
                if (next.getSearchSubsystem() == SearchSubsystem.RESOURCE) {
                    criteria = new ResourceCriteria();
                    criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
                    criteria.setSearchExpression(next.getPattern());
                    totalMillis -= System.currentTimeMillis();
                    results = this.resourceManager.findResourcesByCriteria(this.overlord, criteria);
                    totalMillis += System.currentTimeMillis();
                } else if (next.getSearchSubsystem() == SearchSubsystem.GROUP) {
                    criteria = new ResourceGroupCriteria();
                    criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
                    criteria.setSearchExpression(next.getPattern());
                    totalMillis -= System.currentTimeMillis();
                    results = this.resourceGroupManager.findResourceGroupsByCriteria(this.overlord, (ResourceGroupCriteria)criteria);
                    totalMillis += System.currentTimeMillis();
                }
                if (results == null || !this.processResults(next, results.getTotalSize())) continue;
                ++updated;
            }
            catch (Throwable t) {
                ++errors;
                LOG.error((Object)("Could not calculate result count for SavedSearch[name=" + next.getName() + ", pattern='" + next.getPattern() + "']: " + t.getMessage()));
                LOG.debug((Object)t);
            }
        }
        if (updated > 0) {
            LOG.debug((Object)("Statistics: updated " + updated + " in " + totalMillis + " ms (" + errors + " errors)"));
        }
    }

    private boolean processResults(SavedSearch next, long calculatedSize) {
        boolean countChanged = false;
        if (next.getResultCount() == null || calculatedSize != next.getResultCount()) {
            LOG.trace((Object)("Updated " + next + ", new result count is [" + calculatedSize + "]"));
            next.setResultCount(Long.valueOf(calculatedSize));
            countChanged = true;
        }
        next.setLastComputeTime(System.currentTimeMillis());
        this.savedSearchManager.updateSavedSearch(this.overlord, next);
        return countChanged;
    }

    private List<SavedSearch> getSavedSearchesNeedingRecomputation() {
        long fiveMinutesAgo = System.currentTimeMillis() - 300000L;
        SavedSearchCriteria criteria = new SavedSearchCriteria();
        criteria.addFilterLastComputeTimeMax(Long.valueOf(fiveMinutesAgo));
        criteria.addFilterGlobal(Boolean.valueOf(false));
        PageList<SavedSearch> results = this.savedSearchManager.findSavedSearchesByCriteria(this.overlord, criteria);
        if (LOG.isTraceEnabled()) {
            for (SavedSearch nextSavedSearch : results) {
                LOG.trace((Object)(nextSavedSearch + " needs recomputation"));
            }
        }
        return results;
    }
}

