/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;

public class CriteriaQueryRunner<T> {
    private static final Log LOG = LogFactory.getLog(CriteriaQueryRunner.class);
    private Criteria criteria;
    private CriteriaQueryGenerator queryGenerator;
    private EntityManager entityManager;
    private boolean automaticFetching;

    public CriteriaQueryRunner(Criteria criteria, CriteriaQueryGenerator queryGenerator, EntityManager entityManager) {
        this(criteria, queryGenerator, entityManager, true);
    }

    public CriteriaQueryRunner(Criteria criteria, CriteriaQueryGenerator queryGenerator, EntityManager entityManager, boolean automaticFetching) {
        this.criteria = criteria;
        this.queryGenerator = queryGenerator;
        this.entityManager = entityManager;
        this.automaticFetching = automaticFetching;
    }

    public PageList<T> execute() {
        PageList results = null;
        PageControl pageControl = CriteriaQueryGenerator.getPageControl(this.criteria);
        Criteria.Restriction criteriaRestriction = this.criteria.getRestriction();
        if (criteriaRestriction == null) {
            results = new PageList(this.getCollection(), this.getCount(), pageControl);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("restriction=" + criteriaRestriction + ", resultSize=" + results.size() + ", resultCount=" + results.getTotalSize()));
            }
        } else if (criteriaRestriction == Criteria.Restriction.COUNT_ONLY) {
            results = new PageList(this.getCount(), pageControl);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("restriction=" + criteriaRestriction + ", resultCount=" + results.getTotalSize()));
            }
        } else if (criteriaRestriction == Criteria.Restriction.COLLECTION_ONLY) {
            results = new PageList(this.getCollection(), pageControl);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("restriction=" + criteriaRestriction + ", resultSize=" + results.size()));
            }
        } else {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not support query execution for criteria with " + Criteria.Restriction.class.getSimpleName() + " " + criteriaRestriction);
        }
        return results;
    }

    private Collection<? extends T> getCollection() {
        Query query = this.queryGenerator.getQuery(this.entityManager);
        List results = query.getResultList();
        if (this.automaticFetching) {
            if (!this.queryGenerator.getPersistentBagFields().isEmpty()) {
                for (Object entity : results) {
                    this.initPersistentBags(entity);
                }
            }
            if (this.queryGenerator.isProjectionAltered() && !this.queryGenerator.getJoinFetchFields().isEmpty()) {
                for (Object entity : results) {
                    this.initJoinFetchFields(entity);
                }
            }
        }
        return results;
    }

    private int getCount() {
        Query countQuery = this.queryGenerator.getCountQuery(this.entityManager);
        long count = (Long)countQuery.getSingleResult();
        return (int)count;
    }

    public void initFetchFields(Object entity) {
        this.initPersistentBags(entity);
        if (this.queryGenerator.isProjectionAltered()) {
            this.initJoinFetchFields(entity);
        }
    }

    private void initPersistentBags(Object entity) {
        for (Field persistentBagField : this.queryGenerator.getPersistentBagFields()) {
            this.initialize(entity, persistentBagField);
        }
    }

    private void initJoinFetchFields(Object entity) {
        for (Field joinFetchField : this.queryGenerator.getJoinFetchFields()) {
            this.initialize(entity, joinFetchField);
        }
    }

    private void initialize(Object entity, Field field) {
        try {
            field.setAccessible(true);
            Hibernate.initialize((Object)field.get(entity));
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not initialize " + field));
        }
    }
}

