/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import mazz.i18n.Logger;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.RemoteIOException;
import org.rhq.enterprise.communications.command.impl.stream.RemoteInputStreamCommand;
import org.rhq.enterprise.communications.command.impl.stream.RemoteInputStreamCommandResponse;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class RemoteInputStream
extends InputStream
implements Serializable {
    private static final Logger LOG = CommI18NFactory.getLogger(RemoteInputStream.class);
    private static final long serialVersionUID = 1L;
    private static Method AVAILABLE;
    private static Method CLOSE;
    private static Method MARK;
    private static Method MARKSUPPORTED;
    private static Method READ;
    private static Method READBYTEARRAY;
    private static Method READBYTEARRAY_LEN;
    private static Method RESET;
    private static Method SKIP;
    private transient ClientCommandSender m_sender;
    private final Long m_streamId;
    private final String m_serverEndpoint;

    public RemoteInputStream(InputStream stream, ServiceContainer server) throws Exception {
        this(server.addRemoteInputStream(stream), server);
    }

    public RemoteInputStream(Long id, ServiceContainer server) {
        this.m_streamId = id;
        this.m_serverEndpoint = server.getServerEndpoint();
    }

    public String getServerEndpoint() {
        return this.m_serverEndpoint;
    }

    public void setClientCommandSender(ClientCommandSender sender) {
        this.m_sender = sender;
    }

    public String toString() {
        return "RemoteInputStream: stream-id=[" + this.m_streamId + "]; server-endpoint=[" + this.m_serverEndpoint + "]";
    }

    @Override
    public int available() throws IOException {
        return (Integer)this.sendRequest(AVAILABLE, null);
    }

    @Override
    public void close() throws IOException {
        this.sendRequest(CLOSE, null);
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.sendRequest(MARK, new Object[]{new Integer(readlimit)});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean markSupported() {
        try {
            return (Boolean)this.sendRequest(MARKSUPPORTED, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read() throws IOException {
        return (Integer)this.sendRequest(READ, null);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return (Integer)this.sendRequest(READBYTEARRAY, new Object[]{b});
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return (Integer)this.sendRequest(READBYTEARRAY_LEN, new Object[]{b, off, len});
    }

    @Override
    public void reset() throws IOException {
        this.sendRequest(RESET, null);
    }

    @Override
    public long skip(long n) throws IOException {
        return (Long)this.sendRequest(SKIP, new Object[]{n});
    }

    protected Object sendRequest(Method method, Object[] args) throws RemoteIOException {
        RemoteInputStreamCommandResponse response;
        if (this.m_sender == null) {
            throw new RemoteIOException(LOG.getMsgString("RemoteInputStream.remote-input-stream-missing-sender", new Object[]{this.m_streamId, this.m_serverEndpoint}));
        }
        RemoteInputStreamCommand cmd = new RemoteInputStreamCommand();
        cmd.setNameBasedInvocation(new NameBasedInvocation(method, args));
        cmd.setStreamId(this.m_streamId);
        try {
            response = new RemoteInputStreamCommandResponse(this.m_sender.sendSynch(cmd));
        }
        catch (Exception e) {
            throw new RemoteIOException(e);
        }
        if (!response.isSuccessful()) {
            throw new RemoteIOException(response.getException());
        }
        byte[] read_bytes = response.getBytesReadFromStream();
        if (read_bytes != null) {
            assert (args.length > 0 && args[0] instanceof byte[]);
            assert (read_bytes.length == ((byte[])args[0]).length);
            System.arraycopy(read_bytes, 0, args[0], 0, read_bytes.length);
        }
        return response.getResults();
    }

    static {
        try {
            AVAILABLE = InputStream.class.getMethod("available", new Class[0]);
            CLOSE = InputStream.class.getMethod("close", new Class[0]);
            MARK = InputStream.class.getMethod("mark", Integer.TYPE);
            MARKSUPPORTED = InputStream.class.getMethod("markSupported", new Class[0]);
            READ = InputStream.class.getMethod("read", new Class[0]);
            READBYTEARRAY = InputStream.class.getMethod("read", byte[].class);
            READBYTEARRAY_LEN = InputStream.class.getMethod("read", byte[].class, Integer.TYPE, Integer.TYPE);
            RESET = InputStream.class.getMethod("reset", new Class[0]);
            SKIP = InputStream.class.getMethod("skip", Long.TYPE);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "ClientRemoteInputStream.invalid-method-definition", new Object[0]);
        }
    }
}

