/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.rhq.core.util.stream.StreamUtil;

public abstract class ZipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFileOrDirectory(File fileOrDirToZip, File zipFile) throws IOException {
        if (fileOrDirToZip.isDirectory() && zipFile.getParentFile().getAbsolutePath().startsWith(fileOrDirToZip.getAbsolutePath())) {
            throw new IOException("Cannot write the zip file [" + zipFile.getAbsolutePath() + "] in or under the same directory being zipped [" + fileOrDirToZip.getAbsolutePath() + "]");
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            ZipUtil.zipFileOrDirectory(fileOrDirToZip, zos);
        }
        finally {
            if (zos != null) {
                zos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFileOrDirectory(File fileOrDirToZip, ZipOutputStream zos) throws IOException {
        if (fileOrDirToZip.isDirectory()) {
            File[] files;
            for (File f : files = fileOrDirToZip.listFiles()) {
                ZipUtil.zipFileOrDirectory(f, zos);
            }
        } else {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(fileOrDirToZip);
                ZipEntry zipEntry = new ZipEntry(fileOrDirToZip.getPath());
                zos.putNextEntry(zipEntry);
                StreamUtil.copy(fis, zos, false);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
    }

    public static void unzipFile(File zipFile, File destDir) throws IOException {
        destDir.mkdirs();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(zipFile));
        ZipUtil.unzipFile(is, destDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(InputStream zipContent, File outputDir) throws IOException {
        try {
            ZipEntry e;
            boolean directoryMade;
            if (outputDir.exists() && !outputDir.isDirectory()) {
                throw new RuntimeException("Output directory already exists, but is a file, not a directory. File: " + outputDir.getAbsolutePath());
            }
            if (!outputDir.exists() && !(directoryMade = outputDir.mkdirs())) {
                throw new RuntimeException("Could not create output directory for unzipped artifact: " + outputDir.getAbsolutePath());
            }
            ZipInputStream zis = new ZipInputStream(zipContent);
            while ((e = zis.getNextEntry()) != null) {
                String entryFileName = e.getName();
                File entryFile = new File(outputDir, entryFileName);
                if (e.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                String parentDirectory = entryFile.getParent();
                File parentDirectoryFile = new File(parentDirectory);
                parentDirectoryFile.mkdirs();
                FileOutputStream fos = new FileOutputStream(entryFile);
                try {
                    BufferedOutputStream outputStream = new BufferedOutputStream(fos);
                    try {
                        StreamUtil.copy(zis, outputStream, false);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fos.close();
                }
            }
        }
        finally {
            zipContent.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void walkZipFile(File zipFile, ZipEntryVisitor visitor) throws Exception {
        FileInputStream fis = new FileInputStream(zipFile);
        try {
            BufferedInputStream zipContent = new BufferedInputStream(fis);
            try {
                ZipEntry e;
                ZipInputStream zis = new ZipInputStream(zipContent);
                while ((e = zis.getNextEntry()) != null) {
                    boolean keepGoing = visitor.visit(e, zis);
                    if (keepGoing) continue;
                    break;
                }
            }
            finally {
                ((InputStream)zipContent).close();
            }
        }
        finally {
            fis.close();
        }
    }

    private ZipUtil() {
    }

    public static interface ZipEntryVisitor {
        public boolean visit(ZipEntry var1, ZipInputStream var2) throws Exception;
    }
}

