/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamCopyDigest;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.ChangesFileHashcodeMap;
import org.rhq.core.util.updater.DeployDifferences;
import org.rhq.core.util.updater.DeploymentData;
import org.rhq.core.util.updater.DeploymentDiskUsage;
import org.rhq.core.util.updater.DeploymentProperties;
import org.rhq.core.util.updater.DeploymentsMetadata;
import org.rhq.core.util.updater.ExtractorZipFileVisitor;
import org.rhq.core.util.updater.FileHashcodeMap;
import org.rhq.core.util.updater.InMemoryZipFileVisitor;

public class Deployer {
    private final Log log = LogFactory.getLog(Deployer.class);
    private final DeploymentData deploymentData;
    private final DeploymentsMetadata deploymentsMetadata;

    public Deployer(DeploymentData deploymentData) {
        if (deploymentData == null) {
            throw new IllegalArgumentException("deploymentData == null");
        }
        this.deploymentData = deploymentData;
        this.deploymentsMetadata = new DeploymentsMetadata(deploymentData.getDestinationDir());
    }

    public DeploymentData getDeploymentData() {
        return this.deploymentData;
    }

    public boolean isDestinationDirectoryManaged() {
        return this.deploymentsMetadata.isManaged();
    }

    public FileHashcodeMap deploy(DeployDifferences diff) throws Exception {
        return this.deploy(diff, false, false);
    }

    public FileHashcodeMap dryRun(DeployDifferences diff) throws Exception {
        return this.deploy(diff, false, true);
    }

    public FileHashcodeMap deploy(DeployDifferences diff, boolean clean, boolean dryRun) throws Exception {
        FileHashcodeMap map = null;
        this.checkDiskUsage();
        map = !this.deploymentsMetadata.isManaged() ? this.performInitialDeployment(diff, dryRun) : this.performUpdateDeployment(diff, clean, dryRun);
        return map;
    }

    public FileHashcodeMap redeployAndRestoreBackupFiles(DeployDifferences diff, boolean clean, boolean dryRun) throws Exception {
        FileHashcodeMap map = null;
        this.checkDiskUsage();
        if (!this.deploymentsMetadata.isManaged()) {
            map = this.performInitialDeployment(diff, dryRun);
        } else {
            int id = this.deploymentsMetadata.getCurrentDeploymentProperties().getDeploymentId();
            map = this.performUpdateDeployment(diff, clean, dryRun);
            this.restoreBackupFiles(id, map, diff, dryRun);
            if (!dryRun && !diff.getRestoredFiles().isEmpty()) {
                this.deploymentsMetadata.setCurrentDeployment(this.deploymentData.getDeploymentProps(), map, false);
            }
        }
        return map;
    }

    public DeploymentDiskUsage estimateDiskUsage() throws Exception {
        final DeploymentDiskUsage diskUsage = new DeploymentDiskUsage();
        File partition = this.deploymentData.getDestinationDir();
        long usableSpace = partition.getUsableSpace();
        while (usableSpace == 0L && partition != null) {
            if ((partition = partition.getParentFile()) == null) continue;
            usableSpace = partition.getUsableSpace();
        }
        diskUsage.setMaxDiskUsable(usableSpace);
        Set<File> zipFiles = this.deploymentData.getZipFiles();
        for (File zipFile : zipFiles) {
            ZipUtil.walkZipFile(zipFile, new ZipUtil.ZipEntryVisitor(){

                @Override
                public boolean visit(ZipEntry entry, ZipInputStream stream) throws Exception {
                    if (!entry.isDirectory()) {
                        long size = entry.getSize();
                        diskUsage.increaseDiskUsage(size > 0L ? size : 0L);
                        diskUsage.incrementFileCount();
                    }
                    return true;
                }
            });
        }
        Map<File, File> rawFiles = this.deploymentData.getRawFiles();
        for (File rawFile : rawFiles.keySet()) {
            diskUsage.increaseDiskUsage(rawFile.length());
            diskUsage.incrementFileCount();
        }
        return diskUsage;
    }

    public void checkDiskUsage() throws Exception {
        DeploymentDiskUsage usage;
        try {
            usage = this.estimateDiskUsage();
        }
        catch (Exception e) {
            this.debug("Cannot estimate disk usage - will assume there is enough space and will continue. Cause: ", e);
            return;
        }
        this.debug("Estimated disk usage for this deployment is [", usage.getDiskUsage(), "] bytes (file count=[", usage.getFileCount(), "]). The maximum disk space currently usable is estimated to be [", usage.getMaxDiskUsable(), "] bytes.");
        if (usage.getDiskUsage() > usage.getMaxDiskUsable()) {
            throw new Exception("There does not appear to be enough disk space for this deployment. Its estimated disk usage [" + usage.getDiskUsage() + "] is larger than the estimated amount of usable disk space [" + usage.getMaxDiskUsable() + "].");
        }
    }

    private FileHashcodeMap performInitialDeployment(DeployDifferences diff, boolean dryRun) throws Exception {
        if (this.deploymentData.isManageRootDir()) {
            File destDir = this.deploymentData.getDestinationDir();
            this.log.info((Object)this.buildLogMessage("Will be managing the deploy dir[", destDir, "]; backing up and purging any obsolete content existing in there"));
            if (destDir.isDirectory()) {
                int deploymentId = this.deploymentData.getDeploymentProps().getDeploymentId();
                this.backupFiles(diff, deploymentId, destDir, dryRun, null, true);
                if (!dryRun) {
                    File[] doomedFiles;
                    for (File doomedFile : doomedFiles = destDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return !".rhqdeployments".equals(name);
                        }
                    })) {
                        FileUtil.purge(doomedFile, true);
                    }
                }
            }
        }
        FileHashcodeMap newFileHashcodeMap = this.extractZipAndRawFiles(new HashMap<String, String>(0), diff, dryRun);
        if (diff != null) {
            diff.addAddedFiles(newFileHashcodeMap.keySet());
        }
        this.debug("Initial deployment finished. dryRun=", dryRun);
        return newFileHashcodeMap;
    }

    private FileHashcodeMap performUpdateDeployment(DeployDifferences diff, boolean clean, boolean dryRun) throws Exception {
        this.debug("Analyzing original, current and new files as part of update deployment. dryRun=", dryRun);
        FileHashcodeMap original = this.deploymentsMetadata.getCurrentDeploymentFileHashcodes();
        ChangesFileHashcodeMap current = original.rescan(this.deploymentData.getDestinationDir(), this.deploymentData.getIgnoreRegex(), this.deploymentData.isManageRootDir());
        FileHashcodeMap newFiles = this.getNewDeploymentFileHashcodeMap();
        if (current.getUnknownContent() != null) {
            throw new Exception("Failed to properly rescan the current deployment: " + current.getUnknownContent());
        }
        if (diff != null) {
            diff.addIgnoredFiles(current.getIgnored());
            for (Map.Entry entry : current.entrySet()) {
                String currentPath = (String)entry.getKey();
                String currentHashcode = (String)entry.getValue();
                if (currentHashcode.equals("?DELETED_FILE_HASHCODE?")) {
                    if (!newFiles.containsKey(currentPath)) continue;
                    diff.addAddedFile(currentPath);
                    continue;
                }
                if (!newFiles.containsKey(currentPath)) {
                    diff.addDeletedFile(currentPath);
                    continue;
                }
                if (newFiles.get(currentPath).equals(currentHashcode) || newFiles.get(currentPath).equals(original.get(currentPath))) continue;
                diff.addChangedFile(currentPath);
            }
            for (Map.Entry entry : newFiles.entrySet()) {
                if (current.containsKey(entry.getKey())) continue;
                diff.addAddedFile((String)entry.getKey());
            }
        }
        HashSet<String> currentFilesToBackup = new HashSet<String>(current.getAdditions().keySet());
        HashMap<String, String> currentFilesToLeaveAlone = new HashMap<String, String>();
        for (Map.Entry<String, String> changed : current.getChanges().entrySet()) {
            String changedFilePath = changed.getKey();
            String newHashcode = newFiles.get(changedFilePath);
            if (newHashcode != null) {
                String changedFileHashcode = changed.getValue();
                String originalFileHashcode = original.get(changedFilePath);
                if (newHashcode.equals(originalFileHashcode) && !clean) {
                    currentFilesToLeaveAlone.put(changedFilePath, originalFileHashcode);
                    continue;
                }
                if (newHashcode.equals(changedFileHashcode)) continue;
                currentFilesToBackup.add(changedFilePath);
                continue;
            }
            currentFilesToBackup.add(changedFilePath);
        }
        original = null;
        HashSet newNotFoundByRescan = new HashSet(newFiles.keySet());
        newNotFoundByRescan.removeAll(current.keySet());
        for (String newFileNotScanned : newNotFoundByRescan) {
            File newFileNotScannedFile = new File(newFileNotScanned);
            if (!newFileNotScannedFile.isAbsolute() || !newFileNotScannedFile.exists()) continue;
            currentFilesToBackup.add(newFileNotScanned);
            if (diff == null) continue;
            diff.removeAddedFile(newFileNotScanned);
            diff.addChangedFile(newFileNotScanned);
        }
        newNotFoundByRescan = null;
        Set currentFilesToDelete = current.keySet();
        currentFilesToDelete.removeAll(newFiles.keySet());
        currentFilesToDelete.removeAll(current.getDeletions().keySet());
        Set<String> skippedFiles = clean ? current.getSkipped() : null;
        current = null;
        if (!currentFilesToBackup.isEmpty()) {
            DeploymentProperties props = this.deploymentData.getDeploymentProps();
            int backupDeploymentId = props.getDeploymentId();
            this.debug("Backing up files as part of update deployment. dryRun=", dryRun);
            for (String fileToBackupPath : currentFilesToBackup) {
                boolean toBeDeleted = currentFilesToDelete.remove(fileToBackupPath);
                this.backupFile(diff, backupDeploymentId, fileToBackupPath, dryRun, toBeDeleted);
            }
        }
        if (!currentFilesToDelete.isEmpty()) {
            this.debug("Deleting obsolete files as part of update deployment. dryRun=", dryRun);
            for (String fileToDeletePath : currentFilesToDelete) {
                boolean deleted;
                File doomedFile = new File(fileToDeletePath);
                if (!doomedFile.isAbsolute()) {
                    doomedFile = new File(this.deploymentData.getDestinationDir(), fileToDeletePath);
                }
                if (deleted = !dryRun ? doomedFile.delete() : true) {
                    this.debug("Deleted obsolete file [", doomedFile, "]. dryRun=", dryRun);
                    continue;
                }
                this.debug("Failed to delete obsolete file [", doomedFile, "]");
                if (diff == null) continue;
                diff.addError(fileToDeletePath, "File [" + doomedFile.getAbsolutePath() + "] did not delete");
            }
        }
        if (clean) {
            this.debug("Cleaning the existing deployment's files found in the destination directory. dryRun=", dryRun);
            if (!dryRun) {
                this.purgeFileOrDirectory(this.deploymentData.getDestinationDir(), skippedFiles, 0, false);
            }
        }
        diff.setCleaned(clean);
        this.debug("Copying new files as part of update deployment. dryRun=", dryRun);
        FileHashcodeMap newFileHashCodeMap = this.extractZipAndRawFiles(currentFilesToLeaveAlone, diff, dryRun);
        this.debug("Update deployment finished. dryRun=", dryRun);
        return newFileHashCodeMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void backupFile(DeployDifferences diff, int deploymentId, String fileToBackupPath, boolean dryRun, boolean removeFileToBackup) throws Exception {
        File bakFile;
        File backupDir;
        File fileToBackup;
        boolean isWindows = File.separatorChar == '\\';
        StringBuilder fileToBackupPathNoDriveLetter = null;
        String driveLetter = null;
        if (isWindows) {
            fileToBackupPathNoDriveLetter = new StringBuilder(fileToBackupPath);
            driveLetter = FileUtil.stripDriveLetter(fileToBackupPathNoDriveLetter);
        }
        if ((fileToBackup = new File(fileToBackupPath)).isAbsolute()) {
            backupDir = this.deploymentsMetadata.getDeploymentExternalBackupDirectory(deploymentId);
            if (isWindows && driveLetter != null) {
                String dirName = this.deploymentsMetadata.getExternalBackupDirectoryNameForWindows(driveLetter);
                backupDir = new File(backupDir, dirName);
                bakFile = new File(backupDir, fileToBackupPathNoDriveLetter.toString());
            } else {
                bakFile = new File(backupDir, fileToBackupPath);
            }
        } else {
            backupDir = this.deploymentsMetadata.getDeploymentBackupDirectory(deploymentId);
            if (isWindows && driveLetter != null) {
                StringBuilder destDirAbsPathBuilder = new StringBuilder(this.deploymentData.getDestinationDir().getAbsolutePath());
                String destDirDriveLetter = FileUtil.stripDriveLetter(destDirAbsPathBuilder);
                if (destDirDriveLetter != null && !driveLetter.equals(destDirDriveLetter)) throw new Exception("Cannot backup relative path [" + fileToBackupPath + "] whose drive letter is different than the destination directory [" + this.deploymentData.getDestinationDir().getAbsolutePath() + "]");
                bakFile = new File(backupDir, fileToBackupPath);
                fileToBackup = new File(this.deploymentData.getDestinationDir(), fileToBackupPathNoDriveLetter.toString());
            } else {
                bakFile = new File(backupDir, fileToBackupPath);
                fileToBackup = new File(this.deploymentData.getDestinationDir(), fileToBackupPath);
            }
        }
        boolean deleted = false;
        if (!dryRun) {
            bakFile.getParentFile().mkdirs();
            if (removeFileToBackup) {
                boolean movedSuccessfully = fileToBackup.renameTo(bakFile);
                if (movedSuccessfully) {
                    deleted = true;
                } else {
                    FileUtil.copyFile(fileToBackup, bakFile);
                    deleted = fileToBackup.delete();
                    if (!deleted) {
                        this.debug("Failed to delete file [", fileToBackup, "] but it is backed up");
                        if (diff != null) {
                            diff.addError(fileToBackupPath, "File [" + fileToBackup.getAbsolutePath() + "] did not delete");
                        }
                    }
                }
            } else {
                FileUtil.copyFile(fileToBackup, bakFile);
            }
        } else {
            deleted = removeFileToBackup;
        }
        this.debug("Backed up file [", fileToBackup, "] to [", bakFile, "]. dryRun=", dryRun);
        if (deleted) {
            this.debug("Deleted file [", fileToBackup, "] after backing it up. dryRun=", dryRun);
        }
        if (diff == null) return;
        diff.addBackedUpFile(fileToBackupPath, bakFile.getAbsolutePath());
        if (!deleted) return;
        diff.addDeletedFile(fileToBackupPath);
    }

    private void backupFiles(DeployDifferences diff, int deploymentId, File dirToBackup, boolean dryRun, String relativeTo, boolean removeSourceFiles) throws Exception {
        File[] files = dirToBackup.listFiles();
        if (files == null) {
            throw new IOException("Failed to get the list of files in source directory [" + dirToBackup + "]");
        }
        if (files.length > 0) {
            this.deploymentsMetadata.getMetadataDirectory().mkdirs();
            for (File file : files) {
                if (file.isDirectory()) {
                    if (file.getName().equals(".rhqdeployments")) continue;
                    this.backupFiles(diff, deploymentId, file, dryRun, (relativeTo == null ? "" : relativeTo) + file.getName() + File.separatorChar, removeSourceFiles);
                    continue;
                }
                this.backupFile(diff, deploymentId, (relativeTo == null ? "" : relativeTo) + file.getName(), dryRun, removeSourceFiles);
            }
            files = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileHashcodeMap extractZipAndRawFiles(Map<String, String> currentFilesToLeaveAlone, DeployDifferences diff, boolean dryRun) throws Exception {
        FileHashcodeMap newFileHashCodeMap = new FileHashcodeMap();
        String sourceDirAbsPath = this.deploymentData.getSourceDir().getAbsolutePath();
        int sourceDirLength = sourceDirAbsPath.length();
        for (File zipFile : this.deploymentData.getZipFiles()) {
            String compressedFileHashcode;
            ExtractorZipFileVisitor visitor;
            Boolean exploded = this.deploymentData.getZipsExploded().get(zipFile);
            if (exploded == null) {
                exploded = Boolean.TRUE;
            }
            this.debug("Extracting zip [", zipFile, "] entries. exploded=", exploded, ", dryRun=", dryRun);
            Pattern realizeRegex = null;
            if (this.deploymentData.getZipEntriesToRealizeRegex() != null) {
                realizeRegex = this.deploymentData.getZipEntriesToRealizeRegex().get(zipFile);
            }
            if (exploded.booleanValue()) {
                visitor = new ExtractorZipFileVisitor(this.deploymentData.getDestinationDir(), realizeRegex, this.deploymentData.getTemplateEngine(), currentFilesToLeaveAlone.keySet(), diff, dryRun);
                ZipUtil.walkZipFile(zipFile, visitor);
                newFileHashCodeMap.putAll(visitor.getFileHashcodeMap());
                continue;
            }
            String zipRelativePath = zipFile.getAbsolutePath().substring(sourceDirLength);
            if (zipRelativePath.startsWith("/") || zipRelativePath.startsWith("\\")) {
                zipRelativePath = zipRelativePath.substring(1);
            }
            File compressedFile = new File(this.deploymentData.getDestinationDir(), zipRelativePath);
            if (this.deploymentData.getTemplateEngine() != null && realizeRegex != null) {
                visitor = new ExtractorZipFileVisitor(this.deploymentData.getDestinationDir(), realizeRegex, this.deploymentData.getTemplateEngine(), currentFilesToLeaveAlone.keySet(), diff, dryRun);
                ZipUtil.walkZipFile(zipFile, visitor);
                if (!dryRun) {
                    this.createZipFile(compressedFile, this.deploymentData.getDestinationDir(), visitor.getFileHashcodeMap());
                }
            }
            MessageDigestGenerator hashcodeGenerator = new MessageDigestGenerator();
            if (!dryRun) {
                if (!compressedFile.exists()) {
                    if (compressedFile.getParentFile() != null) {
                        compressedFile.getParentFile().mkdirs();
                    }
                    FileUtil.copyFile(zipFile, compressedFile);
                }
                compressedFileHashcode = hashcodeGenerator.calcDigestString(compressedFile);
            } else {
                compressedFileHashcode = hashcodeGenerator.calcDigestString(zipFile);
            }
            newFileHashCodeMap.put(zipRelativePath, compressedFileHashcode);
        }
        StreamCopyDigest copyDigester = new StreamCopyDigest();
        for (Map.Entry<File, File> rawFile : this.deploymentData.getRawFiles().entrySet()) {
            String hashcode;
            String newLocationPath;
            File newLocationFile;
            block33: {
                FileInputStream in;
                File currentLocationFile = rawFile.getKey();
                newLocationFile = rawFile.getValue();
                newLocationPath = rawFile.getValue().getPath();
                newLocationPath = newFileHashCodeMap.convertPath(newLocationPath);
                if (currentFilesToLeaveAlone != null && currentFilesToLeaveAlone.containsKey(newLocationPath)) continue;
                if (!newLocationFile.isAbsolute()) {
                    newLocationFile = new File(this.deploymentData.getDestinationDir(), newLocationFile.getPath());
                }
                if (!dryRun) {
                    File newLocationParentDir = newLocationFile.getParentFile();
                    newLocationParentDir.mkdirs();
                    if (!newLocationParentDir.isDirectory()) {
                        throw new Exception("Failed to create new parent directory for raw file [" + newLocationFile + "]");
                    }
                }
                boolean realize = false;
                if (this.deploymentData.getRawFilesToRealize() != null) {
                    realize = this.deploymentData.getRawFilesToRealize().contains(currentLocationFile);
                }
                if (realize) {
                    this.debug("Realizing file [", currentLocationFile, "] to [", newLocationFile, "]. dryRun=", dryRun);
                    in = new FileInputStream(currentLocationFile);
                    byte[] rawFileContent = StreamUtil.slurp(in);
                    String content = this.deploymentData.getTemplateEngine().replaceTokens(new String(rawFileContent));
                    if (diff != null) {
                        diff.addRealizedFile(newLocationPath, content);
                    }
                    byte[] bytes = content.getBytes();
                    if (!dryRun) {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newLocationFile));
                        try {
                            out.write(bytes);
                        }
                        finally {
                            out.close();
                        }
                    }
                    MessageDigestGenerator hashcodeGenerator = copyDigester.getMessageDigestGenerator();
                    hashcodeGenerator.add(bytes);
                    hashcode = hashcodeGenerator.getDigestString();
                } else {
                    this.debug("Copying raw file [", currentLocationFile, "] to [", newLocationFile, "]. dryRun=", dryRun);
                    in = new FileInputStream(currentLocationFile);
                    try {
                        if (!dryRun) {
                            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newLocationFile));
                            try {
                                hashcode = copyDigester.copyAndCalculateHashcode(in, out);
                                break block33;
                            }
                            finally {
                                out.close();
                            }
                        }
                        hashcode = MessageDigestGenerator.getDigestString(in);
                    }
                    finally {
                        in.close();
                    }
                }
            }
            if (rawFile.getValue().isAbsolute()) {
                newFileHashCodeMap.put(newLocationFile.getAbsolutePath(), hashcode);
                continue;
            }
            newFileHashCodeMap.put(newLocationPath, hashcode);
        }
        newFileHashCodeMap.putAll(currentFilesToLeaveAlone);
        if (!dryRun) {
            this.deploymentsMetadata.setCurrentDeployment(this.deploymentData.getDeploymentProps(), newFileHashCodeMap, true);
        }
        return newFileHashCodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipFile(File zipFile, File rootDir, FileHashcodeMap fileHashcodeMap) throws Exception {
        if (zipFile.getParentFile() != null) {
            zipFile.getParentFile().mkdirs();
        }
        HashSet<File> childrenOfRootToDelete = new HashSet<File>();
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            for (String relativeFileToZip : fileHashcodeMap.keySet()) {
                File fileToZip = new File(rootDir, relativeFileToZip);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(fileToZip);
                    ZipEntry zipEntry = new ZipEntry(relativeFileToZip);
                    zos.putNextEntry(zipEntry);
                    StreamUtil.copy(fis, zos, false);
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                    File childOfRoot = fileToZip;
                    while (childOfRoot != null) {
                        File parent = childOfRoot.getParentFile();
                        if (parent.equals(rootDir)) {
                            childrenOfRootToDelete.add(childOfRoot);
                            break;
                        }
                        childOfRoot = parent;
                    }
                }
            }
        }
        finally {
            if (zos != null) {
                zos.close();
            }
        }
        for (File childOfRootToDelete : childrenOfRootToDelete) {
            FileUtil.purge(childOfRootToDelete, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileHashcodeMap getNewDeploymentFileHashcodeMap() throws Exception {
        FileHashcodeMap fileHashcodeMap = new FileHashcodeMap();
        for (File zipFile : this.deploymentData.getZipFiles()) {
            this.debug("Extracting zip [", zipFile, "] in-memory to determine hashcodes for all entries");
            Pattern realizeRegex = null;
            if (this.deploymentData.getZipEntriesToRealizeRegex() != null) {
                realizeRegex = this.deploymentData.getZipEntriesToRealizeRegex().get(zipFile);
            }
            InMemoryZipFileVisitor visitor = new InMemoryZipFileVisitor(realizeRegex, this.deploymentData.getTemplateEngine());
            ZipUtil.walkZipFile(zipFile, visitor);
            fileHashcodeMap.putAll(visitor.getFileHashcodeMap());
        }
        MessageDigestGenerator generator = new MessageDigestGenerator();
        for (Map.Entry<File, File> rawFile : this.deploymentData.getRawFiles().entrySet()) {
            String hashcode;
            InputStream in;
            File currentLocationFile = rawFile.getKey();
            File newLocationFile = rawFile.getValue();
            String newLocationPath = rawFile.getValue().getPath();
            if (!newLocationFile.isAbsolute()) {
                newLocationFile = new File(this.deploymentData.getDestinationDir(), newLocationFile.getPath());
            }
            boolean realize = false;
            if (this.deploymentData.getRawFilesToRealize() != null) {
                realize = this.deploymentData.getRawFilesToRealize().contains(currentLocationFile);
            }
            if (realize) {
                this.debug("Realizing file [", currentLocationFile, "] in-memory to determine its hashcode");
                in = new FileInputStream(currentLocationFile);
                byte[] rawFileContent = StreamUtil.slurp(in);
                String content = this.deploymentData.getTemplateEngine().replaceTokens(new String(rawFileContent));
                generator.add(content.getBytes());
                hashcode = generator.getDigestString();
            } else {
                this.debug("Streaming file [", currentLocationFile, "] in-memory to determine its hashcode");
                in = new BufferedInputStream(new FileInputStream(currentLocationFile));
                try {
                    hashcode = generator.calcDigestString(in);
                }
                finally {
                    ((BufferedInputStream)in).close();
                }
            }
            if (rawFile.getValue().isAbsolute()) {
                fileHashcodeMap.put(newLocationFile.getAbsolutePath(), hashcode);
                continue;
            }
            fileHashcodeMap.put(newLocationPath, hashcode);
        }
        return fileHashcodeMap;
    }

    private void restoreBackupFiles(int prevDeploymentId, FileHashcodeMap map, DeployDifferences diff, boolean dryRun) throws Exception {
        File backupDir = this.deploymentsMetadata.getDeploymentBackupDirectory(prevDeploymentId);
        String backupDirBase = backupDir.getAbsolutePath();
        if (!backupDirBase.endsWith(File.separator)) {
            backupDirBase = backupDirBase + File.separator;
        }
        File destDir = this.deploymentData.getDestinationDir();
        this.restoreBackupFilesRecursive(backupDir, backupDirBase, destDir, map, diff, dryRun);
        Map<String, File> extBackupDirs = this.deploymentsMetadata.getDeploymentExternalBackupDirectoriesForWindows(prevDeploymentId);
        if (extBackupDirs == null) {
            File extBackupDir = this.deploymentsMetadata.getDeploymentExternalBackupDirectory(prevDeploymentId);
            extBackupDirs = new HashMap<String, File>(1);
            extBackupDirs.put("/", extBackupDir);
        }
        for (Map.Entry<String, File> entry : extBackupDirs.entrySet()) {
            String rootDir = entry.getKey();
            File extBackupDir = entry.getValue();
            String extBackupDirBase = extBackupDir.getAbsolutePath();
            if (!extBackupDirBase.endsWith(File.separator)) {
                extBackupDirBase = extBackupDirBase + File.separator;
            }
            this.restoreExternalBackupFilesRecursive(rootDir, extBackupDir, extBackupDirBase, map, diff, dryRun);
        }
    }

    private void restoreBackupFilesRecursive(File file, String base, File destDir, FileHashcodeMap map, DeployDifferences diff, boolean dryRun) throws Exception {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    this.restoreBackupFilesRecursive(child, base, destDir, map, diff, dryRun);
                    continue;
                }
                String childRelativePath = child.getAbsolutePath().substring(base.length());
                File restoredFile = new File(destDir, childRelativePath);
                this.debug("Restoring backup file [", child, "] to [", restoredFile, "]. dryRun=", dryRun);
                if (!dryRun) {
                    restoredFile.getParentFile().mkdirs();
                    String hashcode = this.copyFileAndCalcHashcode(child, restoredFile);
                    map.put(childRelativePath, hashcode);
                } else {
                    map.put(childRelativePath, MessageDigestGenerator.getDigestString(child));
                }
                diff.addRestoredFile(childRelativePath, child.getAbsolutePath());
            }
        }
    }

    private void restoreExternalBackupFilesRecursive(String rootDir, File backupDir, String base, FileHashcodeMap map, DeployDifferences diff, boolean dryRun) throws Exception {
        File[] children = backupDir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    this.restoreExternalBackupFilesRecursive(rootDir, child, base, map, diff, dryRun);
                    continue;
                }
                String childRelativePath = child.getAbsolutePath().substring(base.length());
                File restoredFile = new File(rootDir, childRelativePath);
                this.debug("Restoring backup file [", child, "] to external location [", restoredFile, "]. dryRun=" + dryRun);
                if (!dryRun) {
                    restoredFile.getParentFile().mkdirs();
                    String hashcode = this.copyFileAndCalcHashcode(child, restoredFile);
                    map.put(restoredFile.getAbsolutePath(), hashcode);
                } else {
                    map.put(restoredFile.getAbsolutePath(), MessageDigestGenerator.getDigestString(child));
                }
                diff.addRestoredFile(restoredFile.getAbsolutePath(), child.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyFileAndCalcHashcode(File src, File dest) throws Exception {
        BufferedInputStream is = null;
        FilterOutputStream os = null;
        try {
            is = new BufferedInputStream(new FileInputStream(src));
            os = new BufferedOutputStream(new FileOutputStream(dest));
            StreamCopyDigest copier = new StreamCopyDigest();
            String string = copier.copyAndCalculateHashcode(is, os);
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    private void purgeFileOrDirectory(File fileOrDir, Set<String> skippedFiles, int level, boolean deleteIt) {
        if (fileOrDir != null && !fileOrDir.getName().equals(".rhqdeployments")) {
            File[] doomedFiles;
            if (fileOrDir.isDirectory() && (doomedFiles = fileOrDir.listFiles()) != null) {
                for (File doomedFile : doomedFiles) {
                    if (level == 0 && skippedFiles.contains(doomedFile.getName())) continue;
                    this.purgeFileOrDirectory(doomedFile, skippedFiles, level + 1, true);
                }
            }
            if (deleteIt) {
                fileOrDir.delete();
            }
        }
    }

    private void debug(Object ... objs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.buildLogMessage(objs));
        }
    }

    private String buildLogMessage(Object ... objs) {
        String bundleName = this.deploymentData.getDeploymentProps().getBundleName();
        String bundleVersion = this.deploymentData.getDeploymentProps().getBundleVersion();
        int deploymentId = this.deploymentData.getDeploymentProps().getDeploymentId();
        StringBuilder str = new StringBuilder();
        str.append("Bundle [").append(bundleName).append(" v").append(bundleVersion).append(']');
        str.append("; Deployment [").append(deploymentId).append("]: ");
        for (Object o : objs) {
            str.append(o);
        }
        return str.toString();
    }
}

