/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.proxy;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jline.ConsoleReader;
import org.rhq.bindings.output.TabularWriter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionEnumeration;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.enterprise.client.ClientMain;

public class ConfigurationEditor {
    private ClientMain client;
    private PrintWriter writer;
    private ConsoleReader console;

    public ConfigurationEditor(ClientMain client) {
        this.client = client;
        this.writer = client.getPrintWriter();
        this.console = client.getConsoleReader();
    }

    public Configuration editConfiguration(ConfigurationDefinition def, Configuration config) {
        try {
            Configuration newConfig = config.deepCopy();
            newConfig = this.editExistingConfiguration(def, newConfig);
            block10: while (true) {
                String input = this.console.readLine("[R]eview, [E]dit, Re[V]ert [S]ave or [C]ancel: ");
                char inputChar = input.charAt(0);
                switch (inputChar) {
                    case 'R': 
                    case 'r': {
                        this.printConfiguration(newConfig);
                        continue block10;
                    }
                    case 'E': 
                    case 'e': {
                        this.editExistingConfiguration(def, newConfig);
                        continue block10;
                    }
                    case 'V': 
                    case 'v': {
                        newConfig = config;
                        continue block10;
                    }
                    case 'S': 
                    case 's': {
                        return newConfig;
                    }
                    case 'C': 
                    case 'c': {
                        return null;
                    }
                }
                this.writer.println("unknown option");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (QuitException e) {
            this.writer.println("Cancelling edit");
            return null;
        }
    }

    public Configuration createConfiguration(ConfigurationDefinition def) throws IOException, QuitException {
        if (this.client.isInteractiveMode()) {
            throw new UnsupportedOperationException("Configuration wizard is only available in interactive model.");
        }
        Map templates = def.getTemplates();
        ConfigurationTemplate template = (ConfigurationTemplate)this.question(templates, null, "template", "Select from the available templates");
        return this.editConfiguration(def, template == null ? null : template.createConfiguration());
    }

    public Configuration editExistingConfiguration(ConfigurationDefinition def, Configuration config) throws IOException, QuitException {
        ArrayList groups = new ArrayList(def.getGroupDefinitions());
        if (config == null) {
            config = new Configuration();
        }
        this.writer.println("Non-Grouped Properties: ");
        ArrayList properties = new ArrayList(def.getNonGroupedProperties());
        Collections.sort(properties, new Comparator<PropertyDefinition>(){

            @Override
            public int compare(PropertyDefinition o1, PropertyDefinition o2) {
                return new Integer(o1.getOrder()).compareTo(new Integer(o2.getOrder()));
            }
        });
        for (PropertyDefinition propDef : properties) {
            this.question(propDef, config);
        }
        Collections.sort(groups, new Comparator<PropertyGroupDefinition>(){

            @Override
            public int compare(PropertyGroupDefinition o1, PropertyGroupDefinition o2) {
                return new Integer(o1.getOrder()).compareTo(new Integer(o2.getOrder()));
            }
        });
        for (PropertyGroupDefinition groupDef : groups) {
            this.writer.println("Group: " + groupDef.getDisplayName());
            properties = new ArrayList(def.getPropertiesInGroup(groupDef.getName()));
            Collections.sort(properties, new Comparator<PropertyDefinition>(){

                @Override
                public int compare(PropertyDefinition o1, PropertyDefinition o2) {
                    return new Integer(o1.getOrder()).compareTo(new Integer(o2.getOrder()));
                }
            });
            for (PropertyDefinition propDef : properties) {
                this.question(propDef, config);
            }
        }
        return config;
    }

    private void question(PropertyDefinition definition, Configuration template) throws IOException, QuitException {
        if (definition instanceof PropertyDefinitionSimple) {
            PropertyDefinitionSimple simpleDef = (PropertyDefinitionSimple)definition;
            Object base = null;
            if (template != null && template.getSimple(definition.getName()) != null) {
                List optionList;
                PropertySimple simple = template.getSimple(definition.getName());
                if (simple == null) {
                    simple = new PropertySimple(definition.getName(), null);
                    template.put((Property)simple);
                }
                if ((optionList = simpleDef.getEnumeratedValues()) != null && optionList.size() > 0) {
                    LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
                    for (PropertyDefinitionEnumeration enumValue : simpleDef.getEnumeratedValues()) {
                        options.put(enumValue.getName(), enumValue.getValue());
                    }
                    Object result = this.question(options, simple.getStringValue(), definition.getName(), definition.getDescription());
                    if (result == null) {
                        template.remove(simple.getName());
                    } else {
                        simple.setValue(result);
                    }
                } else {
                    while (true) {
                        String currentValue = simple.getStringValue();
                        String prompt = definition.getName() + (currentValue != null ? "[" + currentValue + "]" : "") + ": ";
                        String input = this.getInput(prompt, definition.getDescription());
                        if (input == null) {
                            template.remove(simple.getName());
                            break;
                        }
                        try {
                            String newval = this.validate(simpleDef, input);
                            simple.setStringValue(newval);
                        }
                        catch (Exception e) {
                            this.writer.println("Invalid value for " + simpleDef.getType().name() + ": " + e.getMessage());
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    public String validate(PropertyDefinitionSimple def, String value) {
        switch (def.getType()) {
            case BOOLEAN: {
                if ("y".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
                    return Boolean.TRUE.toString();
                }
                if (!"n".equalsIgnoreCase(value) && !"no".equalsIgnoreCase(value) && !"f".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) break;
                return Boolean.FALSE.toString();
            }
            case INTEGER: {
                return String.valueOf(Integer.parseInt(value));
            }
            case LONG: {
                return String.valueOf(Long.parseLong(value));
            }
            case FLOAT: {
                return String.valueOf(Float.parseFloat(value));
            }
            case DOUBLE: {
                return String.valueOf(Double.parseDouble(value));
            }
        }
        return null;
    }

    private Object question(Map map, String currentValue, String prompt, String help) throws IOException, QuitException {
        PrintWriter writer = this.client.getPrintWriter();
        if (map != null && map.size() > 0) {
            writer.println("Select a " + prompt + ":");
            int i = 1;
            int currentSelection = -1;
            for (Object key : map.keySet()) {
                if (currentValue != null && currentValue.equals(map.get(key))) {
                    currentSelection = i;
                }
                writer.println("\t" + i++ + ") " + key);
            }
            writer.flush();
            Object answer = null;
            while (answer == null) {
                String input = this.getInput(prompt + "[" + currentSelection + "]:", help);
                int index = -1;
                if (input == null) {
                    return null;
                }
                index = input.length() == 0 ? currentSelection : Integer.parseInt(input);
                if (index == 0) {
                    return null;
                }
                i = 1;
                for (Object templateName : map.keySet()) {
                    if (i++ != index) continue;
                    answer = map.get(templateName);
                    writer.println("\t" + templateName + " selected.");
                }
            }
            return answer;
        }
        return null;
    }

    private void printConfiguration(Configuration configuration) {
        TabularWriter tw = new TabularWriter(this.writer);
        tw.print(configuration);
    }

    private String getInput(String prompt, String extraHelp) throws IOException, QuitException {
        StringBuilder buf = new StringBuilder();
        this.writer.print(prompt);
        this.writer.flush();
        try {
            block11: while (true) {
                int ch = this.console.readVirtualKey();
                switch ((char)ch) {
                    case '\u000b': {
                        throw new QuitException();
                    }
                    case '\u0004': {
                        String string = null;
                        return string;
                    }
                    case '\u0005': {
                        this.writer.println();
                        this.writer.println(extraHelp);
                        this.writer.print(prompt);
                        this.writer.print(buf.toString());
                        this.writer.print(prompt);
                        this.writer.flush();
                        continue block11;
                    }
                    case '\n': {
                        String string = buf.toString();
                        return string;
                    }
                }
                buf.append(ch);
            }
        }
        finally {
            this.writer.println();
            this.writer.flush();
        }
    }

    static class QuitException
    extends Exception {
        QuitException() {
        }
    }
}

