/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.enterprise.server.alert.engine.model.AbstractEnumCacheElement;

public final class AvailabilityCacheElement
extends AbstractEnumCacheElement<AvailabilityType> {
    public AvailabilityCacheElement(AlertConditionOperator operator, AvailabilityType value, int conditionTriggerId) {
        super(operator, (Object)null, value, conditionTriggerId);
    }

    @Override
    public boolean matches(AvailabilityType providedValue, Object ... extraParams) {
        if (null == providedValue) {
            return false;
        }
        boolean result = false;
        switch (this.alertConditionOperator) {
            case AVAIL_GOES_DOWN: {
                result = AvailabilityType.DOWN == providedValue && AvailabilityType.DOWN != this.alertConditionValue;
                break;
            }
            case AVAIL_GOES_NOT_UP: {
                result = AvailabilityType.UP != providedValue && AvailabilityType.UP == this.alertConditionValue;
                break;
            }
            case AVAIL_GOES_UP: {
                result = AvailabilityType.UP == providedValue && AvailabilityType.UP != this.alertConditionValue;
                break;
            }
            case AVAIL_GOES_DISABLED: {
                result = AvailabilityType.DISABLED == providedValue && AvailabilityType.DISABLED != this.alertConditionValue;
                break;
            }
            case AVAIL_GOES_UNKNOWN: {
                result = AvailabilityType.UNKNOWN == providedValue && AvailabilityType.UNKNOWN != this.alertConditionValue;
            }
        }
        this.alertConditionValue = providedValue;
        return result;
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        switch (operator) {
            case AVAIL_GOES_DOWN: 
            case AVAIL_GOES_NOT_UP: 
            case AVAIL_GOES_UP: 
            case AVAIL_GOES_DISABLED: 
            case AVAIL_GOES_UNKNOWN: 
            case AVAIL_DURATION_DOWN: 
            case AVAIL_DURATION_NOT_UP: {
                return operator.getDefaultType();
            }
        }
        return AlertConditionOperator.Type.NONE;
    }
}

