/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.configuration.ConfigurationServerService;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ConfigurationServerServiceImpl
implements ConfigurationServerService {
    private static final Log LOG = LogFactory.getLog(ConfigurationServerServiceImpl.class);

    public void completeConfigurationUpdate(ConfigurationUpdateResponse response) {
        Resource resource;
        ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        int configUpdateId = response.getConfigurationUpdateId();
        ResourceConfigurationUpdate configUpdate = configurationManager.getResourceConfigurationUpdate(subjectManager.getOverlord(), configUpdateId);
        if (configUpdate != null && (resource = configUpdate.getResource()) != null) {
            LOG.debug((Object)("Resource configuration update [" + configUpdate.getId() + "] for " + resource + " completed with status [" + response.getStatus() + "]."));
        }
        configurationManager.completeResourceConfigurationUpdate(response);
        configurationManager.checkForCompletedGroupResourceConfigurationUpdate(configUpdateId);
    }

    public void persistUpdatedResourceConfiguration(int resourceId, Configuration resourceConfiguration) {
        SubjectManagerLocal subjectManager;
        Subject overlord;
        ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
        ResourceConfigurationUpdate update = configurationManager.persistResourceConfigurationUpdateInNewTransaction(overlord = (subjectManager = LookupUtil.getSubjectManager()).getOverlord(), resourceId, resourceConfiguration, ConfigurationUpdateStatus.SUCCESS, null, false);
        if (update == null) {
            LOG.debug((Object)("Not persisting Configuration " + resourceConfiguration + ", since it is identical to the current revision."));
            return;
        }
        Configuration configuration = update.getConfiguration().deepCopy(false);
        configurationManager.setResourceConfiguration(resourceId, configuration);
    }
}

